/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.hooks;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import org.eclipse.jgit.api.errors.AbortedByHookException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.ProcessResult;
import org.eclipse.jgit.util.io.TeeOutputStream;

public abstract class GitHook
implements Callable {
    private final Repository repo;
    private final OutputStream outputStream;
    private final OutputStream errorStream;

    protected GitHook(Repository repository, OutputStream outputStream) {
        this(repository, outputStream, null);
    }

    protected GitHook(Repository repository, OutputStream outputStream, OutputStream outputStream2) {
        this.repo = repository;
        this.outputStream = outputStream;
        this.errorStream = outputStream2;
    }

    public abstract Object call();

    public abstract String getHookName();

    protected Repository getRepository() {
        return this.repo;
    }

    protected String[] getParameters() {
        return new String[0];
    }

    protected String getStdinArgs() {
        return null;
    }

    protected OutputStream getOutputStream() {
        return this.outputStream == null ? System.out : this.outputStream;
    }

    protected OutputStream getErrorStream() {
        return this.errorStream == null ? System.err : this.errorStream;
    }

    protected void doRun() {
        ProcessResult processResult;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TeeOutputStream teeOutputStream = new TeeOutputStream(byteArrayOutputStream, this.getErrorStream());
        Repository repository = this.getRepository();
        FS fS = repository.getFS();
        if (fS == null) {
            fS = FS.DETECTED;
        }
        if ((processResult = fS.runHookIfPresent(repository, this.getHookName(), this.getParameters(), this.getOutputStream(), teeOutputStream, this.getStdinArgs())).isExecutedWithError()) {
            this.handleError(new String(byteArrayOutputStream.toByteArray(), Charset.defaultCharset().name()), processResult);
        }
    }

    protected void handleError(String string, ProcessResult processResult) {
        throw new AbortedByHookException(string, this.getHookName(), processResult.getExitCode());
    }

    public boolean isNativeHookPresent() {
        FS fS = this.getRepository().getFS();
        if (fS == null) {
            fS = FS.DETECTED;
        }
        return fS.findHook(this.getRepository(), this.getHookName()) != null;
    }
}

