/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.hooks;

import java.io.File;
import java.io.PrintStream;
import org.eclipse.jgit.hooks.GitHook;
import org.eclipse.jgit.lib.Repository;

public class CommitMsgHook
extends GitHook {
    public static final String NAME = "commit-msg";
    private String commitMessage;

    protected CommitMsgHook(Repository repository, PrintStream printStream) {
        super(repository, printStream);
    }

    protected CommitMsgHook(Repository repository, PrintStream printStream, PrintStream printStream2) {
        super(repository, printStream, printStream2);
    }

    @Override
    public String call() {
        if (this.commitMessage == null) {
            throw new IllegalStateException();
        }
        if (this.canRun()) {
            this.getRepository().writeCommitEditMsg(this.commitMessage);
            this.doRun();
            this.commitMessage = this.getRepository().readCommitEditMsg();
        }
        return this.commitMessage;
    }

    private boolean canRun() {
        return this.getCommitEditMessageFilePath() != null && this.commitMessage != null;
    }

    @Override
    public String getHookName() {
        return NAME;
    }

    @Override
    protected String[] getParameters() {
        return new String[]{this.getCommitEditMessageFilePath()};
    }

    private String getCommitEditMessageFilePath() {
        File file = this.getRepository().getDirectory();
        if (file == null) {
            return null;
        }
        return Repository.stripWorkDir(this.getRepository().getWorkTree(), new File(file, "COMMIT_EDITMSG"));
    }

    public CommitMsgHook setCommitMessage(String string) {
        this.commitMessage = string;
        return this;
    }
}

