/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.gitrepo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.gitrepo.RepoProject$CopyFile;
import org.eclipse.jgit.gitrepo.RepoProject$LinkFile;

public class RepoProject
implements Comparable {
    private final String name;
    private final String path;
    private final String revision;
    private final String remote;
    private final Set groups;
    private final List copyfiles;
    private final List linkfiles;
    private String recommendShallow;
    private String url;
    private String defaultRevision;

    public RepoProject(String string, String string2, String string3, String string4, Set set, String string5) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.name = string;
        this.path = string2 != null ? string2 : string;
        this.revision = string3;
        this.remote = string4;
        this.groups = set;
        this.recommendShallow = string5;
        this.copyfiles = new ArrayList();
        this.linkfiles = new ArrayList();
    }

    public RepoProject(String string, String string2, String string3, String string4, String string5) {
        this(string, string2, string3, string4, new HashSet(), null);
        if (string5 != null && string5.length() > 0) {
            this.setGroups(string5);
        }
    }

    public RepoProject setUrl(String string) {
        this.url = string;
        return this;
    }

    public RepoProject setGroups(String string) {
        this.groups.clear();
        this.groups.addAll(Arrays.asList(string.split(",")));
        return this;
    }

    public RepoProject setDefaultRevision(String string) {
        this.defaultRevision = string;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getRevision() {
        return this.revision == null ? this.defaultRevision : this.revision;
    }

    public List getCopyFiles() {
        return Collections.unmodifiableList(this.copyfiles);
    }

    public List getLinkFiles() {
        return Collections.unmodifiableList(this.linkfiles);
    }

    public String getUrl() {
        return this.url;
    }

    public String getRemote() {
        return this.remote;
    }

    public boolean inGroup(String string) {
        return this.groups.contains(string);
    }

    public Set getGroups() {
        return this.groups;
    }

    public String getRecommendShallow() {
        return this.recommendShallow;
    }

    public void setRecommendShallow(String string) {
        this.recommendShallow = string;
    }

    public void addCopyFile(RepoProject$CopyFile repoProject$CopyFile) {
        this.copyfiles.add(repoProject$CopyFile);
    }

    public void addCopyFiles(Collection collection) {
        this.copyfiles.addAll(collection);
    }

    public void clearCopyFiles() {
        this.copyfiles.clear();
    }

    public void addLinkFile(RepoProject$LinkFile repoProject$LinkFile) {
        this.linkfiles.add(repoProject$LinkFile);
    }

    public void addLinkFiles(Collection collection) {
        this.linkfiles.addAll(collection);
    }

    public void clearLinkFiles() {
        this.linkfiles.clear();
    }

    private String getPathWithSlash() {
        if (this.path.endsWith("/")) {
            return this.path;
        }
        return this.path + "/";
    }

    public boolean isAncestorOf(RepoProject repoProject) {
        return this.isAncestorOf(repoProject.getPathWithSlash());
    }

    public boolean isAncestorOf(String string) {
        return string.startsWith(this.getPathWithSlash());
    }

    public boolean equals(Object object) {
        if (object instanceof RepoProject) {
            RepoProject repoProject = (RepoProject)object;
            return this.getPathWithSlash().equals(repoProject.getPathWithSlash());
        }
        return false;
    }

    public int hashCode() {
        return this.getPathWithSlash().hashCode();
    }

    public int compareTo(RepoProject repoProject) {
        return this.getPathWithSlash().compareTo(repoProject.getPathWithSlash());
    }
}

