/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.gitrepo;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.TreeMap;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.SubmoduleAddCommand;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.gitrepo.ManifestParser;
import org.eclipse.jgit.gitrepo.RepoCommand$DefaultRemoteReader;
import org.eclipse.jgit.gitrepo.RepoCommand$ManifestErrorException;
import org.eclipse.jgit.gitrepo.RepoCommand$RemoteFile;
import org.eclipse.jgit.gitrepo.RepoCommand$RemoteReader;
import org.eclipse.jgit.gitrepo.RepoCommand$RemoteUnavailableException;
import org.eclipse.jgit.gitrepo.RepoProject;
import org.eclipse.jgit.gitrepo.RepoProject$CopyFile;
import org.eclipse.jgit.gitrepo.RepoProject$LinkFile;
import org.eclipse.jgit.gitrepo.RepoProject$ReferenceFile;
import org.eclipse.jgit.gitrepo.internal.RepoText;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.RefUpdate$Result;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.FileUtils;

public class RepoCommand
extends GitCommand {
    private static final int LOCK_FAILURE_MAX_RETRIES = 5;
    private static final int LOCK_FAILURE_MIN_RETRY_DELAY_MILLIS = 50;
    private static final int LOCK_FAILURE_MAX_RETRY_DELAY_MILLIS = 5000;
    private String manifestPath;
    private String baseUri;
    private URI targetUri;
    private String groupsParam;
    private String branch;
    private String targetBranch = "HEAD";
    private boolean recordRemoteBranch = true;
    private boolean recordSubmoduleLabels = true;
    private boolean recordShallowSubmodules = true;
    private PersonIdent author;
    private RepoCommand$RemoteReader callback;
    private InputStream inputStream;
    private ManifestParser.IncludedFileReader includedReader;
    private boolean ignoreRemoteFailures = false;
    private ProgressMonitor monitor;
    private static final String SLASH = "/";

    public RepoCommand(Repository repository) {
        super(repository);
    }

    public RepoCommand setPath(String string) {
        this.manifestPath = string;
        return this;
    }

    public RepoCommand setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        return this;
    }

    public RepoCommand setURI(String string) {
        this.baseUri = string;
        return this;
    }

    public RepoCommand setTargetURI(String string) {
        this.targetUri = URI.create(string + SLASH);
        return this;
    }

    public RepoCommand setGroups(String string) {
        this.groupsParam = string;
        return this;
    }

    public RepoCommand setBranch(String string) {
        this.branch = string;
        return this;
    }

    public RepoCommand setTargetBranch(String string) {
        this.targetBranch = "refs/heads/" + string;
        return this;
    }

    public RepoCommand setRecordRemoteBranch(boolean bl2) {
        this.recordRemoteBranch = bl2;
        return this;
    }

    public RepoCommand setRecordSubmoduleLabels(boolean bl2) {
        this.recordSubmoduleLabels = bl2;
        return this;
    }

    public RepoCommand setRecommendShallow(boolean bl2) {
        this.recordShallowSubmodules = bl2;
        return this;
    }

    public RepoCommand setProgressMonitor(ProgressMonitor progressMonitor) {
        this.monitor = progressMonitor;
        return this;
    }

    public RepoCommand setIgnoreRemoteFailures(boolean bl2) {
        this.ignoreRemoteFailures = bl2;
        return this;
    }

    public RepoCommand setAuthor(PersonIdent personIdent) {
        this.author = personIdent;
        return this;
    }

    public RepoCommand setRemoteReader(RepoCommand$RemoteReader remoteReader) {
        this.callback = remoteReader;
        return this;
    }

    public RepoCommand setIncludedFileReader(ManifestParser.IncludedFileReader includedFileReader) {
        this.includedReader = includedFileReader;
        return this;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public RevCommit call() {
        List list;
        Object object;
        this.checkCallable();
        if (this.baseUri == null) {
            this.baseUri = "";
        }
        if (this.inputStream == null) {
            if (this.manifestPath == null || this.manifestPath.length() == 0) {
                throw new IllegalArgumentException(JGitText.get().pathNotConfigured);
            }
            try {
                this.inputStream = new FileInputStream(this.manifestPath);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(JGitText.get().pathNotConfigured, iOException);
            }
        }
        try {
            object = new ManifestParser(this.includedReader, this.manifestPath, this.branch, this.baseUri, this.groupsParam, this.repo);
            ((ManifestParser)object).read(this.inputStream);
            list = ((ManifestParser)object).getFilteredProjects();
        }
        catch (IOException iOException) {
            throw new RepoCommand$ManifestErrorException(iOException);
        }
        finally {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (this.repo.isBare()) {
            if (this.author == null) {
                this.author = new PersonIdent(this.repo);
            }
            if (this.callback == null) {
                this.callback = new RepoCommand$DefaultRemoteReader();
            }
            object = this.renameProjects(list);
            DirCache dirCache = DirCache.newInCore();
            DirCacheBuilder dirCacheBuilder = dirCache.builder();
            ObjectInserter objectInserter = this.repo.newObjectInserter();
            try (RevWalk revWalk = new RevWalk(this.repo);){
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                Config config = new Config();
                StringBuilder stringBuilder = new StringBuilder();
                Object object7 = object.iterator();
                while (object7.hasNext()) {
                    Object object8;
                    Iterator iterator2;
                    Object object9;
                    ObjectId objectId;
                    object6 = (RepoProject)object7.next();
                    object5 = ((RepoProject)object6).getName();
                    object4 = ((RepoProject)object6).getPath();
                    object3 = ((RepoProject)object6).getUrl();
                    if (ObjectId.isId(((RepoProject)object6).getRevision())) {
                        objectId = ObjectId.fromString(((RepoProject)object6).getRevision());
                    } else {
                        objectId = this.callback.sha1((String)object3, ((RepoProject)object6).getRevision());
                        if (objectId == null && !this.ignoreRemoteFailures) {
                            throw new RepoCommand$RemoteUnavailableException((String)object3);
                        }
                        if (this.recordRemoteBranch) {
                            object9 = ((RepoProject)object6).getRevision().startsWith("refs/tags/") ? "ref" : "branch";
                            config.setString("submodule", (String)object5, (String)object9, ((RepoProject)object6).getRevision());
                        }
                        if (this.recordShallowSubmodules && ((RepoProject)object6).getRecommendShallow() != null) {
                            config.setBoolean("submodule", (String)object5, "shallow", true);
                        }
                    }
                    if (this.recordSubmoduleLabels) {
                        object9 = new StringBuilder();
                        ((StringBuilder)object9).append(SLASH);
                        ((StringBuilder)object9).append((String)object4);
                        for (Iterator iterator2 : ((RepoProject)object6).getGroups()) {
                            ((StringBuilder)object9).append(" ");
                            ((StringBuilder)object9).append((String)((Object)iterator2));
                        }
                        ((StringBuilder)object9).append("\n");
                        stringBuilder.append(((StringBuilder)object9).toString());
                    }
                    object9 = URI.create((String)object3);
                    if (this.targetUri != null) {
                        object9 = RepoCommand.relativize(this.targetUri, object9);
                    }
                    config.setString("submodule", (String)object5, "path", (String)object4);
                    config.setString("submodule", (String)object5, "url", ((URI)object9).toString());
                    if (objectId == null) continue;
                    object2 = new DirCacheEntry((String)object4);
                    ((DirCacheEntry)object2).setObjectId(objectId);
                    ((DirCacheEntry)object2).setFileMode(FileMode.GITLINK);
                    dirCacheBuilder.add((DirCacheEntry)object2);
                    for (RepoProject$ReferenceFile repoProject$ReferenceFile : ((RepoProject)object6).getCopyFiles()) {
                        object8 = this.callback.readFileWithMode((String)object3, ((RepoProject)object6).getRevision(), repoProject$ReferenceFile.src);
                        objectId = objectInserter.insert(3, ((RepoCommand$RemoteFile)object8).getContents());
                        object2 = new DirCacheEntry(repoProject$ReferenceFile.dest);
                        ((DirCacheEntry)object2).setObjectId(objectId);
                        ((DirCacheEntry)object2).setFileMode(((RepoCommand$RemoteFile)object8).getFileMode());
                        dirCacheBuilder.add((DirCacheEntry)object2);
                    }
                    iterator2 = ((RepoProject)object6).getLinkFiles().iterator();
                    while (iterator2.hasNext()) {
                        RepoProject$ReferenceFile repoProject$ReferenceFile;
                        repoProject$ReferenceFile = (RepoProject$LinkFile)iterator2.next();
                        object8 = ((RepoProject$LinkFile)repoProject$ReferenceFile).dest.contains(SLASH) ? FileUtils.relativizeGitPath(((RepoProject$LinkFile)repoProject$ReferenceFile).dest.substring(0, ((RepoProject$LinkFile)repoProject$ReferenceFile).dest.lastIndexOf(47)), ((RepoProject)object6).getPath() + SLASH + ((RepoProject$LinkFile)repoProject$ReferenceFile).src) : ((RepoProject)object6).getPath() + SLASH + ((RepoProject$LinkFile)repoProject$ReferenceFile).src;
                        objectId = objectInserter.insert(3, ((String)object8).getBytes(StandardCharsets.UTF_8));
                        object2 = new DirCacheEntry(((RepoProject$LinkFile)repoProject$ReferenceFile).dest);
                        ((DirCacheEntry)object2).setObjectId(objectId);
                        ((DirCacheEntry)object2).setFileMode(FileMode.SYMLINK);
                        dirCacheBuilder.add((DirCacheEntry)object2);
                    }
                }
                object7 = config.toText();
                object6 = new DirCacheEntry(".gitmodules");
                object5 = objectInserter.insert(3, ((String)object7).getBytes(StandardCharsets.UTF_8));
                ((DirCacheEntry)object6).setObjectId((AnyObjectId)object5);
                ((DirCacheEntry)object6).setFileMode(FileMode.REGULAR_FILE);
                dirCacheBuilder.add((DirCacheEntry)object6);
                if (this.recordSubmoduleLabels) {
                    object4 = new DirCacheEntry(".gitattributes");
                    object3 = objectInserter.insert(3, stringBuilder.toString().getBytes(StandardCharsets.UTF_8));
                    ((DirCacheEntry)object4).setObjectId((AnyObjectId)object3);
                    ((DirCacheEntry)object4).setFileMode(FileMode.REGULAR_FILE);
                    dirCacheBuilder.add((DirCacheEntry)object4);
                }
                dirCacheBuilder.finish();
                object4 = dirCache.writeTree(objectInserter);
                long l2 = 0L;
                for (int i2 = 0; i2 < 4; ++i2) {
                    try {
                        object2 = this.commitTreeOnCurrentTip(objectInserter, revWalk, (ObjectId)object4);
                        return object2;
                    }
                    catch (ConcurrentRefUpdateException concurrentRefUpdateException) {
                        l2 = FileUtils.delay(l2, 50L, 5000L);
                        Thread.sleep(l2);
                        this.repo.getRefDatabase().refresh();
                        continue;
                    }
                }
                RevCommit revCommit = this.commitTreeOnCurrentTip(objectInserter, revWalk, (ObjectId)object4);
                return revCommit;
            }
            catch (IOException | InterruptedException | GitAPIException exception) {
                throw new RepoCommand$ManifestErrorException(exception);
            }
        }
        try {
            object = new Git(this.repo);
            Throwable throwable = null;
            try {
                for (RepoProject repoProject : list) {
                    this.addSubmodule(repoProject.getName(), repoProject.getUrl(), repoProject.getPath(), repoProject.getRevision(), repoProject.getCopyFiles(), repoProject.getLinkFiles(), (Git)object);
                }
                RevCommit revCommit = ((Git)object).commit().setMessage(RepoText.get().repoCommitMessage).call();
                return revCommit;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((Git)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((Git)object).close();
                    }
                }
            }
        }
        catch (IOException | GitAPIException exception) {
            throw new RepoCommand$ManifestErrorException(exception);
        }
    }

    private RevCommit commitTreeOnCurrentTip(ObjectInserter objectInserter, RevWalk revWalk, ObjectId objectId) {
        ObjectId objectId2 = this.repo.resolve(this.targetBranch + "^{commit}");
        if (objectId2 != null && revWalk.parseCommit(objectId2).getTree().getId().equals(objectId)) {
            return revWalk.parseCommit(objectId2);
        }
        CommitBuilder commitBuilder = new CommitBuilder();
        commitBuilder.setTreeId(objectId);
        if (objectId2 != null) {
            commitBuilder.setParentIds(objectId2);
        }
        commitBuilder.setAuthor(this.author);
        commitBuilder.setCommitter(this.author);
        commitBuilder.setMessage(RepoText.get().repoCommitMessage);
        ObjectId objectId3 = objectInserter.insert(commitBuilder);
        objectInserter.flush();
        RefUpdate refUpdate = this.repo.updateRef(this.targetBranch);
        refUpdate.setNewObjectId(objectId3);
        refUpdate.setExpectedOldObjectId(objectId2 != null ? objectId2 : ObjectId.zeroId());
        RefUpdate$Result refUpdate$Result = refUpdate.update(revWalk);
        switch (refUpdate$Result) {
            case NEW: 
            case FORCED: 
            case FAST_FORWARD: {
                break;
            }
            case REJECTED: 
            case LOCK_FAILURE: {
                throw new ConcurrentRefUpdateException(MessageFormat.format(JGitText.get().cannotLock, this.targetBranch), refUpdate.getRef(), refUpdate$Result);
            }
            default: {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, new Object[]{this.targetBranch, objectId3.name(), refUpdate$Result}));
            }
        }
        return revWalk.parseCommit(objectId3);
    }

    private void addSubmodule(String string, String string2, String string3, String string4, List list, List list2, Git git) {
        assert (!this.repo.isBare());
        assert (git != null);
        if (!list2.isEmpty()) {
            throw new UnsupportedOperationException(JGitText.get().nonBareLinkFilesNotSupported);
        }
        SubmoduleAddCommand submoduleAddCommand = git.submoduleAdd().setName(string).setPath(string3).setURI(string2);
        if (this.monitor != null) {
            submoduleAddCommand.setProgressMonitor(this.monitor);
        }
        Repository repository = submoduleAddCommand.call();
        if (string4 != null) {
            Git git2 = new Git(repository);
            Object object = null;
            try {
                git2.checkout().setName(RepoCommand.findRef(string4, repository)).call();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (git2 != null) {
                    if (object != null) {
                        try {
                            git2.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        git2.close();
                    }
                }
            }
            repository.close();
            git.add().addFilepattern(string3).call();
        }
        for (Object object : list) {
            ((RepoProject$CopyFile)object).copy();
            git.add().addFilepattern(((RepoProject$CopyFile)object).dest).call();
        }
    }

    private List renameProjects(List list) {
        TreeMap<String, ArrayList<Object>> treeMap = new TreeMap<String, ArrayList<Object>>();
        for (Object object : list) {
            List<Object> list2 = (ArrayList<Object>)treeMap.get(((RepoProject)object).getName());
            if (list2 == null) {
                list2 = new ArrayList<Object>();
                treeMap.put(((RepoProject)object).getName(), (ArrayList<Object>)list2);
            }
            list2.add(object);
        }
        ArrayList arrayList = new ArrayList();
        for (List<Object> list2 : treeMap.values()) {
            boolean bl2 = list2.size() != 1;
            for (RepoProject repoProject : list2) {
                String string = repoProject.getName();
                if (bl2) {
                    string = string + SLASH + repoProject.getPath();
                }
                RepoProject repoProject2 = new RepoProject(string, repoProject.getPath(), repoProject.getRevision(), null, repoProject.getGroups(), repoProject.getRecommendShallow());
                repoProject2.setUrl(repoProject.getUrl());
                repoProject2.addCopyFiles(repoProject.getCopyFiles());
                repoProject2.addLinkFiles(repoProject.getLinkFiles());
                arrayList.add(repoProject2);
            }
        }
        return arrayList;
    }

    static URI relativize(URI uRI, URI uRI2) {
        int n2;
        String string;
        if (!Objects.equals(uRI.getHost(), uRI2.getHost())) {
            return uRI2;
        }
        String string2 = uRI.normalize().getPath();
        String string3 = uRI2.normalize().getPath();
        if (string2.startsWith(SLASH) != string3.startsWith(SLASH)) {
            return uRI2;
        }
        while (string2.startsWith(SLASH)) {
            string2 = string2.substring(1);
        }
        while (string3.startsWith(SLASH)) {
            string3 = string3.substring(1);
        }
        if (string2.indexOf(47) == -1 || string3.indexOf(47) == -1) {
            string = "prefix/";
            string2 = string + string2;
            string3 = string + string3;
        }
        if (!string2.endsWith(SLASH)) {
            int n3 = string2.lastIndexOf(47);
            string2 = string2.substring(0, n3);
        }
        string = "";
        if (!string3.endsWith(SLASH)) {
            int n4 = string3.lastIndexOf(47);
            string = string3.substring(n4 + 1, string3.length());
            string3 = string3.substring(0, string3.lastIndexOf(47));
        }
        String[] stringArray = string2.split(SLASH);
        String[] stringArray2 = string3.split(SLASH);
        for (int i2 = 0; i2 < stringArray.length && i2 < stringArray2.length && stringArray[i2].equals(stringArray2[i2]); ++i2) {
        }
        StringJoiner stringJoiner = new StringJoiner(SLASH);
        for (n2 = i2; n2 < stringArray.length; ++n2) {
            stringJoiner.add("..");
        }
        for (n2 = i2; n2 < stringArray2.length; ++n2) {
            stringJoiner.add(stringArray2[n2]);
        }
        stringJoiner.add(string);
        return URI.create(stringJoiner.toString());
    }

    private static String findRef(String string, Repository repository) {
        Ref ref;
        if (!ObjectId.isId(string) && (ref = repository.exactRef("refs/remotes/origin/" + string)) != null) {
            return ref.getName();
        }
        return string;
    }
}

