/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.gitrepo;

import java.io.File;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.gitrepo.RepoCommand$RemoteFile;
import org.eclipse.jgit.gitrepo.RepoCommand$RemoteReader;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.FileUtils;

public class RepoCommand$DefaultRemoteReader
implements RepoCommand$RemoteReader {
    @Override
    public ObjectId sha1(String string, String string2) {
        Map map = Git.lsRemoteRepository().setRemote(string).callAsMap();
        Ref ref = RefDatabase.findRef(map, string2);
        return ref != null ? ref.getObjectId() : null;
    }

    /*
     * Loose catch block
     */
    @Override
    public RepoCommand$RemoteFile readFileWithMode(String string, String string2, String string3) {
        File file = FileUtils.createTempDir("jgit_", ".git", null);
        try {
            try (Git git = Git.cloneRepository().setBare(true).setDirectory(file).setURI(string).call();){
                Repository repository = git.getRepository();
                ObjectId objectId = this.sha1(string, string2);
                if (objectId == null) {
                    throw new InvalidRefNameException(MessageFormat.format(JGitText.get().refNotResolved, string2));
                }
                RevCommit revCommit = repository.parseCommit(objectId);
                TreeWalk treeWalk = TreeWalk.forPath(repository, string3, revCommit.getTree());
                RepoCommand$RemoteFile repoCommand$RemoteFile = new RepoCommand$RemoteFile(treeWalk.getObjectReader().open(treeWalk.getObjectId(0)).getCachedBytes(Integer.MAX_VALUE), treeWalk.getFileMode(0));
                return repoCommand$RemoteFile;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            FileUtils.delete(file, 1);
        }
    }
}

