/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.gitrepo;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.gitrepo.ManifestParser$IncludedFileReader;
import org.eclipse.jgit.gitrepo.ManifestParser$Remote;
import org.eclipse.jgit.gitrepo.RepoProject;
import org.eclipse.jgit.gitrepo.RepoProject$CopyFile;
import org.eclipse.jgit.gitrepo.RepoProject$LinkFile;
import org.eclipse.jgit.gitrepo.RepoProject$ReferenceFile;
import org.eclipse.jgit.gitrepo.internal.RepoText;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ManifestParser
extends DefaultHandler {
    private final String filename;
    private final URI baseUrl;
    private final String defaultBranch;
    private final Repository rootRepo;
    private final Map remotes;
    private final Set plusGroups;
    private final Set minusGroups;
    private final List projects;
    private final List filteredProjects;
    private final ManifestParser$IncludedFileReader includedReader;
    private String defaultRemote;
    private String defaultRevision;
    private int xmlInRead;
    private RepoProject currentProject;

    public ManifestParser(ManifestParser$IncludedFileReader includedFileReader, String string, String string2, String string3, String string4, Repository repository) {
        this.includedReader = includedFileReader;
        this.filename = string;
        this.defaultBranch = string2;
        this.rootRepo = repository;
        this.baseUrl = ManifestParser.normalizeEmptyPath(URI.create(string3));
        this.plusGroups = new HashSet();
        this.minusGroups = new HashSet();
        if (string4 == null || string4.length() == 0 || string4.equals("default")) {
            this.minusGroups.add("notdefault");
        } else {
            for (String string5 : string4.split(",")) {
                if (string5.startsWith("-")) {
                    this.minusGroups.add(string5.substring(1));
                    continue;
                }
                this.plusGroups.add(string5);
            }
        }
        this.remotes = new HashMap();
        this.projects = new ArrayList();
        this.filteredProjects = new ArrayList();
    }

    public void read(InputStream inputStream) {
        XMLReader xMLReader;
        ++this.xmlInRead;
        try {
            xMLReader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException sAXException) {
            throw new IOException(JGitText.get().noXMLParserAvailable, sAXException);
        }
        xMLReader.setContentHandler(this);
        try {
            xMLReader.parse(new InputSource(inputStream));
        }
        catch (SAXException sAXException) {
            throw new IOException(RepoText.get().errorParsingManifestFile, sAXException);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void startElement(String var1_1, String var2_2, String var3_3, Attributes var4_4) {
        if (var3_3 == null) {
            return;
        }
        var5_5 = var3_3;
        var6_6 = -1;
        switch (var5_5.hashCode()) {
            case -309310695: {
                if (!var5_5.equals("project")) break;
                var6_6 = 0;
                break;
            }
            case -934610874: {
                if (!var5_5.equals("remote")) break;
                var6_6 = 1;
                break;
            }
            case 1544803905: {
                if (!var5_5.equals("default")) break;
                var6_6 = 2;
                break;
            }
            case -505421199: {
                if (!var5_5.equals("copyfile")) break;
                var6_6 = 3;
                break;
            }
            case 1194727542: {
                if (!var5_5.equals("linkfile")) break;
                var6_6 = 4;
                break;
            }
            case 1942574248: {
                if (!var5_5.equals("include")) break;
                var6_6 = 5;
                break;
            }
            case -851352880: {
                if (!var5_5.equals("remove-project")) break;
                var6_6 = 6;
            }
        }
        switch (var6_6) {
            case 0: {
                if (var4_4.getValue("name") == null) {
                    throw new SAXException(RepoText.get().invalidManifest);
                }
                this.currentProject = new RepoProject(var4_4.getValue("name"), var4_4.getValue("path"), var4_4.getValue("revision"), var4_4.getValue("remote"), var4_4.getValue("groups"));
                this.currentProject.setRecommendShallow(var4_4.getValue("clone-depth"));
                break;
            }
            case 1: {
                var7_7 = var4_4.getValue("alias");
                var8_8 = var4_4.getValue("fetch");
                var9_9 = var4_4.getValue("revision");
                var10_10 = new ManifestParser$Remote(var8_8, var9_9);
                this.remotes.put(var4_4.getValue("name"), var10_10);
                if (var7_7 == null) break;
                this.remotes.put(var7_7, var10_10);
                break;
            }
            case 2: {
                this.defaultRemote = var4_4.getValue("remote");
                this.defaultRevision = var4_4.getValue("revision");
                break;
            }
            case 3: {
                if (this.currentProject == null) {
                    throw new SAXException(RepoText.get().invalidManifest);
                }
                this.currentProject.addCopyFile(new RepoProject$CopyFile(this.rootRepo, this.currentProject.getPath(), var4_4.getValue("src"), var4_4.getValue("dest")));
                break;
            }
            case 4: {
                if (this.currentProject == null) {
                    throw new SAXException(RepoText.get().invalidManifest);
                }
                this.currentProject.addLinkFile(new RepoProject$LinkFile(this.rootRepo, this.currentProject.getPath(), var4_4.getValue("src"), var4_4.getValue("dest")));
                break;
            }
            case 5: {
                var11_11 = var4_4.getValue("name");
                if (this.includedReader == null) ** GOTO lbl103
                try {
                    var12_12 = this.includedReader.readIncludeFile(var11_11);
                    var13_16 = null;
                    if (var12_12 == null) {
                        throw new SAXException(RepoText.get().errorIncludeNotImplemented);
                    }
                    this.read(var12_12);
                    if (var12_12 == null) break;
                    if (var13_16 == null) ** GOTO lbl83
                    try {
                        var12_12.close();
                    }
                    catch (Throwable var14_18) {
                        var13_16.addSuppressed(var14_18);
                    }
                    break;
lbl83:
                    // 1 sources

                    var12_12.close();
                    ** break;
                    catch (Throwable var14_19) {
                        try {
                            var13_16 = var14_19;
                            throw var14_19;
                        }
                        catch (Throwable var15_22) {
                            if (var12_12 != null) {
                                if (var13_16 != null) {
                                    try {
                                        var12_12.close();
                                    }
                                    catch (Throwable var16_24) {
                                        var13_16.addSuppressed(var16_24);
                                    }
                                } else {
                                    var12_12.close();
                                }
                            }
                            throw var15_22;
lbl100:
                            // 1 sources

                            break;
                        }
                    }
                }
                catch (Exception var12_13) {
                    throw new SAXException(MessageFormat.format(RepoText.get().errorIncludeFile, new Object[]{var11_11}), var12_13);
                }
lbl103:
                // 1 sources

                if (this.filename == null) break;
                var12_14 = this.filename.lastIndexOf(47);
                var13_17 = this.filename.substring(0, var12_14 + 1) + var11_11;
                try {
                    var14_20 = new FileInputStream(var13_17);
                    var15_23 = null;
                    this.read(var14_20);
                    if (var14_20 == null) break;
                    if (var15_23 == null) ** GOTO lbl119
                    try {
                        var14_20.close();
                    }
                    catch (Throwable var16_25) {
                        var15_23.addSuppressed(var16_25);
                    }
                    break;
lbl119:
                    // 1 sources

                    var14_20.close();
                    ** break;
                    catch (Throwable var16_26) {
                        try {
                            var15_23 = var16_26;
                            throw var16_26;
                        }
                        catch (Throwable var17_27) {
                            if (var14_20 != null) {
                                if (var15_23 != null) {
                                    try {
                                        var14_20.close();
                                    }
                                    catch (Throwable var18_28) {
                                        var15_23.addSuppressed(var18_28);
                                    }
                                } else {
                                    var14_20.close();
                                }
                            }
                            throw var17_27;
lbl136:
                            // 1 sources

                            break;
                        }
                    }
                }
                catch (IOException var14_21) {
                    throw new SAXException(MessageFormat.format(RepoText.get().errorIncludeFile, new Object[]{var13_17}), var14_21);
                }
            }
            case 6: {
                var12_15 = var4_4.getValue("name");
                this.projects.removeIf((Predicate<RepoProject>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$startElement$0(java.lang.String org.eclipse.jgit.gitrepo.RepoProject ), (Lorg/eclipse/jgit/gitrepo/RepoProject;)Z)((String)var12_15));
                break;
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        if ("project".equals(string3)) {
            this.projects.add(this.currentProject);
            this.currentProject = null;
        }
    }

    @Override
    public void endDocument() {
        --this.xmlInRead;
        if (this.xmlInRead != 0) {
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this.defaultRevision == null && this.defaultRemote != null) {
            ManifestParser$Remote manifestParser$Remote = (ManifestParser$Remote)this.remotes.get(this.defaultRemote);
            if (manifestParser$Remote != null) {
                this.defaultRevision = manifestParser$Remote.revision;
            }
            if (this.defaultRevision == null) {
                this.defaultRevision = this.defaultBranch;
            }
        }
        for (RepoProject repoProject : this.projects) {
            Object object;
            String string = repoProject.getRemote();
            String string2 = this.defaultRevision;
            if (string == null) {
                if (this.defaultRemote == null) {
                    if (this.filename != null) {
                        throw new SAXException(MessageFormat.format(RepoText.get().errorNoDefaultFilename, this.filename));
                    }
                    throw new SAXException(RepoText.get().errorNoDefault);
                }
                string = this.defaultRemote;
            } else {
                object = (ManifestParser$Remote)this.remotes.get(string);
                if (object != null && ((ManifestParser$Remote)object).revision != null) {
                    string2 = ((ManifestParser$Remote)object).revision;
                }
            }
            object = (URI)hashMap.get(string);
            if (object == null) {
                String string3 = ((ManifestParser$Remote)this.remotes.get((Object)string)).fetch;
                if (string3 == null) {
                    throw new SAXException(MessageFormat.format(RepoText.get().errorNoFetch, string));
                }
                object = ManifestParser.normalizeEmptyPath(this.baseUrl.resolve(string3));
                hashMap.put(string, object);
            }
            repoProject.setUrl(((URI)object).resolve(repoProject.getName()).toString()).setDefaultRevision(string2);
        }
        this.filteredProjects.addAll(this.projects);
        this.removeNotInGroup();
        this.removeOverlaps();
    }

    static URI normalizeEmptyPath(URI uRI) {
        if (uRI.getHost() != null && !uRI.getHost().isEmpty() && (uRI.getPath() == null || uRI.getPath().isEmpty())) {
            try {
                return new URI(uRI.getScheme(), uRI.getUserInfo(), uRI.getHost(), uRI.getPort(), "/", uRI.getQuery(), uRI.getFragment());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException(uRISyntaxException.getMessage(), uRISyntaxException);
            }
        }
        return uRI;
    }

    public List getProjects() {
        return this.projects;
    }

    @NonNull
    public List getFilteredProjects() {
        return this.filteredProjects;
    }

    void removeNotInGroup() {
        Iterator iterator = this.filteredProjects.iterator();
        while (iterator.hasNext()) {
            if (this.inGroups((RepoProject)iterator.next())) continue;
            iterator.remove();
        }
    }

    void removeOverlaps() {
        Collections.sort(this.filteredProjects);
        Iterator iterator = this.filteredProjects.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        RepoProject repoProject = (RepoProject)iterator.next();
        while (iterator.hasNext()) {
            RepoProject repoProject2 = (RepoProject)iterator.next();
            if (repoProject.isAncestorOf(repoProject2)) {
                iterator.remove();
                continue;
            }
            repoProject = repoProject2;
        }
        this.removeNestedCopyAndLinkfiles();
    }

    private void removeNestedCopyAndLinkfiles() {
        for (RepoProject repoProject : this.filteredProjects) {
            Object object2;
            ArrayList arrayList = new ArrayList(repoProject.getCopyFiles());
            repoProject.clearCopyFiles();
            for (Object object2 : arrayList) {
                if (this.isNestedReferencefile((RepoProject$ReferenceFile)object2)) continue;
                repoProject.addCopyFile((RepoProject$CopyFile)object2);
            }
            ArrayList arrayList2 = new ArrayList(repoProject.getLinkFiles());
            repoProject.clearLinkFiles();
            object2 = arrayList2.iterator();
            while (object2.hasNext()) {
                RepoProject$LinkFile repoProject$LinkFile = (RepoProject$LinkFile)object2.next();
                if (this.isNestedReferencefile(repoProject$LinkFile)) continue;
                repoProject.addLinkFile(repoProject$LinkFile);
            }
        }
    }

    boolean inGroups(RepoProject repoProject) {
        for (String string : this.minusGroups) {
            if (!repoProject.inGroup(string)) continue;
            return false;
        }
        if (this.plusGroups.isEmpty() || this.plusGroups.contains("all")) {
            return true;
        }
        for (String string : this.plusGroups) {
            if (!repoProject.inGroup(string)) continue;
            return true;
        }
        return false;
    }

    private boolean isNestedReferencefile(RepoProject$ReferenceFile repoProject$ReferenceFile) {
        if (repoProject$ReferenceFile.dest.indexOf(47) == -1) {
            return false;
        }
        for (RepoProject repoProject : this.filteredProjects) {
            if (repoProject.getPath().compareTo(repoProject$ReferenceFile.dest) > 0) {
                return false;
            }
            if (!repoProject.isAncestorOf(repoProject$ReferenceFile.dest)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$startElement$0(String string, RepoProject repoProject) {
        return repoProject.getName().equals(string);
    }
}

