/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.fnmatch;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.fnmatch.AbstractHead;
import org.eclipse.jgit.fnmatch.GroupHead$CharacterPattern;
import org.eclipse.jgit.fnmatch.GroupHead$CharacterRange;
import org.eclipse.jgit.fnmatch.GroupHead$DigitPattern;
import org.eclipse.jgit.fnmatch.GroupHead$LetterPattern;
import org.eclipse.jgit.fnmatch.GroupHead$LowerPattern;
import org.eclipse.jgit.fnmatch.GroupHead$OneCharacterPattern;
import org.eclipse.jgit.fnmatch.GroupHead$PunctPattern;
import org.eclipse.jgit.fnmatch.GroupHead$UpperPattern;
import org.eclipse.jgit.fnmatch.GroupHead$WhitespacePattern;
import org.eclipse.jgit.internal.JGitText;

final class GroupHead
extends AbstractHead {
    private final List characterClasses = new ArrayList();
    private static final Pattern REGEX_PATTERN = Pattern.compile("([^-][-][^-]|\\[[.:=].*?[.:=]\\])");
    private final boolean inverse;

    GroupHead(String string, String string2) {
        super(false);
        char c2;
        this.inverse = string.startsWith("!");
        if (this.inverse) {
            string = string.substring(1);
        }
        Matcher matcher = REGEX_PATTERN.matcher(string);
        while (matcher.find()) {
            String string3 = matcher.group(0);
            if (string3.length() == 3 && string3.charAt(1) == '-') {
                c2 = string3.charAt(0);
                char c3 = string3.charAt(2);
                this.characterClasses.add(new GroupHead$CharacterRange(c2, c3));
            } else if (string3.equals("[:alnum:]")) {
                this.characterClasses.add(GroupHead$LetterPattern.INSTANCE);
                this.characterClasses.add(GroupHead$DigitPattern.INSTANCE);
            } else if (string3.equals("[:alpha:]")) {
                this.characterClasses.add(GroupHead$LetterPattern.INSTANCE);
            } else if (string3.equals("[:blank:]")) {
                this.characterClasses.add(new GroupHead$OneCharacterPattern(' '));
                this.characterClasses.add(new GroupHead$OneCharacterPattern('\t'));
            } else if (string3.equals("[:cntrl:]")) {
                this.characterClasses.add(new GroupHead$CharacterRange('\u0000', '\u001f'));
                this.characterClasses.add(new GroupHead$OneCharacterPattern('\u007f'));
            } else if (string3.equals("[:digit:]")) {
                this.characterClasses.add(GroupHead$DigitPattern.INSTANCE);
            } else if (string3.equals("[:graph:]")) {
                this.characterClasses.add(new GroupHead$CharacterRange('!', '~'));
                this.characterClasses.add(GroupHead$LetterPattern.INSTANCE);
                this.characterClasses.add(GroupHead$DigitPattern.INSTANCE);
            } else if (string3.equals("[:lower:]")) {
                this.characterClasses.add(GroupHead$LowerPattern.INSTANCE);
            } else if (string3.equals("[:print:]")) {
                this.characterClasses.add(new GroupHead$CharacterRange(' ', '~'));
                this.characterClasses.add(GroupHead$LetterPattern.INSTANCE);
                this.characterClasses.add(GroupHead$DigitPattern.INSTANCE);
            } else if (string3.equals("[:punct:]")) {
                this.characterClasses.add(GroupHead$PunctPattern.INSTANCE);
            } else if (string3.equals("[:space:]")) {
                this.characterClasses.add(GroupHead$WhitespacePattern.INSTANCE);
            } else if (string3.equals("[:upper:]")) {
                this.characterClasses.add(GroupHead$UpperPattern.INSTANCE);
            } else if (string3.equals("[:xdigit:]")) {
                this.characterClasses.add(new GroupHead$CharacterRange('0', '9'));
                this.characterClasses.add(new GroupHead$CharacterRange('a', 'f'));
                this.characterClasses.add(new GroupHead$CharacterRange('A', 'F'));
            } else if (string3.equals("[:word:]")) {
                this.characterClasses.add(new GroupHead$OneCharacterPattern('_'));
                this.characterClasses.add(GroupHead$LetterPattern.INSTANCE);
                this.characterClasses.add(GroupHead$DigitPattern.INSTANCE);
            } else {
                String string4 = MessageFormat.format(JGitText.get().characterClassIsNotSupported, string3);
                throw new InvalidPatternException(string4, string2);
            }
            string = matcher.replaceFirst("");
            matcher.reset(string);
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            c2 = string.charAt(i2);
            this.characterClasses.add(new GroupHead$OneCharacterPattern(c2));
        }
    }

    @Override
    protected final boolean matches(char c2) {
        for (GroupHead$CharacterPattern groupHead$CharacterPattern : this.characterClasses) {
            if (!groupHead$CharacterPattern.matches(c2)) continue;
            return !this.inverse;
        }
        return this.inverse;
    }
}

