/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.fnmatch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.errors.NoClosingBracketException;
import org.eclipse.jgit.fnmatch.AbstractHead;
import org.eclipse.jgit.fnmatch.CharacterHead;
import org.eclipse.jgit.fnmatch.GroupHead;
import org.eclipse.jgit.fnmatch.Head;
import org.eclipse.jgit.fnmatch.LastHead;
import org.eclipse.jgit.fnmatch.RestrictedWildCardHead;
import org.eclipse.jgit.fnmatch.WildCardHead;

public class FileNameMatcher {
    static final List EMPTY_HEAD_LIST = Collections.emptyList();
    private static final Pattern characterClassStartPattern = Pattern.compile("\\[[.:=]");
    private List headsStartValue;
    private List heads;
    private List listForLocalUseage;

    private FileNameMatcher(List list) {
        this(list, list);
    }

    private FileNameMatcher(List list, List list2) {
        this.headsStartValue = list;
        this.heads = new ArrayList(list2.size());
        this.heads.addAll(list2);
        this.listForLocalUseage = new ArrayList(list2.size());
    }

    public FileNameMatcher(String string, Character c2) {
        this(FileNameMatcher.createHeadsStartValues(string, c2));
    }

    public FileNameMatcher(FileNameMatcher fileNameMatcher) {
        this(fileNameMatcher.headsStartValue, fileNameMatcher.heads);
    }

    private static List createHeadsStartValues(String string, Character c2) {
        List list = FileNameMatcher.parseHeads(string, c2);
        ArrayList<Head> arrayList = new ArrayList<Head>(2);
        arrayList.add(LastHead.INSTANCE);
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            AbstractHead abstractHead = (AbstractHead)list.get(i2);
            if (abstractHead.isStar()) {
                arrayList.add(abstractHead);
                abstractHead.setNewHeads(arrayList);
                continue;
            }
            abstractHead.setNewHeads(arrayList);
            arrayList = new ArrayList(2);
            arrayList.add(abstractHead);
        }
        return arrayList;
    }

    private static int findGroupEnd(int n2, String string) {
        int n3 = n2 + 1;
        int n4 = n2 + 2;
        if (n2 + 1 >= string.length()) {
            throw new NoClosingBracketException(n2, "[", "]", string);
        }
        if (string.charAt(n3) == '!') {
            ++n3;
            ++n4;
        }
        Matcher matcher = characterClassStartPattern.matcher(string);
        int n5 = -1;
        while (n5 == -1) {
            int n6 = FileNameMatcher.indexOfUnescaped(string, ']', n4);
            if (n6 == -1) {
                throw new NoClosingBracketException(n2, "[", "]", string);
            }
            boolean bl2 = matcher.find(n3);
            if (bl2 && matcher.start() < n6) {
                int n7;
                String string2 = matcher.group(0);
                String string3 = string2.charAt(1) + "]";
                int n8 = string.indexOf(string3, (n7 = matcher.start()) + 2);
                if (n8 == -1) {
                    throw new NoClosingBracketException(n7, string2, string3, string);
                }
                n4 = n3 = n8 + 2;
                continue;
            }
            n5 = n6;
        }
        return n5;
    }

    private static List parseHeads(String string, Character c2) {
        int n2 = 0;
        ArrayList<GroupHead> arrayList = new ArrayList<GroupHead>();
        while (n2 < string.length()) {
            String string2;
            int n3 = FileNameMatcher.indexOfUnescaped(string, '[', n2);
            if (n3 == -1) {
                string2 = string.substring(n2);
                arrayList.addAll(FileNameMatcher.createSimpleHeads(string2, c2));
                n2 = string.length();
                continue;
            }
            string2 = string.substring(n2, n3);
            arrayList.addAll(FileNameMatcher.createSimpleHeads(string2, c2));
            int n4 = FileNameMatcher.findGroupEnd(n3, string);
            String string3 = string.substring(n3 + 1, n4);
            arrayList.add(new GroupHead(string3, string));
            n2 = n4 + 1;
        }
        return arrayList;
    }

    private static List createSimpleHeads(String string, Character c2) {
        ArrayList<CharacterHead> arrayList = new ArrayList<CharacterHead>(string.length());
        boolean bl2 = false;
        block5: for (int i2 = 0; i2 < string.length(); ++i2) {
            AbstractHead abstractHead;
            char c3 = string.charAt(i2);
            if (bl2) {
                abstractHead = new CharacterHead(c3);
                arrayList.add((CharacterHead)abstractHead);
                bl2 = false;
                continue;
            }
            switch (c3) {
                case '*': {
                    abstractHead = FileNameMatcher.createWildCardHead(c2, true);
                    arrayList.add((CharacterHead)abstractHead);
                    continue block5;
                }
                case '?': {
                    abstractHead = FileNameMatcher.createWildCardHead(c2, false);
                    arrayList.add((CharacterHead)abstractHead);
                    continue block5;
                }
                case '\\': {
                    bl2 = true;
                    continue block5;
                }
                default: {
                    abstractHead = new CharacterHead(c3);
                    arrayList.add((CharacterHead)abstractHead);
                }
            }
        }
        return arrayList;
    }

    private static AbstractHead createWildCardHead(Character c2, boolean bl2) {
        if (c2 != null) {
            return new RestrictedWildCardHead(c2.charValue(), bl2);
        }
        return new WildCardHead(bl2);
    }

    private boolean extendStringToMatchByOneCharacter(char c2) {
        List list = this.listForLocalUseage;
        list.clear();
        List list2 = null;
        for (int i2 = 0; i2 < this.heads.size(); ++i2) {
            Head head = (Head)this.heads.get(i2);
            List list3 = head.getNextHeads(c2);
            if (list3 == list2) continue;
            if (!list3.isEmpty()) {
                list.addAll(list3);
            }
            list2 = list3;
        }
        this.listForLocalUseage = this.heads;
        this.heads = list;
        return !list.isEmpty();
    }

    private static int indexOfUnescaped(String string, char c2, int n2) {
        for (int i2 = n2; i2 < string.length(); ++i2) {
            char c3 = string.charAt(i2);
            if (c3 == c2) {
                return i2;
            }
            if (c3 != '\\') continue;
            ++i2;
        }
        return -1;
    }

    public void append(String string) {
        char c2;
        for (int i2 = 0; i2 < string.length() && this.extendStringToMatchByOneCharacter(c2 = string.charAt(i2)); ++i2) {
        }
    }

    public void reset() {
        this.heads.clear();
        this.heads.addAll(this.headsStartValue);
    }

    public FileNameMatcher createMatcherForSuffix() {
        ArrayList arrayList = new ArrayList(this.heads.size());
        arrayList.addAll(this.heads);
        return new FileNameMatcher(arrayList);
    }

    public boolean isMatch() {
        if (this.heads.isEmpty()) {
            return false;
        }
        ListIterator listIterator = this.heads.listIterator(this.heads.size());
        while (listIterator.hasPrevious()) {
            Head head = (Head)listIterator.previous();
            if (head != LastHead.INSTANCE) continue;
            return true;
        }
        return false;
    }

    public boolean canAppendMatch() {
        for (Head head : this.heads) {
            if (head == LastHead.INSTANCE) continue;
            return true;
        }
        return false;
    }
}

