/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.events;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jgit.events.ConfigChangedListener;
import org.eclipse.jgit.events.IndexChangedListener;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.RefsChangedListener;
import org.eclipse.jgit.events.RepositoryEvent;
import org.eclipse.jgit.events.RepositoryListener;
import org.eclipse.jgit.events.WorkingTreeModifiedListener;

public class ListenerList {
    private final Map lists = new ConcurrentHashMap();

    public ListenerHandle addWorkingTreeModifiedListener(WorkingTreeModifiedListener workingTreeModifiedListener) {
        return this.addListener(WorkingTreeModifiedListener.class, workingTreeModifiedListener);
    }

    public ListenerHandle addIndexChangedListener(IndexChangedListener indexChangedListener) {
        return this.addListener(IndexChangedListener.class, indexChangedListener);
    }

    public ListenerHandle addRefsChangedListener(RefsChangedListener refsChangedListener) {
        return this.addListener(RefsChangedListener.class, refsChangedListener);
    }

    public ListenerHandle addConfigChangedListener(ConfigChangedListener configChangedListener) {
        return this.addListener(ConfigChangedListener.class, configChangedListener);
    }

    public ListenerHandle addListener(Class clazz, RepositoryListener repositoryListener) {
        ListenerHandle listenerHandle = new ListenerHandle(this, clazz, repositoryListener);
        this.add(listenerHandle);
        return listenerHandle;
    }

    public void dispatch(RepositoryEvent repositoryEvent) {
        List list = (List)this.lists.get(repositoryEvent.getListenerType());
        if (list != null) {
            for (ListenerHandle listenerHandle : list) {
                repositoryEvent.dispatch(listenerHandle.listener);
            }
        }
    }

    private void add(ListenerHandle listenerHandle) {
        CopyOnWriteArrayList<ListenerHandle> copyOnWriteArrayList;
        CopyOnWriteArrayList<ListenerHandle> copyOnWriteArrayList2 = (CopyOnWriteArrayList<ListenerHandle>)this.lists.get(listenerHandle.type);
        if (copyOnWriteArrayList2 == null && (copyOnWriteArrayList2 = (List)this.lists.putIfAbsent(listenerHandle.type, copyOnWriteArrayList = new CopyOnWriteArrayList<ListenerHandle>())) == null) {
            copyOnWriteArrayList2 = copyOnWriteArrayList;
        }
        copyOnWriteArrayList2.add(listenerHandle);
    }

    void remove(ListenerHandle listenerHandle) {
        List list = (List)this.lists.get(listenerHandle.type);
        if (list != null) {
            list.remove(listenerHandle);
        }
    }
}

