/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.errors;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;

public class MissingObjectException
extends IOException {
    private static final long serialVersionUID = 1L;
    private final ObjectId missing;

    public MissingObjectException(ObjectId objectId, String string) {
        super(MessageFormat.format(JGitText.get().missingObject, string, objectId.name()));
        this.missing = objectId.copy();
    }

    public MissingObjectException(ObjectId objectId, int n2) {
        this(objectId, Constants.typeString(n2));
    }

    public MissingObjectException(AbbreviatedObjectId abbreviatedObjectId, int n2) {
        super(MessageFormat.format(JGitText.get().missingObject, Constants.typeString(n2), abbreviatedObjectId.name()));
        this.missing = null;
    }

    public ObjectId getObjectId() {
        return this.missing;
    }
}

