/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.errors;

import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;

public class LargeObjectException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private ObjectId objectId;

    public LargeObjectException() {
    }

    public LargeObjectException(Throwable throwable) {
        this.initCause(throwable);
    }

    public LargeObjectException(AnyObjectId anyObjectId) {
        this.setObjectId(anyObjectId);
    }

    public ObjectId getObjectId() {
        return this.objectId;
    }

    protected String getObjectName() {
        if (this.getObjectId() != null) {
            return this.getObjectId().name();
        }
        return JGitText.get().unknownObject;
    }

    public void setObjectId(AnyObjectId anyObjectId) {
        if (this.objectId == null) {
            this.objectId = anyObjectId.copy();
        }
    }

    @Override
    public String getMessage() {
        return MessageFormat.format(JGitText.get().largeObjectException, this.getObjectName());
    }
}

