/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.errors;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;

public class CheckoutConflictException
extends IOException {
    private static final long serialVersionUID = 1L;
    private final String[] conflicting;

    public CheckoutConflictException(String string) {
        super(MessageFormat.format(JGitText.get().checkoutConflictWithFile, string));
        this.conflicting = new String[]{string};
    }

    public CheckoutConflictException(String[] stringArray) {
        super(MessageFormat.format(JGitText.get().checkoutConflictWithFiles, CheckoutConflictException.buildList(stringArray)));
        this.conflicting = stringArray;
    }

    public String[] getConflictingFiles() {
        return this.conflicting;
    }

    private static String buildList(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append("\n");
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }
}

