/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.dircache;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.UnmergedPathException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.TreeFormatter;
import org.eclipse.jgit.util.MutableInteger;
import org.eclipse.jgit.util.RawParseUtils;

public class DirCacheTree {
    private static final byte[] NO_NAME = new byte[0];
    private static final DirCacheTree[] NO_CHILDREN = new DirCacheTree[0];
    private static final Comparator TREE_CMP = (dirCacheTree, dirCacheTree2) -> {
        int n2;
        byte[] byArray = dirCacheTree.encodedName;
        byte[] byArray2 = dirCacheTree2.encodedName;
        int n3 = byArray.length;
        int n4 = byArray2.length;
        for (n2 = 0; n2 < n3 && n2 < n4; ++n2) {
            int n5 = (byArray[n2] & 0xFF) - (byArray2[n2] & 0xFF);
            if (n5 == 0) continue;
            return n5;
        }
        if (n3 == n4) {
            return 0;
        }
        if (n3 < n4) {
            return 47 - (byArray2[n2] & 0xFF);
        }
        return (byArray[n2] & 0xFF) - 47;
    };
    private DirCacheTree parent;
    byte[] encodedName;
    private int entrySpan;
    private ObjectId id;
    private DirCacheTree[] children;
    private int childCnt;

    DirCacheTree() {
        this.encodedName = NO_NAME;
        this.children = NO_CHILDREN;
        this.childCnt = 0;
        this.entrySpan = -1;
    }

    private DirCacheTree(DirCacheTree dirCacheTree, byte[] byArray, int n2, int n3) {
        this.parent = dirCacheTree;
        this.encodedName = new byte[n3];
        System.arraycopy(byArray, n2, this.encodedName, 0, n3);
        this.children = NO_CHILDREN;
        this.childCnt = 0;
        this.entrySpan = -1;
    }

    DirCacheTree(byte[] byArray, MutableInteger mutableInteger, DirCacheTree dirCacheTree) {
        this.parent = dirCacheTree;
        int n2 = RawParseUtils.next(byArray, mutableInteger.value, '\u0000');
        int n3 = n2 - mutableInteger.value - 1;
        if (n3 > 0) {
            this.encodedName = new byte[n3];
            System.arraycopy(byArray, mutableInteger.value, this.encodedName, 0, n3);
        } else {
            this.encodedName = NO_NAME;
        }
        this.entrySpan = RawParseUtils.parseBase10(byArray, n2, mutableInteger);
        int n4 = RawParseUtils.parseBase10(byArray, mutableInteger.value, mutableInteger);
        mutableInteger.value = RawParseUtils.next(byArray, mutableInteger.value, '\n');
        if (this.entrySpan >= 0) {
            this.id = ObjectId.fromRaw(byArray, mutableInteger.value);
            mutableInteger.value += 20;
        }
        if (n4 > 0) {
            boolean bl2 = true;
            this.children = new DirCacheTree[n4];
            for (int i2 = 0; i2 < n4; ++i2) {
                this.children[i2] = new DirCacheTree(byArray, mutableInteger, this);
                if (!bl2 || i2 <= 0 || TREE_CMP.compare(this.children[i2 - 1], this.children[i2]) <= 0) continue;
                bl2 = false;
            }
            if (!bl2) {
                Arrays.sort(this.children, 0, n4, TREE_CMP);
            }
        } else {
            this.children = NO_CHILDREN;
        }
        this.childCnt = n4;
    }

    void write(byte[] byArray, OutputStream outputStream) {
        int n2 = byArray.length;
        byArray[--n2] = 10;
        n2 = RawParseUtils.formatBase10(byArray, n2, this.childCnt);
        byArray[--n2] = 32;
        n2 = RawParseUtils.formatBase10(byArray, n2, this.isValid() ? this.entrySpan : -1);
        byArray[--n2] = 0;
        outputStream.write(this.encodedName);
        outputStream.write(byArray, n2, byArray.length - n2);
        if (this.isValid()) {
            this.id.copyRawTo(byArray, 0);
            outputStream.write(byArray, 0, 20);
        }
        for (int i2 = 0; i2 < this.childCnt; ++i2) {
            this.children[i2].write(byArray, outputStream);
        }
    }

    public boolean isValid() {
        return this.id != null;
    }

    public int getEntrySpan() {
        return this.entrySpan;
    }

    public int getChildCount() {
        return this.childCnt;
    }

    public DirCacheTree getChild(int n2) {
        return this.children[n2];
    }

    public ObjectId getObjectId() {
        return this.id;
    }

    public String getNameString() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.encodedName);
        return StandardCharsets.UTF_8.decode(byteBuffer).toString();
    }

    public String getPathString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendName(stringBuilder);
        return stringBuilder.toString();
    }

    ObjectId writeTree(DirCacheEntry[] dirCacheEntryArray, int n2, int n3, ObjectInserter objectInserter) {
        if (this.id == null) {
            int n4 = n2 + this.entrySpan;
            TreeFormatter treeFormatter = new TreeFormatter(this.computeSize(dirCacheEntryArray, n2, n3, objectInserter));
            int n5 = 0;
            int n6 = n2;
            while (n6 < n4) {
                DirCacheTree dirCacheTree;
                DirCacheEntry dirCacheEntry = dirCacheEntryArray[n6];
                byte[] byArray = dirCacheEntry.path;
                if (n5 < this.childCnt && (dirCacheTree = this.children[n5]).contains(byArray, n3, byArray.length)) {
                    treeFormatter.append(dirCacheTree.encodedName, FileMode.TREE, (AnyObjectId)dirCacheTree.id);
                    n6 += dirCacheTree.entrySpan;
                    ++n5;
                    continue;
                }
                treeFormatter.append(byArray, n3, byArray.length - n3, dirCacheEntry.getFileMode(), dirCacheEntry.idBuffer(), dirCacheEntry.idOffset());
                ++n6;
            }
            this.id = objectInserter.insert(treeFormatter);
        }
        return this.id;
    }

    private int computeSize(DirCacheEntry[] dirCacheEntryArray, int n2, int n3, ObjectInserter objectInserter) {
        int n4 = n2 + this.entrySpan;
        int n5 = 0;
        int n6 = n2;
        int n7 = 0;
        while (n6 < n4) {
            DirCacheTree dirCacheTree;
            DirCacheEntry dirCacheEntry = dirCacheEntryArray[n6];
            if (dirCacheEntry.getStage() != 0) {
                throw new UnmergedPathException(dirCacheEntry);
            }
            byte[] byArray = dirCacheEntry.path;
            if (n5 < this.childCnt && (dirCacheTree = this.children[n5]).contains(byArray, n3, byArray.length)) {
                int n8 = n3 + dirCacheTree.nameLength() + 1;
                dirCacheTree.writeTree(dirCacheEntryArray, n6, n8, objectInserter);
                n7 += TreeFormatter.entrySize(FileMode.TREE, dirCacheTree.nameLength());
                n6 += dirCacheTree.entrySpan;
                ++n5;
                continue;
            }
            n7 += TreeFormatter.entrySize(dirCacheEntry.getFileMode(), byArray.length - n3);
            ++n6;
        }
        return n7;
    }

    private void appendName(StringBuilder stringBuilder) {
        if (this.parent != null) {
            this.parent.appendName(stringBuilder);
            stringBuilder.append(this.getNameString());
            stringBuilder.append('/');
        } else if (this.nameLength() > 0) {
            stringBuilder.append(this.getNameString());
            stringBuilder.append('/');
        }
    }

    final int nameLength() {
        return this.encodedName.length;
    }

    final boolean contains(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = this.encodedName;
        int n4 = byArray2.length;
        for (int i2 = 0; i2 < n4 && n2 < n3; ++i2, ++n2) {
            if (byArray2[i2] == byArray[n2]) continue;
            return false;
        }
        if (n2 >= n3) {
            return false;
        }
        return byArray[n2] == 47;
    }

    void validate(DirCacheEntry[] dirCacheEntryArray, int n2, int n3, int n4) {
        if (this.entrySpan >= 0 && n3 + this.entrySpan <= n2) {
            return;
        }
        this.entrySpan = 0;
        if (n2 == 0) {
            return;
        }
        byte[] byArray = dirCacheEntryArray[n3].path;
        int n5 = 0;
        while (n3 < n2) {
            byte[] byArray2 = dirCacheEntryArray[n3].path;
            if (n4 > 0 && !DirCacheTree.peq(byArray, byArray2, n4)) break;
            DirCacheTree dirCacheTree = n5 < this.childCnt ? this.children[n5] : null;
            int n6 = DirCacheTree.namecmp(byArray2, n4, dirCacheTree);
            if (n6 > 0) {
                this.removeChild(n5);
                continue;
            }
            if (n6 < 0) {
                int n7 = DirCacheTree.slash(byArray2, n4);
                if (n7 < 0) {
                    ++n3;
                    ++this.entrySpan;
                    continue;
                }
                dirCacheTree = new DirCacheTree(this, byArray2, n4, n7 - n4);
                this.insertChild(n5, dirCacheTree);
            }
            assert (dirCacheTree != null);
            dirCacheTree.validate(dirCacheEntryArray, n2, n3, n4 + dirCacheTree.nameLength() + 1);
            n3 += dirCacheTree.entrySpan;
            this.entrySpan += dirCacheTree.entrySpan;
            ++n5;
        }
        while (n5 < this.childCnt) {
            this.removeChild(this.childCnt - 1);
        }
    }

    private void insertChild(int n2, DirCacheTree dirCacheTree) {
        DirCacheTree[] dirCacheTreeArray = this.children;
        if (this.childCnt + 1 <= dirCacheTreeArray.length) {
            if (n2 < this.childCnt) {
                System.arraycopy(dirCacheTreeArray, n2, dirCacheTreeArray, n2 + 1, this.childCnt - n2);
            }
            dirCacheTreeArray[n2] = dirCacheTree;
            ++this.childCnt;
            return;
        }
        int n3 = dirCacheTreeArray.length;
        DirCacheTree[] dirCacheTreeArray2 = new DirCacheTree[n3 + 1];
        if (n2 > 0) {
            System.arraycopy(dirCacheTreeArray, 0, dirCacheTreeArray2, 0, n2);
        }
        dirCacheTreeArray2[n2] = dirCacheTree;
        if (n2 < n3) {
            System.arraycopy(dirCacheTreeArray, n2, dirCacheTreeArray2, n2 + 1, n3 - n2);
        }
        this.children = dirCacheTreeArray2;
        ++this.childCnt;
    }

    private void removeChild(int n2) {
        int n3;
        if (n2 < (n3 = --this.childCnt)) {
            System.arraycopy(this.children, n2 + 1, this.children, n2, n3 - n2);
        }
        this.children[n3] = null;
    }

    static boolean peq(byte[] byArray, byte[] byArray2, int n2) {
        if (byArray2.length < n2) {
            return false;
        }
        --n2;
        while (n2 >= 0) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            --n2;
        }
        return true;
    }

    private static int namecmp(byte[] byArray, int n2, DirCacheTree dirCacheTree) {
        int n3;
        if (dirCacheTree == null) {
            return -1;
        }
        byte[] byArray2 = dirCacheTree.encodedName;
        int n4 = byArray.length;
        int n5 = byArray2.length;
        for (n3 = 0; n2 < n4 && n3 < n5; ++n2, ++n3) {
            int n6 = (byArray[n2] & 0xFF) - (byArray2[n3] & 0xFF);
            if (n6 == 0) continue;
            return n6;
        }
        if (n3 == n5) {
            return byArray[n2] == 47 ? 0 : -1;
        }
        return n4 - n5;
    }

    private static int slash(byte[] byArray, int n2) {
        int n3 = byArray.length;
        while (n2 < n3) {
            if (byArray[n2] == 47) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public String toString() {
        return this.getNameString();
    }
}

