/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.dircache;

import java.nio.charset.StandardCharsets;
import org.eclipse.jgit.attributes.AttributesNode;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator$LazyLoadingAttributesNode;
import org.eclipse.jgit.dircache.DirCacheTree;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.util.RawParseUtils;

public class DirCacheIterator
extends AbstractTreeIterator {
    private static final byte[] DOT_GIT_ATTRIBUTES_BYTES = ".gitattributes".getBytes(StandardCharsets.UTF_8);
    protected final DirCache cache;
    private final DirCacheTree tree;
    private final int treeStart;
    private final int treeEnd;
    private final byte[] subtreeId;
    protected int ptr;
    private int nextSubtreePos;
    protected DirCacheEntry currentEntry;
    protected DirCacheTree currentSubtree;

    public DirCacheIterator(DirCache dirCache) {
        this.cache = dirCache;
        this.tree = dirCache.getCacheTree(true);
        this.treeStart = 0;
        this.treeEnd = this.tree.getEntrySpan();
        this.subtreeId = new byte[20];
        if (!this.eof()) {
            this.parseEntry();
        }
    }

    DirCacheIterator(DirCacheIterator dirCacheIterator, DirCacheTree dirCacheTree) {
        super(dirCacheIterator, dirCacheIterator.path, dirCacheIterator.pathLen + 1);
        this.cache = dirCacheIterator.cache;
        this.tree = dirCacheTree;
        this.treeStart = dirCacheIterator.ptr;
        this.treeEnd = this.treeStart + this.tree.getEntrySpan();
        this.subtreeId = dirCacheIterator.subtreeId;
        this.ptr = dirCacheIterator.ptr;
        this.parseEntry();
    }

    @Override
    public AbstractTreeIterator createSubtreeIterator(ObjectReader objectReader) {
        if (this.currentSubtree == null) {
            throw new IncorrectObjectTypeException(this.getEntryObjectId(), "tree");
        }
        return new DirCacheIterator(this, this.currentSubtree);
    }

    @Override
    public EmptyTreeIterator createEmptyTreeIterator() {
        byte[] byArray = new byte[Math.max(this.pathLen + 1, 128)];
        System.arraycopy(this.path, 0, byArray, 0, this.pathLen);
        byArray[this.pathLen] = 47;
        return new EmptyTreeIterator(this, byArray, this.pathLen + 1);
    }

    @Override
    public boolean hasId() {
        if (this.currentSubtree != null) {
            return this.currentSubtree.isValid();
        }
        return this.currentEntry != null;
    }

    @Override
    public byte[] idBuffer() {
        if (this.currentSubtree != null) {
            return this.currentSubtree.isValid() ? this.subtreeId : zeroid;
        }
        if (this.currentEntry != null) {
            return this.currentEntry.idBuffer();
        }
        return zeroid;
    }

    @Override
    public int idOffset() {
        if (this.currentSubtree != null) {
            return 0;
        }
        if (this.currentEntry != null) {
            return this.currentEntry.idOffset();
        }
        return 0;
    }

    @Override
    public void reset() {
        if (!this.first()) {
            this.ptr = this.treeStart;
            this.nextSubtreePos = 0;
            this.currentEntry = null;
            this.currentSubtree = null;
            if (!this.eof()) {
                this.parseEntry();
            }
        }
    }

    @Override
    public boolean first() {
        return this.ptr == this.treeStart;
    }

    @Override
    public boolean eof() {
        return this.ptr == this.treeEnd;
    }

    @Override
    public void next(int n2) {
        while (--n2 >= 0) {
            this.ptr = this.currentSubtree != null ? (this.ptr += this.currentSubtree.getEntrySpan()) : ++this.ptr;
            if (this.eof()) break;
            this.parseEntry();
        }
    }

    @Override
    public void back(int n2) {
        while (--n2 >= 0) {
            if (this.currentSubtree != null) {
                --this.nextSubtreePos;
            }
            --this.ptr;
            this.parseEntry(false);
            if (this.currentSubtree == null) continue;
            this.ptr -= this.currentSubtree.getEntrySpan() - 1;
        }
    }

    private void parseEntry() {
        this.parseEntry(true);
    }

    private void parseEntry(boolean bl2) {
        DirCacheTree dirCacheTree;
        this.currentEntry = this.cache.getEntry(this.ptr);
        byte[] byArray = this.currentEntry.path;
        if (!bl2 && this.nextSubtreePos > 0 && (dirCacheTree = this.tree.getChild(this.nextSubtreePos - 1)).contains(byArray, this.pathOffset, byArray.length)) {
            --this.nextSubtreePos;
            this.currentSubtree = dirCacheTree;
        }
        if (this.nextSubtreePos != this.tree.getChildCount() && (dirCacheTree = this.tree.getChild(this.nextSubtreePos)).contains(byArray, this.pathOffset, byArray.length)) {
            this.currentSubtree = dirCacheTree;
            ++this.nextSubtreePos;
            if (dirCacheTree.isValid()) {
                dirCacheTree.getObjectId().copyRawTo(this.subtreeId, 0);
            }
            this.mode = FileMode.TREE.getBits();
            this.path = byArray;
            this.pathLen = this.pathOffset + dirCacheTree.nameLength();
            return;
        }
        this.mode = this.currentEntry.getRawMode();
        this.path = byArray;
        this.pathLen = byArray.length;
        this.currentSubtree = null;
        if (RawParseUtils.match(this.path, this.pathOffset, DOT_GIT_ATTRIBUTES_BYTES) == this.path.length) {
            this.attributesNode = new DirCacheIterator$LazyLoadingAttributesNode(this.currentEntry.getObjectId());
        }
    }

    public DirCacheEntry getDirCacheEntry() {
        return this.currentSubtree == null ? this.currentEntry : null;
    }

    public AttributesNode getEntryAttributesNode(ObjectReader objectReader) {
        if (this.attributesNode instanceof DirCacheIterator$LazyLoadingAttributesNode) {
            this.attributesNode = ((DirCacheIterator$LazyLoadingAttributesNode)this.attributesNode).load(objectReader);
        }
        return this.attributesNode;
    }
}

