/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.dircache;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.Arrays;
import org.eclipse.jgit.dircache.DirCache$DirCacheVersion;
import org.eclipse.jgit.dircache.InvalidPathException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.MutableInteger;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.SystemReader;

public class DirCacheEntry {
    private static final byte[] nullpad = new byte[8];
    public static final int STAGE_0 = 0;
    public static final int STAGE_1 = 1;
    public static final int STAGE_2 = 2;
    public static final int STAGE_3 = 3;
    private static final int P_CTIME = 0;
    private static final int P_MTIME = 8;
    private static final int P_MODE = 24;
    private static final int P_SIZE = 36;
    private static final int P_OBJECTID = 40;
    private static final int P_FLAGS = 60;
    private static final int P_FLAGS2 = 62;
    private static final int NAME_MASK = 4095;
    private static final int INTENT_TO_ADD = 0x20000000;
    private static final int SKIP_WORKTREE = 0x40000000;
    private static final int EXTENDED_FLAGS = 0x60000000;
    private static final int INFO_LEN = 62;
    private static final int INFO_LEN_EXTENDED = 64;
    private static final int EXTENDED = 64;
    private static final int ASSUME_VALID = 128;
    private static final int UPDATE_NEEDED = 1;
    private final byte[] info;
    private final int infoOffset;
    final byte[] path;
    private byte inCoreFlags;

    DirCacheEntry(byte[] byArray, MutableInteger mutableInteger, InputStream inputStream, MessageDigest messageDigest, Instant instant, DirCache$DirCacheVersion dirCache$DirCacheVersion, DirCacheEntry dirCacheEntry) {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream;
        int n2;
        int n3;
        this.info = byArray;
        this.infoOffset = mutableInteger.value;
        IO.readFully(inputStream, this.info, this.infoOffset, 62);
        if (this.isExtended()) {
            n3 = 64;
            IO.readFully(inputStream, this.info, this.infoOffset + 62, 2);
            if ((this.getExtendedFlags() & 0x9FFFFFFF) != 0) {
                throw new IOException(MessageFormat.format(JGitText.get().DIRCUnrecognizedExtendedFlags, String.valueOf(this.getExtendedFlags())));
            }
        } else {
            n3 = 62;
        }
        mutableInteger.value += n3;
        messageDigest.update(this.info, this.infoOffset, n3);
        int n4 = 0;
        if (dirCache$DirCacheVersion == DirCache$DirCacheVersion.DIRC_VERSION_PATHCOMPRESS) {
            n2 = inputStream.read();
            messageDigest.update((byte)n2);
            n4 = n2 & 0x7F;
            while ((n2 & 0x80) != 0) {
                ++n4;
                n2 = inputStream.read();
                messageDigest.update((byte)n2);
                n4 = n4 << 7 | n2 & 0x7F;
            }
            if (n4 < 0 || dirCacheEntry != null && n4 > dirCacheEntry.path.length) {
                if (dirCacheEntry == null) {
                    throw new IOException(MessageFormat.format(JGitText.get().DIRCCorruptLengthFirst, n4));
                }
                throw new IOException(MessageFormat.format(JGitText.get().DIRCCorruptLength, n4, dirCacheEntry.getPathString()));
            }
        }
        n2 = NB.decodeUInt16(this.info, this.infoOffset + 60) & 0xFFF;
        int n5 = 0;
        if (n2 < 4095) {
            this.path = new byte[n2];
            if (dirCache$DirCacheVersion == DirCache$DirCacheVersion.DIRC_VERSION_PATHCOMPRESS && dirCacheEntry != null) {
                System.arraycopy(dirCacheEntry.path, 0, this.path, 0, dirCacheEntry.path.length - n4);
                IO.readFully(inputStream, this.path, dirCacheEntry.path.length - n4, n2 - (dirCacheEntry.path.length - n4));
                messageDigest.update(this.path, dirCacheEntry.path.length - n4, n2 - (dirCacheEntry.path.length - n4));
                n2 -= dirCacheEntry.path.length - n4;
            } else {
                IO.readFully(inputStream, this.path, 0, n2);
                messageDigest.update(this.path, 0, n2);
            }
        } else if (dirCache$DirCacheVersion != DirCache$DirCacheVersion.DIRC_VERSION_PATHCOMPRESS || dirCacheEntry == null || n4 == dirCacheEntry.path.length) {
            byteArrayOutputStream = new ByteArrayOutputStream();
            object = new byte[4095];
            IO.readFully(inputStream, (byte[])object, 0, 4095);
            byteArrayOutputStream.write((byte[])object);
            this.readNulTerminatedString(inputStream, byteArrayOutputStream);
            this.path = byteArrayOutputStream.toByteArray();
            n2 = this.path.length;
            messageDigest.update(this.path, 0, n2);
            n5 = 1;
            messageDigest.update((byte)0);
        } else {
            byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(dirCacheEntry.path, 0, dirCacheEntry.path.length - n4);
            n2 = this.readNulTerminatedString(inputStream, byteArrayOutputStream);
            this.path = byteArrayOutputStream.toByteArray();
            messageDigest.update(this.path, dirCacheEntry.path.length - n4, n2);
            n5 = 1;
            messageDigest.update((byte)0);
        }
        try {
            DirCacheEntry.checkPath(this.path);
        }
        catch (InvalidPathException invalidPathException) {
            object = new CorruptObjectException(invalidPathException.getMessage());
            if (invalidPathException.getCause() != null) {
                ((Throwable)object).initCause(invalidPathException.getCause());
            }
            throw object;
        }
        if (dirCache$DirCacheVersion == DirCache$DirCacheVersion.DIRC_VERSION_PATHCOMPRESS) {
            if (n5 == 0) {
                int n6 = inputStream.read();
                if (n6 < 0) {
                    throw new EOFException(JGitText.get().shortReadOfBlock);
                }
                messageDigest.update((byte)n6);
            }
        } else {
            int n7 = n3 + n2;
            int n8 = n7 + 8 & 0xFFFFFFF8;
            int n9 = n8 - n7 - n5;
            if (n9 > 0) {
                IO.skipFully(inputStream, n9);
                messageDigest.update(nullpad, 0, n9);
            }
        }
        if (this.mightBeRacilyClean(instant)) {
            this.smudgeRacilyClean();
        }
    }

    public DirCacheEntry(String string) {
        this(Constants.encode(string), 0);
    }

    public DirCacheEntry(String string, int n2) {
        this(Constants.encode(string), n2);
    }

    public DirCacheEntry(byte[] byArray) {
        this(byArray, 0);
    }

    public DirCacheEntry(byte[] byArray, int n2) {
        DirCacheEntry.checkPath(byArray);
        if (n2 < 0 || 3 < n2) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidStageForPath, n2, DirCacheEntry.toString(byArray)));
        }
        this.info = new byte[62];
        this.infoOffset = 0;
        this.path = byArray;
        int n3 = (n2 & 3) << 12;
        n3 = byArray.length < 4095 ? (n3 |= byArray.length) : (n3 |= 0xFFF);
        NB.encodeInt16(this.info, this.infoOffset + 60, n3);
    }

    public DirCacheEntry(DirCacheEntry dirCacheEntry) {
        this.path = dirCacheEntry.path;
        this.info = new byte[62];
        this.infoOffset = 0;
        System.arraycopy(dirCacheEntry.info, dirCacheEntry.infoOffset, this.info, 0, 62);
    }

    private int readNulTerminatedString(InputStream inputStream, OutputStream outputStream) {
        int n2 = 0;
        while (true) {
            int n3;
            if ((n3 = inputStream.read()) < 0) {
                throw new EOFException(JGitText.get().shortReadOfBlock);
            }
            if (n3 == 0) break;
            outputStream.write(n3);
            ++n2;
        }
        return n2;
    }

    void write(OutputStream outputStream, DirCache$DirCacheVersion dirCache$DirCacheVersion, DirCacheEntry dirCacheEntry) {
        int n2;
        int n3 = n2 = this.isExtended() ? 64 : 62;
        if (dirCache$DirCacheVersion != DirCache$DirCacheVersion.DIRC_VERSION_PATHCOMPRESS) {
            outputStream.write(this.info, this.infoOffset, n2);
            outputStream.write(this.path, 0, this.path.length);
            int n4 = n2 + this.path.length;
            int n5 = n4 + 8 & 0xFFFFFFF8;
            if (n4 != n5) {
                outputStream.write(nullpad, 0, n5 - n4);
            }
        } else {
            int n6;
            int n7;
            if (dirCacheEntry != null) {
                int n8 = Math.min(this.path.length, dirCacheEntry.path.length);
                for (n7 = 0; n7 < n8 && this.path[n7] == dirCacheEntry.path[n7]; ++n7) {
                }
                n6 = dirCacheEntry.path.length - n7;
            } else {
                n6 = 0;
            }
            byte[] byArray = new byte[16];
            int n9 = byArray.length;
            byArray[--n9] = (byte)(n6 & 0x7F);
            while ((n6 >>>= 7) != 0) {
                byArray[--n9] = (byte)(0x80 | --n6 & 0x7F);
            }
            outputStream.write(this.info, this.infoOffset, n2);
            outputStream.write(byArray, n9, byArray.length - n9);
            outputStream.write(this.path, n7, this.path.length - n7);
            outputStream.write(0);
        }
    }

    @Deprecated
    public final boolean mightBeRacilyClean(int n2, int n3) {
        return this.mightBeRacilyClean(Instant.ofEpochSecond(n2, n3));
    }

    public final boolean mightBeRacilyClean(Instant instant) {
        int n2 = this.infoOffset + 8;
        int n3 = NB.decodeInt32(this.info, n2);
        if ((int)instant.getEpochSecond() == n3) {
            return instant.getNano() <= NB.decodeInt32(this.info, n2 + 4);
        }
        return false;
    }

    public final void smudgeRacilyClean() {
        int n2 = this.infoOffset + 36;
        Arrays.fill(this.info, n2, n2 + 4, (byte)0);
    }

    public final boolean isSmudged() {
        int n2 = this.infoOffset + 40;
        return this.getLength() == 0 && Constants.EMPTY_BLOB_ID.compareTo(this.info, n2) != 0;
    }

    final byte[] idBuffer() {
        return this.info;
    }

    final int idOffset() {
        return this.infoOffset + 40;
    }

    public boolean isAssumeValid() {
        return (this.info[this.infoOffset + 60] & 0x80) != 0;
    }

    public void setAssumeValid(boolean bl2) {
        if (bl2) {
            int n2 = this.infoOffset + 60;
            this.info[n2] = (byte)(this.info[n2] | 0xFFFFFF80);
        } else {
            int n3 = this.infoOffset + 60;
            this.info[n3] = (byte)(this.info[n3] & 0x7F);
        }
    }

    public boolean isUpdateNeeded() {
        return (this.inCoreFlags & 1) != 0;
    }

    public void setUpdateNeeded(boolean bl2) {
        this.inCoreFlags = bl2 ? (byte)(this.inCoreFlags | 1) : (byte)(this.inCoreFlags & 0xFFFFFFFE);
    }

    public int getStage() {
        return this.info[this.infoOffset + 60] >>> 4 & 3;
    }

    public void setStage(int n2) {
        if ((n2 & 0xFFFFFFFC) != 0) {
            throw new IllegalArgumentException("Invalid stage, must be in range [0..3]");
        }
        byte by = this.info[this.infoOffset + 60];
        this.info[this.infoOffset + 60] = (byte)(by & 0xCF | n2 << 4);
    }

    public boolean isSkipWorkTree() {
        return (this.getExtendedFlags() & 0x40000000) != 0;
    }

    public boolean isIntentToAdd() {
        return (this.getExtendedFlags() & 0x20000000) != 0;
    }

    public boolean isMerged() {
        return this.getStage() == 0;
    }

    public int getRawMode() {
        return NB.decodeInt32(this.info, this.infoOffset + 24);
    }

    public FileMode getFileMode() {
        return FileMode.fromBits(this.getRawMode());
    }

    public void setFileMode(FileMode fileMode) {
        switch (fileMode.getBits() & 0xF000) {
            case 0: 
            case 16384: {
                throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidModeForPath, fileMode, this.getPathString()));
            }
        }
        NB.encodeInt32(this.info, this.infoOffset + 24, fileMode.getBits());
    }

    void setFileMode(int n2) {
        NB.encodeInt32(this.info, this.infoOffset + 24, n2);
    }

    public long getCreationTime() {
        return this.decodeTS(0);
    }

    public void setCreationTime(long l2) {
        this.encodeTS(0, l2);
    }

    @Deprecated
    public long getLastModified() {
        return this.decodeTS(8);
    }

    public Instant getLastModifiedInstant() {
        return this.decodeTSInstant(8);
    }

    @Deprecated
    public void setLastModified(long l2) {
        this.encodeTS(8, l2);
    }

    public void setLastModified(Instant instant) {
        this.encodeTS(8, instant);
    }

    public int getLength() {
        return NB.decodeInt32(this.info, this.infoOffset + 36);
    }

    public void setLength(int n2) {
        NB.encodeInt32(this.info, this.infoOffset + 36, n2);
    }

    public void setLength(long l2) {
        this.setLength((int)l2);
    }

    public ObjectId getObjectId() {
        return ObjectId.fromRaw(this.idBuffer(), this.idOffset());
    }

    public void setObjectId(AnyObjectId anyObjectId) {
        anyObjectId.copyRawTo(this.idBuffer(), this.idOffset());
    }

    public void setObjectIdFromRaw(byte[] byArray, int n2) {
        int n3 = 20;
        System.arraycopy(byArray, n2, this.idBuffer(), this.idOffset(), 20);
    }

    public String getPathString() {
        return DirCacheEntry.toString(this.path);
    }

    public byte[] getRawPath() {
        return (byte[])this.path.clone();
    }

    public String toString() {
        return this.getFileMode() + " " + this.getLength() + " " + this.getLastModifiedInstant() + " " + this.getObjectId() + " " + this.getStage() + " " + this.getPathString() + "\n";
    }

    public void copyMetaData(DirCacheEntry dirCacheEntry) {
        this.copyMetaData(dirCacheEntry, false);
    }

    void copyMetaData(DirCacheEntry dirCacheEntry, boolean bl2) {
        int n2 = NB.decodeUInt16(this.info, this.infoOffset + 60);
        int n3 = NB.decodeUInt16(dirCacheEntry.info, dirCacheEntry.infoOffset + 60);
        System.arraycopy(dirCacheEntry.info, dirCacheEntry.infoOffset, this.info, this.infoOffset, 62);
        int n4 = n2 & 0xFFF;
        int n5 = 12288;
        int n6 = bl2 ? n2 & 0x3000 : n3 & 0x3000;
        NB.encodeInt16(this.info, this.infoOffset + 60, n6 | n4 | n3 & 0xFFFFF000 & 0xFFFFCFFF);
    }

    boolean isExtended() {
        return (this.info[this.infoOffset + 60] & 0x40) != 0;
    }

    private long decodeTS(int n2) {
        int n3 = this.infoOffset + n2;
        int n4 = NB.decodeInt32(this.info, n3);
        int n5 = NB.decodeInt32(this.info, n3 + 4) / 1000000;
        return 1000L * (long)n4 + (long)n5;
    }

    private Instant decodeTSInstant(int n2) {
        int n3 = this.infoOffset + n2;
        int n4 = NB.decodeInt32(this.info, n3);
        int n5 = NB.decodeInt32(this.info, n3 + 4);
        return Instant.ofEpochSecond(n4, n5);
    }

    private void encodeTS(int n2, long l2) {
        int n3 = this.infoOffset + n2;
        NB.encodeInt32(this.info, n3, (int)(l2 / 1000L));
        NB.encodeInt32(this.info, n3 + 4, (int)(l2 % 1000L) * 1000000);
    }

    private void encodeTS(int n2, Instant instant) {
        int n3 = this.infoOffset + n2;
        NB.encodeInt32(this.info, n3, (int)instant.getEpochSecond());
        NB.encodeInt32(this.info, n3 + 4, instant.getNano());
    }

    private int getExtendedFlags() {
        if (this.isExtended()) {
            return NB.decodeUInt16(this.info, this.infoOffset + 62) << 16;
        }
        return 0;
    }

    private static void checkPath(byte[] byArray) {
        try {
            SystemReader.getInstance().checkPath(byArray);
        }
        catch (CorruptObjectException corruptObjectException) {
            InvalidPathException invalidPathException = new InvalidPathException(DirCacheEntry.toString(byArray));
            invalidPathException.initCause(corruptObjectException);
            throw invalidPathException;
        }
    }

    static String toString(byte[] byArray) {
        return StandardCharsets.UTF_8.decode(ByteBuffer.wrap(byArray)).toString();
    }

    static int getMaximumInfoLength(boolean bl2) {
        return bl2 ? 64 : 62;
    }
}

