/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.dircache;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jgit.dircache.BaseDirCacheEditor;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEditor$DeletePath;
import org.eclipse.jgit.dircache.DirCacheEditor$DeleteTree;
import org.eclipse.jgit.dircache.DirCacheEditor$PathEdit;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheTree;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.util.Paths;

public class DirCacheEditor
extends BaseDirCacheEditor {
    private static final Comparator EDIT_CMP = (dirCacheEditor$PathEdit, dirCacheEditor$PathEdit2) -> {
        byte[] byArray = dirCacheEditor$PathEdit.path;
        byte[] byArray2 = dirCacheEditor$PathEdit2.path;
        return DirCache.cmp(byArray, byArray.length, byArray2, byArray2.length);
    };
    private final List edits = new ArrayList();
    private int editIdx;

    protected DirCacheEditor(DirCache dirCache, int n2) {
        super(dirCache, n2);
    }

    public void add(DirCacheEditor$PathEdit dirCacheEditor$PathEdit) {
        this.edits.add(dirCacheEditor$PathEdit);
    }

    @Override
    public boolean commit() {
        if (this.edits.isEmpty()) {
            this.cache.unlock();
            return true;
        }
        return super.commit();
    }

    @Override
    public void finish() {
        if (!this.edits.isEmpty()) {
            this.applyEdits();
            this.replace();
        }
    }

    private void applyEdits() {
        Collections.sort(this.edits, EDIT_CMP);
        this.editIdx = 0;
        int n2 = this.cache.getEntryCount();
        int n3 = 0;
        while (this.editIdx < this.edits.size()) {
            Object object;
            int n4;
            boolean bl2;
            DirCacheEditor$PathEdit dirCacheEditor$PathEdit = (DirCacheEditor$PathEdit)this.edits.get(this.editIdx++);
            int n5 = this.cache.findEntry(n3, dirCacheEditor$PathEdit.path, dirCacheEditor$PathEdit.path.length);
            boolean bl3 = bl2 = n5 < 0;
            if (n5 < 0) {
                n5 = -(n5 + 1);
            }
            if ((n4 = Math.min(n5, n2) - n3) > 0) {
                this.fastKeep(n3, n4);
            }
            if (dirCacheEditor$PathEdit instanceof DirCacheEditor$DeletePath) {
                n3 = bl2 ? n5 : this.cache.nextEntry(n5);
                continue;
            }
            if (dirCacheEditor$PathEdit instanceof DirCacheEditor$DeleteTree) {
                n3 = this.cache.nextEntry(dirCacheEditor$PathEdit.path, dirCacheEditor$PathEdit.path.length, n5);
                continue;
            }
            if (bl2) {
                object = new DirCacheEntry(dirCacheEditor$PathEdit.path);
                dirCacheEditor$PathEdit.apply((DirCacheEntry)object);
                if (((DirCacheEntry)object).getRawMode() == 0) {
                    throw new IllegalArgumentException(MessageFormat.format(JGitText.get().fileModeNotSetForPath, ((DirCacheEntry)object).getPathString()));
                }
                n3 = dirCacheEditor$PathEdit.replace ? this.deleteOverlappingSubtree((DirCacheEntry)object, n5) : n5;
                this.fastAdd((DirCacheEntry)object);
                continue;
            }
            n3 = this.cache.nextEntry(n5);
            if (n3 > n5 + 1) {
                int n6;
                object = new DirCacheEntry[n3 - n5];
                int n7 = 0;
                for (n6 = n5; n6 < n3; ++n6) {
                    DirCacheEntry dirCacheEntry = this.cache.getEntry(n6);
                    dirCacheEditor$PathEdit.apply(dirCacheEntry);
                    if (dirCacheEntry.getStage() == 0) {
                        this.fastAdd(dirCacheEntry);
                        n7 = 0;
                        break;
                    }
                    object[n7++] = dirCacheEntry;
                }
                for (n6 = 0; n6 < n7; ++n6) {
                    this.fastAdd((DirCacheEntry)object[n6]);
                }
                continue;
            }
            object = this.cache.getEntry(n5);
            dirCacheEditor$PathEdit.apply((DirCacheEntry)object);
            this.fastAdd((DirCacheEntry)object);
        }
        int n8 = n2 - n3;
        if (n8 > 0) {
            this.fastKeep(n3, n8);
        }
    }

    private int deleteOverlappingSubtree(DirCacheEntry dirCacheEntry, int n2) {
        byte[] byArray = dirCacheEntry.path;
        int n3 = byArray.length;
        int n4 = DirCacheEditor.pdir(byArray, n3);
        while (n4 > 0) {
            int n5 = this.findEntry(byArray, n4);
            if (n5 >= 0) {
                int n6 = --this.entryCnt - n5;
                System.arraycopy(this.entries, n5 + 1, this.entries, n5, n6);
                break;
            }
            if ((n5 = -(n5 + 1)) < this.entryCnt && DirCacheEditor.inDir(this.entries[n5], byArray, n4)) break;
            n4 = DirCacheEditor.pdir(byArray, n4);
        }
        if (n2 >= (n4 = this.cache.getEntryCount())) {
            return n4;
        }
        DirCacheEntry dirCacheEntry2 = this.cache.getEntry(n2);
        if (Paths.compare(dirCacheEntry2.path, 0, dirCacheEntry2.path.length, 0, byArray, 0, n3, 16384) < 0) {
            this.insertEdit(new DirCacheEditor$DeleteTree(byArray));
            return n2;
        }
        while (n2 < n4 && DirCacheEditor.inDir(this.cache.getEntry(n2), byArray, n3)) {
            ++n2;
        }
        return n2;
    }

    private int findEntry(byte[] byArray, int n2) {
        int n3 = 0;
        int n4 = this.entryCnt;
        while (n3 < n4) {
            int n5 = n3 + n4 >>> 1;
            int n6 = DirCache.cmp(byArray, n2, this.entries[n5]);
            if (n6 < 0) {
                n4 = n5;
                continue;
            }
            if (n6 == 0) {
                while (n5 > 0 && DirCache.cmp(byArray, n2, this.entries[n5 - 1]) == 0) {
                    --n5;
                }
                return n5;
            }
            n3 = n5 + 1;
        }
        return -(n3 + 1);
    }

    private void insertEdit(DirCacheEditor$DeleteTree dirCacheEditor$DeleteTree) {
        for (int i2 = this.editIdx; i2 < this.edits.size(); ++i2) {
            int n2 = EDIT_CMP.compare(dirCacheEditor$DeleteTree, this.edits.get(i2));
            if (n2 < 0) {
                this.edits.add(i2, dirCacheEditor$DeleteTree);
                return;
            }
            if (n2 != 0) continue;
            return;
        }
        this.edits.add(dirCacheEditor$DeleteTree);
    }

    private static boolean inDir(DirCacheEntry dirCacheEntry, byte[] byArray, int n2) {
        return dirCacheEntry.path.length > n2 && dirCacheEntry.path[n2] == 47 && DirCacheTree.peq(byArray, dirCacheEntry.path, n2);
    }

    private static int pdir(byte[] byArray, int n2) {
        --n2;
        while (n2 > 0) {
            if (byArray[n2] == 47) {
                return n2;
            }
            --n2;
        }
        return 0;
    }
}

