/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.dircache;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.api.errors.FilterFailedException;
import org.eclipse.jgit.attributes.FilterCommand;
import org.eclipse.jgit.attributes.FilterCommandRegistry;
import org.eclipse.jgit.dircache.Checkout;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheCheckout$CheckoutMetadata;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.dircache.InvalidPathException;
import org.eclipse.jgit.errors.CheckoutConflictException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IndexWriteException;
import org.eclipse.jgit.events.WorkingTreeModifiedEvent;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.CoreConfig$AutoCRLF;
import org.eclipse.jgit.lib.CoreConfig$EolStreamType;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectChecker;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.NameConflictTreeWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.TreeWalk$OperationType;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FS$ExecutionResult;
import org.eclipse.jgit.util.IntList;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jgit.util.io.EolStreamTypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirCacheCheckout {
    private static final Logger LOG = LoggerFactory.getLogger(DirCacheCheckout.class);
    private static final int MAX_EXCEPTION_TEXT_SIZE = 10240;
    private Repository repo;
    private HashMap updated = new HashMap();
    private ArrayList conflicts = new ArrayList();
    private ArrayList removed = new ArrayList();
    private ArrayList kept = new ArrayList();
    private ObjectId mergeCommitTree;
    private DirCache dc;
    private DirCacheBuilder builder;
    private NameConflictTreeWalk walk;
    private ObjectId headCommitTree;
    private WorkingTreeIterator workingTree;
    private boolean failOnConflict = true;
    private boolean force = false;
    private ArrayList toBeDeleted = new ArrayList();
    private boolean initialCheckout;
    private boolean performingCheckout;
    private Checkout checkout;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;

    public Map getUpdated() {
        return this.updated;
    }

    public List getConflicts() {
        return this.conflicts;
    }

    public List getToBeDeleted() {
        return this.toBeDeleted;
    }

    public List getRemoved() {
        return this.removed;
    }

    public DirCacheCheckout(Repository repository, ObjectId objectId, DirCache dirCache, ObjectId objectId2, WorkingTreeIterator workingTreeIterator) {
        this.repo = repository;
        this.dc = dirCache;
        this.headCommitTree = objectId;
        this.mergeCommitTree = objectId2;
        this.workingTree = workingTreeIterator;
        this.initialCheckout = !repository.isBare() && !repository.getIndexFile().exists();
    }

    public DirCacheCheckout(Repository repository, ObjectId objectId, DirCache dirCache, ObjectId objectId2) {
        this(repository, objectId, dirCache, objectId2, new FileTreeIterator(repository));
    }

    public DirCacheCheckout(Repository repository, DirCache dirCache, ObjectId objectId, WorkingTreeIterator workingTreeIterator) {
        this(repository, null, dirCache, objectId, workingTreeIterator);
    }

    public DirCacheCheckout(Repository repository, DirCache dirCache, ObjectId objectId) {
        this(repository, null, dirCache, objectId, new FileTreeIterator(repository));
    }

    public void setProgressMonitor(ProgressMonitor progressMonitor) {
        this.monitor = progressMonitor != null ? progressMonitor : NullProgressMonitor.INSTANCE;
    }

    public void preScanTwoTrees() {
        this.removed.clear();
        this.updated.clear();
        this.conflicts.clear();
        this.walk = new NameConflictTreeWalk(this.repo);
        this.builder = this.dc.builder();
        this.addTree(this.walk, this.headCommitTree);
        this.addTree(this.walk, this.mergeCommitTree);
        int n2 = this.walk.addTree(new DirCacheBuildIterator(this.builder));
        this.walk.addTree(this.workingTree);
        this.workingTree.setDirCacheIterator(this.walk, n2);
        while (this.walk.next()) {
            this.processEntry((CanonicalTreeParser)this.walk.getTree(0, CanonicalTreeParser.class), (CanonicalTreeParser)this.walk.getTree(1, CanonicalTreeParser.class), (DirCacheBuildIterator)this.walk.getTree(2, DirCacheBuildIterator.class), (WorkingTreeIterator)this.walk.getTree(3, WorkingTreeIterator.class));
            if (!this.walk.isSubtree()) continue;
            this.walk.enterSubtree();
        }
    }

    private void addTree(TreeWalk treeWalk, ObjectId objectId) {
        if (objectId == null) {
            treeWalk.addTree(new EmptyTreeIterator());
        } else {
            treeWalk.addTree(objectId);
        }
    }

    public void prescanOneTree() {
        this.removed.clear();
        this.updated.clear();
        this.conflicts.clear();
        this.builder = this.dc.builder();
        this.walk = new NameConflictTreeWalk(this.repo);
        this.addTree(this.walk, this.mergeCommitTree);
        int n2 = this.walk.addTree(new DirCacheBuildIterator(this.builder));
        this.walk.addTree(this.workingTree);
        this.workingTree.setDirCacheIterator(this.walk, n2);
        while (this.walk.next()) {
            this.processEntry((CanonicalTreeParser)this.walk.getTree(0, CanonicalTreeParser.class), (DirCacheBuildIterator)this.walk.getTree(1, DirCacheBuildIterator.class), (WorkingTreeIterator)this.walk.getTree(2, WorkingTreeIterator.class));
            if (!this.walk.isSubtree()) continue;
            this.walk.enterSubtree();
        }
        this.conflicts.removeAll(this.removed);
    }

    void processEntry(CanonicalTreeParser canonicalTreeParser, DirCacheBuildIterator dirCacheBuildIterator, WorkingTreeIterator workingTreeIterator) {
        if (canonicalTreeParser != null) {
            DirCacheCheckout.checkValidPath(canonicalTreeParser);
            if (dirCacheBuildIterator == null) {
                if (workingTreeIterator != null && !FileMode.TREE.equals(workingTreeIterator.getEntryFileMode()) && !workingTreeIterator.isEntryIgnored()) {
                    if (this.failOnConflict) {
                        this.conflicts.add(this.walk.getPathString());
                    } else {
                        this.update(canonicalTreeParser.getEntryPathString(), canonicalTreeParser.getEntryObjectId(), canonicalTreeParser.getEntryFileMode());
                    }
                } else {
                    this.update(canonicalTreeParser.getEntryPathString(), canonicalTreeParser.getEntryObjectId(), canonicalTreeParser.getEntryFileMode());
                }
            } else if (workingTreeIterator == null || !canonicalTreeParser.idEqual(dirCacheBuildIterator)) {
                this.update(canonicalTreeParser.getEntryPathString(), canonicalTreeParser.getEntryObjectId(), canonicalTreeParser.getEntryFileMode());
            } else if (dirCacheBuildIterator.getDirCacheEntry() != null) {
                if (workingTreeIterator.isModified(dirCacheBuildIterator.getDirCacheEntry(), true, this.walk.getObjectReader()) || dirCacheBuildIterator.getDirCacheEntry().getStage() != 0) {
                    this.update(canonicalTreeParser.getEntryPathString(), canonicalTreeParser.getEntryObjectId(), canonicalTreeParser.getEntryFileMode());
                } else {
                    DirCacheEntry dirCacheEntry = dirCacheBuildIterator.getDirCacheEntry();
                    Instant instant = dirCacheEntry.getLastModifiedInstant();
                    if (instant == null || instant.equals(Instant.EPOCH)) {
                        dirCacheEntry.setLastModified(workingTreeIterator.getEntryLastModifiedInstant());
                    }
                    this.keep(dirCacheBuildIterator.getEntryPathString(), dirCacheEntry, workingTreeIterator);
                }
            } else {
                this.keep(dirCacheBuildIterator.getEntryPathString(), dirCacheBuildIterator.getDirCacheEntry(), workingTreeIterator);
            }
        } else if (workingTreeIterator != null) {
            if (this.walk.isDirectoryFileConflict()) {
                this.conflicts.add(this.walk.getPathString());
            } else if (dirCacheBuildIterator != null) {
                this.remove(dirCacheBuildIterator.getEntryPathString());
                this.conflicts.remove(dirCacheBuildIterator.getEntryPathString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkout() {
        try {
            boolean bl2 = this.doCheckout();
            return bl2;
        }
        catch (CanceledException canceledException) {
            throw new IOException(canceledException);
        }
        finally {
            try {
                this.dc.unlock();
            }
            finally {
                if (this.performingCheckout) {
                    HashSet hashSet = new HashSet(this.conflicts);
                    hashSet.addAll(this.getUpdated().keySet());
                    hashSet.addAll(this.kept);
                    WorkingTreeModifiedEvent workingTreeModifiedEvent = new WorkingTreeModifiedEvent(hashSet, this.getRemoved());
                    if (!workingTreeModifiedEvent.isEmpty()) {
                        this.repo.fireEvent(workingTreeModifiedEvent);
                    }
                }
            }
        }
    }

    private boolean doCheckout() {
        this.toBeDeleted.clear();
        try (ObjectReader objectReader = this.repo.getObjectDatabase().newReader();){
            Map.Entry entry;
            this.checkout = new Checkout(this.repo, null);
            if (this.headCommitTree != null) {
                this.preScanTwoTrees();
            } else {
                this.prescanOneTree();
            }
            if (!this.conflicts.isEmpty()) {
                if (this.failOnConflict) {
                    throw new CheckoutConflictException(this.conflicts.toArray(new String[0]));
                }
                this.cleanUpConflicts();
            }
            this.builder.finish();
            int n2 = this.removed.size() + this.updated.size() + this.conflicts.size();
            this.monitor.beginTask(JGitText.get().checkingOutFiles, n2);
            this.performingCheckout = true;
            File file = null;
            String string = null;
            IntList intList = new IntList();
            for (int i2 = this.removed.size() - 1; i2 >= 0; --i2) {
                entry = (String)this.removed.get(i2);
                file = new File(this.repo.getWorkTree(), (String)((Object)entry));
                if (!file.delete() && this.repo.getFS().exists(file)) {
                    if (!this.repo.getFS().isDirectory(file)) {
                        intList.add(i2);
                        this.toBeDeleted.add(entry);
                    }
                } else {
                    if (string != null && !DirCacheCheckout.isSamePrefix((String)((Object)entry), string)) {
                        this.removeEmptyParents(new File(this.repo.getWorkTree(), string));
                    }
                    string = entry;
                }
                this.monitor.update(1);
                if (!this.monitor.isCancelled()) continue;
                throw new CanceledException(MessageFormat.format(JGitText.get().operationCanceled, JGitText.get().checkingOutFiles));
            }
            if (file != null) {
                this.removeEmptyParents(file);
            }
            this.removed = DirCacheCheckout.filterOut(this.removed, intList);
            intList = null;
            Iterator iterator = this.updated.entrySet().iterator();
            entry = null;
            try {
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    String string2 = (String)entry.getKey();
                    Object object = (DirCacheCheckout$CheckoutMetadata)entry.getValue();
                    DirCacheEntry dirCacheEntry = this.dc.getEntry(string2);
                    if (FileMode.GITLINK.equals(dirCacheEntry.getRawMode())) {
                        this.checkout.checkoutGitlink(dirCacheEntry, string2);
                    } else {
                        this.checkout.checkout(dirCacheEntry, (DirCacheCheckout$CheckoutMetadata)object, objectReader, string2);
                    }
                    entry = null;
                    this.monitor.update(1);
                    if (!this.monitor.isCancelled()) continue;
                    throw new CanceledException(MessageFormat.format(JGitText.get().operationCanceled, JGitText.get().checkingOutFiles));
                }
            }
            catch (Exception exception) {
                if (entry != null) {
                    iterator.remove();
                }
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    iterator.remove();
                }
                throw exception;
            }
            for (Object object : this.conflicts) {
                int n3 = this.dc.findEntry((String)object);
                if (n3 >= 0) {
                    DirCacheEntry dirCacheEntry;
                    while (n3 < this.dc.getEntryCount() && (dirCacheEntry = this.dc.getEntry(n3)).getPathString().equals(object)) {
                        if (dirCacheEntry.getStage() == 3) {
                            this.checkout.checkout(dirCacheEntry, null, objectReader, (String)object);
                            break;
                        }
                        ++n3;
                    }
                }
                this.monitor.update(1);
                if (!this.monitor.isCancelled()) continue;
                throw new CanceledException(MessageFormat.format(JGitText.get().operationCanceled, JGitText.get().checkingOutFiles));
            }
            this.monitor.endTask();
            if (!this.builder.commit()) {
                throw new IndexWriteException();
            }
        }
        return this.toBeDeleted.isEmpty();
    }

    private static ArrayList filterOut(ArrayList arrayList, IntList intList) {
        int n2 = intList.size();
        if (n2 == arrayList.size()) {
            return new ArrayList(0);
        }
        switch (n2) {
            case 0: {
                return arrayList;
            }
            case 1: {
                arrayList.remove(intList.get(0));
                return arrayList;
            }
        }
        int n3 = arrayList.size();
        ArrayList arrayList2 = new ArrayList(n3 - n2);
        int n4 = n2 - 1;
        int n5 = intList.get(n4);
        for (int i2 = 0; i2 < n3; ++i2) {
            if (i2 == n5) {
                n5 = --n4 >= 0 ? intList.get(n4) : -1;
                continue;
            }
            arrayList2.add(arrayList.get(i2));
        }
        return arrayList2;
    }

    private static boolean isSamePrefix(String string, String string2) {
        int n2 = string.lastIndexOf(47);
        int n3 = string2.lastIndexOf(47);
        return string.substring(0, n2 + 1).equals(string2.substring(0, n3 + 1));
    }

    private void removeEmptyParents(File file) {
        for (File file2 = file.getParentFile(); file2 != null && !file2.equals(this.repo.getWorkTree()) && file2.delete(); file2 = file2.getParentFile()) {
        }
    }

    private boolean equalIdAndMode(ObjectId objectId, FileMode fileMode, ObjectId objectId2, FileMode fileMode2) {
        if (!fileMode.equals(fileMode2)) {
            return false;
        }
        return objectId != null ? objectId.equals(objectId2) : objectId2 == null;
    }

    void processEntry(CanonicalTreeParser canonicalTreeParser, CanonicalTreeParser canonicalTreeParser2, DirCacheBuildIterator dirCacheBuildIterator, WorkingTreeIterator workingTreeIterator) {
        DirCacheEntry dirCacheEntry = dirCacheBuildIterator != null ? dirCacheBuildIterator.getDirCacheEntry() : null;
        String string = this.walk.getPathString();
        if (canonicalTreeParser2 != null) {
            DirCacheCheckout.checkValidPath(canonicalTreeParser2);
        }
        if (dirCacheBuildIterator == null && canonicalTreeParser2 == null && canonicalTreeParser == null) {
            if (this.walk.isDirectoryFileConflict()) {
                this.conflict(string, null, null, null);
            }
            return;
        }
        ObjectId objectId = dirCacheBuildIterator == null ? null : dirCacheBuildIterator.getEntryObjectId();
        ObjectId objectId2 = canonicalTreeParser2 == null ? null : canonicalTreeParser2.getEntryObjectId();
        ObjectId objectId3 = canonicalTreeParser == null ? null : canonicalTreeParser.getEntryObjectId();
        FileMode fileMode = dirCacheBuildIterator == null ? null : dirCacheBuildIterator.getEntryFileMode();
        FileMode fileMode2 = canonicalTreeParser2 == null ? null : canonicalTreeParser2.getEntryFileMode();
        FileMode fileMode3 = canonicalTreeParser == null ? null : canonicalTreeParser.getEntryFileMode();
        int n2 = 0;
        if (canonicalTreeParser != null) {
            int n3 = n2 = FileMode.TREE.equals(fileMode3) ? 3328 : 3840;
        }
        if (dirCacheBuildIterator != null) {
            n2 |= FileMode.TREE.equals(fileMode) ? 208 : 240;
        }
        if (canonicalTreeParser2 != null) {
            n2 |= FileMode.TREE.equals(fileMode2) ? 13 : 15;
        }
        if ((n2 & 0x222) != 0 && ((n2 & 0xF) == 13 || (n2 & 0xF0) == 208 || (n2 & 0xF00) == 3328)) {
            switch (n2) {
                case 3551: {
                    if (workingTreeIterator != null && this.isModifiedSubtree_IndexWorkingtree(string)) {
                        this.conflict(string, dirCacheEntry, canonicalTreeParser, canonicalTreeParser2);
                        break;
                    }
                    this.update(string, objectId2, fileMode2);
                    break;
                }
                case 3581: {
                    this.keep(string, dirCacheEntry, workingTreeIterator);
                    break;
                }
                case 3853: {
                    this.remove(string);
                    break;
                }
                case 3583: {
                    if (this.equalIdAndMode(objectId, fileMode, objectId2, fileMode2)) {
                        this.keep(string, dirCacheEntry, workingTreeIterator);
                        break;
                    }
                    this.conflict(string, dirCacheEntry, canonicalTreeParser, canonicalTreeParser2);
                    break;
                }
                case 4061: {
                    break;
                }
                case 3343: {
                    this.update(string, objectId2, fileMode2);
                    break;
                }
                case 253: 
                case 3568: {
                    this.conflict(string, dirCacheEntry, canonicalTreeParser, canonicalTreeParser2);
                    break;
                }
                case 4063: {
                    if (this.equalIdAndMode(objectId3, fileMode3, objectId2, fileMode2)) {
                        if (this.isModifiedSubtree_IndexWorkingtree(string)) {
                            this.conflict(string, dirCacheEntry, canonicalTreeParser, canonicalTreeParser2);
                            break;
                        }
                        this.update(string, objectId2, fileMode2);
                        break;
                    }
                    this.conflict(string, dirCacheEntry, canonicalTreeParser, canonicalTreeParser2);
                    break;
                }
                case 4048: {
                    this.keep(string, dirCacheEntry, workingTreeIterator);
                    break;
                }
                case 4093: {
                    if (this.equalIdAndMode(objectId3, fileMode3, objectId, fileMode)) {
                        if (workingTreeIterator != null && workingTreeIterator.isModified(dirCacheEntry, true, this.walk.getObjectReader())) {
                            this.conflict(string, dirCacheEntry, canonicalTreeParser, canonicalTreeParser2);
                            break;
                        }
                        this.remove(string);
                        break;
                    }
                    this.conflict(string, dirCacheEntry, canonicalTreeParser, canonicalTreeParser2);
                    break;
                }
                case 223: {
                    if (!this.isModifiedSubtree_IndexWorkingtree(string)) {
                        this.update(string, objectId2, fileMode2);
                        break;
                    }
                    this.conflict(string, dirCacheEntry, canonicalTreeParser, canonicalTreeParser2);
                    break;
                }
                default: {
                    this.keep(string, dirCacheEntry, workingTreeIterator);
                }
            }
            return;
        }
        if ((n2 & 0x222) == 0) {
            if (workingTreeIterator == null || FileMode.TREE.equals(workingTreeIterator.getEntryFileMode())) {
                return;
            }
            if (!DirCacheCheckout.idEqual(canonicalTreeParser, canonicalTreeParser2)) {
                this.conflict(string, null, null, null);
            }
            return;
        }
        if (n2 == 15 && workingTreeIterator != null && FileMode.TREE.equals(workingTreeIterator.getEntryFileMode())) {
            this.conflict(string, null, canonicalTreeParser, canonicalTreeParser2);
            return;
        }
        if (dirCacheBuildIterator == null) {
            if (!(workingTreeIterator == null || workingTreeIterator.isEntryIgnored() || FileMode.GITLINK.equals(fileMode2) || objectId2 != null && this.equalIdAndMode(objectId2, fileMode2, workingTreeIterator.getEntryObjectId(), workingTreeIterator.getEntryFileMode()))) {
                this.conflict(string, null, canonicalTreeParser, canonicalTreeParser2);
                return;
            }
            if (canonicalTreeParser == null) {
                this.update(string, objectId2, fileMode2);
            } else if (canonicalTreeParser2 == null) {
                this.remove(string);
            } else if (this.equalIdAndMode(objectId3, fileMode3, objectId2, fileMode2)) {
                if (this.initialCheckout || this.force) {
                    this.update(string, objectId2, fileMode2);
                } else {
                    this.keep(string, dirCacheEntry, workingTreeIterator);
                }
            } else {
                this.conflict(string, dirCacheEntry, canonicalTreeParser, canonicalTreeParser2);
            }
        } else if (canonicalTreeParser == null) {
            if (canonicalTreeParser2 == null || !this.isModified_IndexTree(string, objectId, fileMode, objectId2, fileMode2, this.mergeCommitTree)) {
                if (canonicalTreeParser2 == null && this.walk.isDirectoryFileConflict()) {
                    if (dirCacheEntry != null && (workingTreeIterator == null || workingTreeIterator.isModified(dirCacheEntry, true, this.walk.getObjectReader()))) {
                        this.conflict(string, dirCacheEntry, canonicalTreeParser, canonicalTreeParser2);
                    } else {
                        this.remove(string);
                    }
                } else {
                    this.keep(string, dirCacheEntry, workingTreeIterator);
                }
            } else {
                this.conflict(string, dirCacheEntry, canonicalTreeParser, canonicalTreeParser2);
            }
        } else if (canonicalTreeParser2 == null) {
            if (fileMode == FileMode.GITLINK) {
                this.remove(string);
            } else if (!this.isModified_IndexTree(string, objectId, fileMode, objectId3, fileMode3, this.headCommitTree)) {
                if (workingTreeIterator != null && workingTreeIterator.isModified(dirCacheEntry, true, this.walk.getObjectReader())) {
                    if (!FileMode.TREE.equals(workingTreeIterator.getEntryFileMode()) && FileMode.TREE.equals(fileMode)) {
                        return;
                    }
                    this.conflict(string, dirCacheEntry, canonicalTreeParser, canonicalTreeParser2);
                } else {
                    this.remove(string);
                }
            } else {
                this.conflict(string, dirCacheEntry, canonicalTreeParser, canonicalTreeParser2);
            }
        } else if (!this.equalIdAndMode(objectId3, fileMode3, objectId2, fileMode2) && this.isModified_IndexTree(string, objectId, fileMode, objectId3, fileMode3, this.headCommitTree) && this.isModified_IndexTree(string, objectId, fileMode, objectId2, fileMode2, this.mergeCommitTree)) {
            this.conflict(string, dirCacheEntry, canonicalTreeParser, canonicalTreeParser2);
        } else if (!this.isModified_IndexTree(string, objectId, fileMode, objectId3, fileMode3, this.headCommitTree) && this.isModified_IndexTree(string, objectId, fileMode, objectId2, fileMode2, this.mergeCommitTree)) {
            if (dirCacheEntry != null && FileMode.GITLINK.equals(dirCacheEntry.getFileMode())) {
                this.update(string, objectId2, fileMode2);
            } else if (dirCacheEntry != null && workingTreeIterator != null && workingTreeIterator.isModified(dirCacheEntry, true, this.walk.getObjectReader())) {
                this.conflict(string, dirCacheEntry, canonicalTreeParser, canonicalTreeParser2);
            } else {
                this.update(string, objectId2, fileMode2);
            }
        } else {
            this.keep(string, dirCacheEntry, workingTreeIterator);
        }
    }

    private static boolean idEqual(AbstractTreeIterator abstractTreeIterator, AbstractTreeIterator abstractTreeIterator2) {
        if (abstractTreeIterator == abstractTreeIterator2) {
            return true;
        }
        if (abstractTreeIterator == null || abstractTreeIterator2 == null) {
            return false;
        }
        return abstractTreeIterator.getEntryObjectId().equals(abstractTreeIterator2.getEntryObjectId());
    }

    private void conflict(String string, DirCacheEntry dirCacheEntry, AbstractTreeIterator abstractTreeIterator, AbstractTreeIterator abstractTreeIterator2) {
        DirCacheEntry dirCacheEntry2;
        this.conflicts.add(string);
        if (dirCacheEntry != null) {
            dirCacheEntry2 = new DirCacheEntry(dirCacheEntry.getPathString(), 1);
            dirCacheEntry2.copyMetaData(dirCacheEntry, true);
            this.builder.add(dirCacheEntry2);
        }
        if (abstractTreeIterator != null && !FileMode.TREE.equals(abstractTreeIterator.getEntryFileMode())) {
            dirCacheEntry2 = new DirCacheEntry(abstractTreeIterator.getEntryPathString(), 2);
            dirCacheEntry2.setFileMode(abstractTreeIterator.getEntryFileMode());
            dirCacheEntry2.setObjectId(abstractTreeIterator.getEntryObjectId());
            this.builder.add(dirCacheEntry2);
        }
        if (abstractTreeIterator2 != null && !FileMode.TREE.equals(abstractTreeIterator2.getEntryFileMode())) {
            dirCacheEntry2 = new DirCacheEntry(abstractTreeIterator2.getEntryPathString(), 3);
            dirCacheEntry2.setFileMode(abstractTreeIterator2.getEntryFileMode());
            dirCacheEntry2.setObjectId(abstractTreeIterator2.getEntryObjectId());
            this.builder.add(dirCacheEntry2);
        }
    }

    private void keep(String string, DirCacheEntry dirCacheEntry, WorkingTreeIterator workingTreeIterator) {
        if (dirCacheEntry == null) {
            return;
        }
        if (!FileMode.TREE.equals(dirCacheEntry.getFileMode())) {
            this.builder.add(dirCacheEntry);
        }
        if (this.force && (workingTreeIterator == null || workingTreeIterator.isModified(dirCacheEntry, true, this.walk.getObjectReader()))) {
            this.kept.add(string);
            this.checkout.checkout(dirCacheEntry, new DirCacheCheckout$CheckoutMetadata(this.walk.getEolStreamType(TreeWalk$OperationType.CHECKOUT_OP), this.walk.getFilterCommand("smudge")), this.walk.getObjectReader(), string);
        }
    }

    private void remove(String string) {
        this.removed.add(string);
    }

    private void update(String string, ObjectId objectId, FileMode fileMode) {
        if (!FileMode.TREE.equals(fileMode)) {
            this.updated.put(string, new DirCacheCheckout$CheckoutMetadata(this.walk.getEolStreamType(TreeWalk$OperationType.CHECKOUT_OP), this.walk.getFilterCommand("smudge")));
            DirCacheEntry dirCacheEntry = new DirCacheEntry(string, 0);
            dirCacheEntry.setObjectId(objectId);
            dirCacheEntry.setFileMode(fileMode);
            this.builder.add(dirCacheEntry);
        }
    }

    public void setFailOnConflict(boolean bl2) {
        this.failOnConflict = bl2;
    }

    public void setForce(boolean bl2) {
        this.force = bl2;
    }

    private void cleanUpConflicts() {
        for (String string : this.conflicts) {
            File file = new File(this.repo.getWorkTree(), string);
            if (!file.delete()) {
                throw new CheckoutConflictException(MessageFormat.format(JGitText.get().cannotDeleteFile, string));
            }
            this.removeEmptyParents(file);
        }
    }

    private boolean isModifiedSubtree_IndexWorkingtree(String string) {
        try (NameConflictTreeWalk nameConflictTreeWalk = new NameConflictTreeWalk(this.repo);){
            int n2 = nameConflictTreeWalk.addTree(new DirCacheIterator(this.dc));
            FileTreeIterator fileTreeIterator = new FileTreeIterator(this.repo);
            nameConflictTreeWalk.addTree(fileTreeIterator);
            fileTreeIterator.setDirCacheIterator(nameConflictTreeWalk, n2);
            nameConflictTreeWalk.setRecursive(true);
            nameConflictTreeWalk.setFilter(PathFilter.create(string));
            while (nameConflictTreeWalk.next()) {
                DirCacheIterator dirCacheIterator = (DirCacheIterator)nameConflictTreeWalk.getTree(0, DirCacheIterator.class);
                WorkingTreeIterator workingTreeIterator = (WorkingTreeIterator)nameConflictTreeWalk.getTree(1, WorkingTreeIterator.class);
                if (dirCacheIterator == null || workingTreeIterator == null) {
                    boolean bl2 = true;
                    return bl2;
                }
                if (!workingTreeIterator.isModified(dirCacheIterator.getDirCacheEntry(), true, this.walk.getObjectReader())) continue;
                boolean bl3 = true;
                return bl3;
            }
            boolean bl4 = false;
            return bl4;
        }
    }

    private boolean isModified_IndexTree(String string, ObjectId objectId, FileMode fileMode, ObjectId objectId2, FileMode fileMode2, ObjectId objectId3) {
        if (fileMode != fileMode2) {
            return true;
        }
        if (FileMode.TREE.equals(fileMode) && (objectId == null || ObjectId.zeroId().equals(objectId))) {
            return this.isModifiedSubtree_IndexTree(string, objectId3);
        }
        return !this.equalIdAndMode(objectId, fileMode, objectId2, fileMode2);
    }

    private boolean isModifiedSubtree_IndexTree(String string, ObjectId objectId) {
        try (NameConflictTreeWalk nameConflictTreeWalk = new NameConflictTreeWalk(this.repo);){
            nameConflictTreeWalk.addTree(new DirCacheIterator(this.dc));
            nameConflictTreeWalk.addTree(objectId);
            nameConflictTreeWalk.setRecursive(true);
            nameConflictTreeWalk.setFilter(PathFilter.create(string));
            while (nameConflictTreeWalk.next()) {
                AbstractTreeIterator abstractTreeIterator = nameConflictTreeWalk.getTree(0, DirCacheIterator.class);
                AbstractTreeIterator abstractTreeIterator2 = nameConflictTreeWalk.getTree(1, AbstractTreeIterator.class);
                if (abstractTreeIterator == null || abstractTreeIterator2 == null) {
                    boolean bl2 = true;
                    return bl2;
                }
                if (abstractTreeIterator.getEntryRawMode() != abstractTreeIterator2.getEntryRawMode()) {
                    boolean bl3 = true;
                    return bl3;
                }
                if (abstractTreeIterator.getEntryObjectId().equals(abstractTreeIterator2.getEntryObjectId())) continue;
                boolean bl4 = true;
                return bl4;
            }
            boolean bl5 = false;
            return bl5;
        }
    }

    @Deprecated
    public static void checkoutEntry(Repository repository, DirCacheEntry dirCacheEntry, ObjectReader objectReader) {
        DirCacheCheckout.checkoutEntry(repository, dirCacheEntry, objectReader, false, null);
    }

    public static void checkoutEntry(Repository repository, DirCacheEntry dirCacheEntry, ObjectReader objectReader, boolean bl2, DirCacheCheckout$CheckoutMetadata dirCacheCheckout$CheckoutMetadata) {
        Checkout checkout = new Checkout(repository, null).setRecursiveDeletion(bl2);
        checkout.checkout(dirCacheEntry, dirCacheCheckout$CheckoutMetadata, objectReader, null);
    }

    public static void getContent(Repository repository, String string, DirCacheCheckout$CheckoutMetadata dirCacheCheckout$CheckoutMetadata, ObjectLoader objectLoader, WorkingTreeOptions workingTreeOptions, OutputStream outputStream) {
        CoreConfig$EolStreamType coreConfig$EolStreamType = dirCacheCheckout$CheckoutMetadata.eolStreamType != null ? dirCacheCheckout$CheckoutMetadata.eolStreamType : (workingTreeOptions.getAutoCRLF() == CoreConfig$AutoCRLF.TRUE ? CoreConfig$EolStreamType.AUTO_CRLF : CoreConfig$EolStreamType.DIRECT);
        try (OutputStream outputStream2 = EolStreamTypeUtil.wrapOutputStream(outputStream, coreConfig$EolStreamType);){
            if (dirCacheCheckout$CheckoutMetadata.smudgeFilterCommand != null) {
                if (FilterCommandRegistry.isRegistered(dirCacheCheckout$CheckoutMetadata.smudgeFilterCommand)) {
                    DirCacheCheckout.runBuiltinFilterCommand(repository, dirCacheCheckout$CheckoutMetadata, objectLoader, outputStream2);
                } else {
                    DirCacheCheckout.runExternalFilterCommand(repository, string, dirCacheCheckout$CheckoutMetadata, objectLoader, outputStream2);
                }
            } else {
                objectLoader.copyTo(outputStream2);
            }
        }
    }

    private static void runExternalFilterCommand(Repository repository, String string, DirCacheCheckout$CheckoutMetadata dirCacheCheckout$CheckoutMetadata, ObjectLoader objectLoader, OutputStream outputStream) {
        int n2;
        FS$ExecutionResult fS$ExecutionResult;
        FS fS = repository.getFS();
        ProcessBuilder processBuilder = fS.runInShell(dirCacheCheckout$CheckoutMetadata.smudgeFilterCommand, new String[0]);
        processBuilder.directory(repository.getWorkTree());
        processBuilder.environment().put("GIT_DIR", repository.getDirectory().getAbsolutePath());
        if (repository.hasCommonDirectory()) {
            processBuilder.environment().put("GIT_COMMON_DIR", repository.getCommonDirectory().getAbsolutePath());
        }
        try {
            fS$ExecutionResult = fS.execute(processBuilder, objectLoader.openStream());
            n2 = fS$ExecutionResult.getRc();
            if (n2 == 0) {
                fS$ExecutionResult.getStdout().writeTo(outputStream, NullProgressMonitor.INSTANCE);
            }
        }
        catch (IOException | InterruptedException exception) {
            throw new IOException(new FilterFailedException(exception, dirCacheCheckout$CheckoutMetadata.smudgeFilterCommand, string));
        }
        if (n2 != 0) {
            throw new IOException(new FilterFailedException(n2, dirCacheCheckout$CheckoutMetadata.smudgeFilterCommand, string, fS$ExecutionResult.getStdout().toByteArray(10240), fS$ExecutionResult.getStderr().toString(10240)));
        }
    }

    private static void runBuiltinFilterCommand(Repository repository, DirCacheCheckout$CheckoutMetadata dirCacheCheckout$CheckoutMetadata, ObjectLoader objectLoader, OutputStream outputStream) {
        boolean bl2 = repository.getConfig().getBoolean("filter", "lfs", "required", false);
        FilterCommand filterCommand = null;
        try {
            filterCommand = FilterCommandRegistry.createFilterCommand(dirCacheCheckout$CheckoutMetadata.smudgeFilterCommand, repository, objectLoader.openStream(), outputStream);
        }
        catch (IOException iOException) {
            LOG.error(JGitText.get().failedToDetermineFilterDefinition, (Throwable)iOException);
            if (!bl2) {
                objectLoader.copyTo(outputStream);
            }
            throw iOException;
        }
        if (filterCommand != null) {
            while (filterCommand.run() != -1) {
            }
        }
    }

    private static void checkValidPath(CanonicalTreeParser canonicalTreeParser) {
        ObjectChecker objectChecker = new ObjectChecker().setSafeForWindows(SystemReader.getInstance().isWindows()).setSafeForMacOS(SystemReader.getInstance().isMacOS());
        for (CanonicalTreeParser canonicalTreeParser2 = canonicalTreeParser; canonicalTreeParser2 != null; canonicalTreeParser2 = canonicalTreeParser2.getParent()) {
            DirCacheCheckout.checkValidPathSegment(objectChecker, canonicalTreeParser2);
        }
    }

    private static void checkValidPathSegment(ObjectChecker objectChecker, CanonicalTreeParser canonicalTreeParser) {
        try {
            int n2 = canonicalTreeParser.getNameOffset();
            int n3 = n2 + canonicalTreeParser.getNameLength();
            objectChecker.checkPathSegment(canonicalTreeParser.getEntryPathBuffer(), n2, n3);
        }
        catch (CorruptObjectException corruptObjectException) {
            String string = canonicalTreeParser.getEntryPathString();
            InvalidPathException invalidPathException = new InvalidPathException(string);
            invalidPathException.initCause(corruptObjectException);
            throw invalidPathException;
        }
    }
}

