/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.dircache;

import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.jgit.dircache.BaseDirCacheEditor;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;

public class DirCacheBuilder
extends BaseDirCacheEditor {
    private boolean sorted;

    protected DirCacheBuilder(DirCache dirCache, int n2) {
        super(dirCache, n2);
    }

    public void add(DirCacheEntry dirCacheEntry) {
        if (dirCacheEntry.getRawMode() == 0) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().fileModeNotSetForPath, dirCacheEntry.getPathString()));
        }
        this.beforeAdd(dirCacheEntry);
        this.fastAdd(dirCacheEntry);
    }

    public void keep(int n2, int n3) {
        this.beforeAdd(this.cache.getEntry(n2));
        this.fastKeep(n2, n3);
    }

    public void addTree(byte[] byArray, int n2, ObjectReader objectReader, AnyObjectId anyObjectId) {
        CanonicalTreeParser canonicalTreeParser = DirCacheBuilder.createTreeParser(byArray, objectReader, anyObjectId);
        while (!canonicalTreeParser.eof()) {
            if (DirCacheBuilder.isTree(canonicalTreeParser)) {
                canonicalTreeParser = DirCacheBuilder.enterTree(canonicalTreeParser, objectReader);
                continue;
            }
            DirCacheEntry dirCacheEntry = DirCacheBuilder.toEntry(n2, canonicalTreeParser);
            this.beforeAdd(dirCacheEntry);
            this.fastAdd(dirCacheEntry);
            canonicalTreeParser = canonicalTreeParser.next();
            break;
        }
        while (!canonicalTreeParser.eof()) {
            if (DirCacheBuilder.isTree(canonicalTreeParser)) {
                canonicalTreeParser = DirCacheBuilder.enterTree(canonicalTreeParser, objectReader);
                continue;
            }
            this.fastAdd(DirCacheBuilder.toEntry(n2, canonicalTreeParser));
            canonicalTreeParser = canonicalTreeParser.next();
        }
    }

    private static CanonicalTreeParser createTreeParser(byte[] byArray, ObjectReader objectReader, AnyObjectId anyObjectId) {
        return new CanonicalTreeParser(byArray, objectReader, anyObjectId);
    }

    private static boolean isTree(CanonicalTreeParser canonicalTreeParser) {
        return (canonicalTreeParser.getEntryRawMode() & 0xF000) == 16384;
    }

    private static CanonicalTreeParser enterTree(CanonicalTreeParser canonicalTreeParser, ObjectReader objectReader) {
        return (canonicalTreeParser = canonicalTreeParser.createSubtreeIterator(objectReader)).eof() ? canonicalTreeParser.next() : canonicalTreeParser;
    }

    private static DirCacheEntry toEntry(int n2, CanonicalTreeParser canonicalTreeParser) {
        byte[] byArray = canonicalTreeParser.getEntryPathBuffer();
        int n3 = canonicalTreeParser.getEntryPathLength();
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        DirCacheEntry dirCacheEntry = new DirCacheEntry(byArray2, n2);
        dirCacheEntry.setFileMode(canonicalTreeParser.getEntryRawMode());
        dirCacheEntry.setObjectIdFromRaw(canonicalTreeParser.idBuffer(), canonicalTreeParser.idOffset());
        return dirCacheEntry;
    }

    @Override
    public void finish() {
        if (!this.sorted) {
            this.resort();
        }
        this.replace();
    }

    private void beforeAdd(DirCacheEntry dirCacheEntry) {
        if (this.sorted && this.entryCnt > 0) {
            DirCacheEntry dirCacheEntry2 = this.entries[this.entryCnt - 1];
            int n2 = DirCache.cmp(dirCacheEntry2, dirCacheEntry);
            if (n2 > 0) {
                this.sorted = false;
            } else if (n2 == 0) {
                int n3;
                int n4 = dirCacheEntry2.getStage();
                if (n4 == (n3 = dirCacheEntry.getStage())) {
                    throw DirCacheBuilder.bad(dirCacheEntry, JGitText.get().duplicateStagesNotAllowed);
                }
                if (n4 == 0 || n3 == 0) {
                    throw DirCacheBuilder.bad(dirCacheEntry, JGitText.get().mixedStagesNotAllowed);
                }
                if (n4 > n3) {
                    this.sorted = false;
                }
            }
        }
    }

    private void resort() {
        Arrays.sort(this.entries, 0, this.entryCnt, DirCache.ENT_CMP);
        for (int i2 = 1; i2 < this.entryCnt; ++i2) {
            int n2;
            DirCacheEntry dirCacheEntry = this.entries[i2 - 1];
            DirCacheEntry dirCacheEntry2 = this.entries[i2];
            int n3 = DirCache.cmp(dirCacheEntry, dirCacheEntry2);
            if (n3 != 0) continue;
            int n4 = dirCacheEntry.getStage();
            if (n4 == (n2 = dirCacheEntry2.getStage())) {
                throw DirCacheBuilder.bad(dirCacheEntry2, JGitText.get().duplicateStagesNotAllowed);
            }
            if (n4 != 0 && n2 != 0) continue;
            throw DirCacheBuilder.bad(dirCacheEntry2, JGitText.get().mixedStagesNotAllowed);
        }
        this.sorted = true;
    }

    private static IllegalStateException bad(DirCacheEntry dirCacheEntry, String string) {
        return new IllegalStateException(String.format("%s: %d %s", string, dirCacheEntry.getStage(), dirCacheEntry.getPathString()));
    }
}

