/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.dircache;

import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.dircache.DirCacheTree;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;

public class DirCacheBuildIterator
extends DirCacheIterator {
    private final DirCacheBuilder builder;

    public DirCacheBuildIterator(DirCacheBuilder dirCacheBuilder) {
        super(dirCacheBuilder.getDirCache());
        this.builder = dirCacheBuilder;
    }

    DirCacheBuildIterator(DirCacheBuildIterator dirCacheBuildIterator, DirCacheTree dirCacheTree) {
        super(dirCacheBuildIterator, dirCacheTree);
        this.builder = dirCacheBuildIterator.builder;
    }

    @Override
    public AbstractTreeIterator createSubtreeIterator(ObjectReader objectReader) {
        if (this.currentSubtree == null) {
            throw new IncorrectObjectTypeException(this.getEntryObjectId(), "tree");
        }
        return new DirCacheBuildIterator(this, this.currentSubtree);
    }

    @Override
    public void skip() {
        if (this.currentSubtree != null) {
            this.builder.keep(this.ptr, this.currentSubtree.getEntrySpan());
        } else {
            this.builder.keep(this.ptr, 1);
        }
        this.next(1);
    }

    @Override
    public void stopWalk() {
        int n2 = this.ptr;
        int n3 = this.cache.getEntryCount();
        if (n2 < n3) {
            this.builder.keep(n2, n3 - n2);
        }
    }

    @Override
    protected boolean needsStopWalk() {
        return this.ptr < this.cache.getEntryCount();
    }
}

