/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.dircache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jgit.dircache.DirCache$DirCacheConfig;
import org.eclipse.jgit.dircache.DirCache$DirCacheVersion;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.dircache.DirCacheTree;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IndexReadException;
import org.eclipse.jgit.errors.LockFailedException;
import org.eclipse.jgit.events.IndexChangedEvent;
import org.eclipse.jgit.events.IndexChangedListener;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.FileSnapshot;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.internal.storage.io.NullMessageDigest;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.TreeWalk$OperationType;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.MutableInteger;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.eclipse.jgit.util.TemporaryBuffer$LocalFile;
import org.eclipse.jgit.util.io.SilentFileInputStream;

public class DirCache {
    private static final byte[] SIG_DIRC = new byte[]{68, 73, 82, 67};
    private static final int EXT_TREE = 0x54524545;
    private static final DirCacheEntry[] NO_ENTRIES = new DirCacheEntry[0];
    private static final byte[] NO_CHECKSUM = new byte[0];
    static final Comparator ENT_CMP = (dirCacheEntry, dirCacheEntry2) -> {
        int n2 = DirCache.cmp(dirCacheEntry, dirCacheEntry2);
        if (n2 != 0) {
            return n2;
        }
        return dirCacheEntry.getStage() - dirCacheEntry2.getStage();
    };
    private final File liveFile;
    private final FS fs;
    private DirCacheEntry[] sortedEntries;
    private int entryCnt;
    private DirCacheTree tree;
    private LockFile myLock;
    private FileSnapshot snapshot;
    private byte[] readIndexChecksum;
    private byte[] writeIndexChecksum;
    private IndexChangedListener indexChangedListener;
    private Repository repository;
    private DirCache$DirCacheVersion version;
    private boolean skipHash;

    static int cmp(DirCacheEntry dirCacheEntry, DirCacheEntry dirCacheEntry2) {
        return DirCache.cmp(dirCacheEntry.path, dirCacheEntry.path.length, dirCacheEntry2);
    }

    static int cmp(byte[] byArray, int n2, DirCacheEntry dirCacheEntry) {
        return DirCache.cmp(byArray, n2, dirCacheEntry.path, dirCacheEntry.path.length);
    }

    static int cmp(byte[] byArray, int n2, byte[] byArray2, int n3) {
        for (int i2 = 0; i2 < n2 && i2 < n3; ++i2) {
            int n4 = (byArray[i2] & 0xFF) - (byArray2[i2] & 0xFF);
            if (n4 == 0) continue;
            return n4;
        }
        return n2 - n3;
    }

    public static DirCache newInCore() {
        return new DirCache(null, null);
    }

    public static DirCache read(ObjectReader objectReader, AnyObjectId anyObjectId) {
        DirCache dirCache = DirCache.newInCore();
        DirCacheBuilder dirCacheBuilder = dirCache.builder();
        dirCacheBuilder.addTree(null, 0, objectReader, anyObjectId);
        dirCacheBuilder.finish();
        return dirCache;
    }

    public static DirCache read(Repository repository) {
        DirCache dirCache = DirCache.read(repository.getIndexFile(), repository.getFS());
        dirCache.repository = repository;
        return dirCache;
    }

    public static DirCache read(File file, FS fS) {
        DirCache dirCache = new DirCache(file, fS);
        dirCache.read();
        return dirCache;
    }

    public static DirCache lock(File file, FS fS) {
        DirCache dirCache = new DirCache(file, fS);
        if (!dirCache.lock()) {
            throw new LockFailedException(file);
        }
        try {
            dirCache.read();
        }
        catch (IOException | Error | RuntimeException throwable) {
            dirCache.unlock();
            throw throwable;
        }
        return dirCache;
    }

    public static DirCache lock(Repository repository, IndexChangedListener indexChangedListener) {
        DirCache dirCache = DirCache.lock(repository.getIndexFile(), repository.getFS(), indexChangedListener);
        dirCache.repository = repository;
        return dirCache;
    }

    public static DirCache lock(File file, FS fS, IndexChangedListener indexChangedListener) {
        DirCache dirCache = DirCache.lock(file, fS);
        dirCache.registerIndexChangedListener(indexChangedListener);
        return dirCache;
    }

    public DirCache(File file, FS fS) {
        this.liveFile = file;
        this.fs = fS;
        this.clear();
    }

    public DirCacheBuilder builder() {
        return new DirCacheBuilder(this, this.entryCnt + 16);
    }

    public DirCacheEditor editor() {
        return new DirCacheEditor(this, this.entryCnt + 16);
    }

    DirCache$DirCacheVersion getVersion() {
        return this.version;
    }

    void replace(DirCacheEntry[] dirCacheEntryArray, int n2) {
        this.sortedEntries = dirCacheEntryArray;
        this.entryCnt = n2;
        this.tree = null;
    }

    public void read() {
        if (this.liveFile == null) {
            throw new IOException(JGitText.get().dirCacheDoesNotHaveABackingFile);
        }
        if (!this.liveFile.exists()) {
            this.clear();
        } else if (this.snapshot == null || this.snapshot.isModified(this.liveFile)) {
            try (SilentFileInputStream silentFileInputStream = new SilentFileInputStream(this.liveFile);){
                this.clear();
                this.readFrom(silentFileInputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (this.liveFile.exists()) {
                    throw new IndexReadException(MessageFormat.format(JGitText.get().cannotReadIndex, this.liveFile.getAbsolutePath(), fileNotFoundException));
                }
                this.clear();
            }
            this.snapshot = FileSnapshot.save(this.liveFile, this.fs);
        }
    }

    public boolean isOutdated() {
        if (this.liveFile == null || !this.liveFile.exists()) {
            return false;
        }
        return this.snapshot == null || this.snapshot.isModified(this.liveFile);
    }

    public void clear() {
        this.snapshot = null;
        this.sortedEntries = NO_ENTRIES;
        this.entryCnt = 0;
        this.tree = null;
        this.readIndexChecksum = NO_CHECKSUM;
    }

    private void readFrom(InputStream inputStream) {
        byte[] byArray;
        MessageDigest messageDigest;
        block14: {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            this.readConfig();
            messageDigest = this.newMessageDigest();
            byArray = new byte[20];
            IO.readFully(bufferedInputStream, byArray, 0, 12);
            messageDigest.update(byArray, 0, 12);
            if (!DirCache.is_DIRC(byArray)) {
                throw new CorruptObjectException(JGitText.get().notADIRCFile);
            }
            int n2 = NB.decodeInt32(byArray, 4);
            DirCache$DirCacheVersion dirCache$DirCacheVersion = DirCache$DirCacheVersion.fromInt(n2);
            if (dirCache$DirCacheVersion == null) {
                throw new CorruptObjectException(MessageFormat.format(JGitText.get().unknownDIRCVersion, n2));
            }
            boolean bl2 = false;
            switch (dirCache$DirCacheVersion) {
                case DIRC_VERSION_MINIMUM: {
                    break;
                }
                case DIRC_VERSION_EXTENDED: 
                case DIRC_VERSION_PATHCOMPRESS: {
                    bl2 = true;
                    break;
                }
                default: {
                    throw new CorruptObjectException(MessageFormat.format(JGitText.get().unknownDIRCVersion, dirCache$DirCacheVersion));
                }
            }
            this.version = dirCache$DirCacheVersion;
            this.entryCnt = NB.decodeInt32(byArray, 8);
            if (this.entryCnt < 0) {
                throw new CorruptObjectException(JGitText.get().DIRCHasTooManyEntries);
            }
            this.snapshot = FileSnapshot.save(this.liveFile, this.fs);
            Instant instant = this.snapshot.lastModifiedInstant();
            int n3 = DirCacheEntry.getMaximumInfoLength(bl2);
            byte[] byArray2 = new byte[n3 * this.entryCnt];
            this.sortedEntries = new DirCacheEntry[this.entryCnt];
            MutableInteger mutableInteger = new MutableInteger();
            for (int i2 = 0; i2 < this.entryCnt; ++i2) {
                this.sortedEntries[i2] = new DirCacheEntry(byArray2, mutableInteger, bufferedInputStream, messageDigest, instant, this.version, i2 == 0 ? null : this.sortedEntries[i2 - 1]);
            }
            block8: while (true) {
                bufferedInputStream.mark(21);
                IO.readFully(bufferedInputStream, byArray, 0, 20);
                if (bufferedInputStream.read() < 0) break block14;
                bufferedInputStream.reset();
                messageDigest.update(byArray, 0, 8);
                IO.skipFully(bufferedInputStream, 8L);
                long l2 = NB.decodeUInt32(byArray, 4);
                switch (NB.decodeInt32(byArray, 0)) {
                    case 0x54524545: {
                        if (Integer.MAX_VALUE < l2) {
                            throw new CorruptObjectException(MessageFormat.format(JGitText.get().DIRCExtensionIsTooLargeAt, DirCache.formatExtensionName(byArray), l2));
                        }
                        byte[] byArray3 = new byte[(int)l2];
                        IO.readFully(bufferedInputStream, byArray3, 0, byArray3.length);
                        messageDigest.update(byArray3, 0, byArray3.length);
                        this.tree = new DirCacheTree(byArray3, new MutableInteger(), null);
                        continue block8;
                    }
                }
                if (byArray[0] < 65 || byArray[0] > 90) break;
                this.skipOptionalExtension(bufferedInputStream, messageDigest, byArray, l2);
            }
            throw new CorruptObjectException(MessageFormat.format(JGitText.get().DIRCExtensionNotSupportedByThisVersion, DirCache.formatExtensionName(byArray)));
        }
        this.readIndexChecksum = messageDigest.digest();
        if (!(this.skipHash || Arrays.equals(this.readIndexChecksum, byArray) || Arrays.equals(NullMessageDigest.getInstance().digest(), byArray))) {
            throw new CorruptObjectException(JGitText.get().DIRCChecksumMismatch);
        }
    }

    private void skipOptionalExtension(InputStream inputStream, MessageDigest messageDigest, byte[] byArray, long l2) {
        byte[] byArray2 = new byte[4096];
        while (0L < l2) {
            int n2 = inputStream.read(byArray2, 0, (int)Math.min((long)byArray2.length, l2));
            if (n2 < 0) {
                throw new EOFException(MessageFormat.format(JGitText.get().shortReadOfOptionalDIRCExtensionExpectedAnotherBytes, DirCache.formatExtensionName(byArray), l2));
            }
            messageDigest.update(byArray2, 0, n2);
            l2 -= (long)n2;
        }
    }

    private static String formatExtensionName(byte[] byArray) {
        return "'" + new String(byArray, 0, 4, StandardCharsets.ISO_8859_1) + "'";
    }

    private static boolean is_DIRC(byte[] byArray) {
        if (byArray.length < SIG_DIRC.length) {
            return false;
        }
        for (int i2 = 0; i2 < SIG_DIRC.length; ++i2) {
            if (byArray[i2] == SIG_DIRC[i2]) continue;
            return false;
        }
        return true;
    }

    public boolean lock() {
        if (this.liveFile == null) {
            throw new IOException(JGitText.get().dirCacheDoesNotHaveABackingFile);
        }
        LockFile lockFile = new LockFile(this.liveFile, this.fs);
        if (lockFile.lock()) {
            lockFile.setNeedStatInformation(true);
            this.myLock = lockFile;
            return true;
        }
        return false;
    }

    public void write() {
        LockFile lockFile = this.myLock;
        this.requireLocked(lockFile);
        try (OutputStream outputStream = lockFile.getOutputStream();
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);){
            this.writeTo(this.liveFile.getParentFile(), bufferedOutputStream);
        }
        catch (IOException | Error | RuntimeException throwable) {
            lockFile.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeTo(File file, OutputStream outputStream) {
        boolean bl2;
        Instant instant;
        this.readConfig();
        MessageDigest messageDigest = this.newMessageDigest();
        DigestOutputStream digestOutputStream = new DigestOutputStream(outputStream, messageDigest);
        if (this.version == null || this.version == DirCache$DirCacheVersion.DIRC_VERSION_MINIMUM) {
            this.version = DirCache$DirCacheVersion.DIRC_VERSION_MINIMUM;
            for (int i2 = 0; i2 < this.entryCnt; ++i2) {
                if (!this.sortedEntries[i2].isExtended()) continue;
                this.version = DirCache$DirCacheVersion.DIRC_VERSION_EXTENDED;
                break;
            }
        }
        byte[] byArray = new byte[128];
        System.arraycopy(SIG_DIRC, 0, byArray, 0, SIG_DIRC.length);
        NB.encodeInt32(byArray, 4, this.version.getVersionCode());
        NB.encodeInt32(byArray, 8, this.entryCnt);
        digestOutputStream.write(byArray, 0, 12);
        if (this.myLock != null) {
            this.myLock.createCommitSnapshot();
            this.snapshot = this.myLock.getCommitSnapshot();
            instant = this.snapshot.lastModifiedInstant();
        } else {
            instant = Instant.EPOCH;
        }
        boolean bl3 = bl2 = this.tree != null;
        if (this.repository != null && this.entryCnt > 0) {
            this.updateSmudgedEntries();
        }
        for (int i3 = 0; i3 < this.entryCnt; ++i3) {
            DirCacheEntry dirCacheEntry = this.sortedEntries[i3];
            if (dirCacheEntry.mightBeRacilyClean(instant)) {
                dirCacheEntry.smudgeRacilyClean();
            }
            dirCacheEntry.write(digestOutputStream, this.version, i3 == 0 ? null : this.sortedEntries[i3 - 1]);
        }
        if (bl2) {
            TemporaryBuffer$LocalFile temporaryBuffer$LocalFile = new TemporaryBuffer$LocalFile(file, 0x500000);
            try {
                this.tree.write(byArray, temporaryBuffer$LocalFile);
                temporaryBuffer$LocalFile.close();
                NB.encodeInt32(byArray, 0, 0x54524545);
                NB.encodeInt32(byArray, 4, (int)((TemporaryBuffer)temporaryBuffer$LocalFile).length());
                digestOutputStream.write(byArray, 0, 8);
                ((TemporaryBuffer)temporaryBuffer$LocalFile).writeTo(digestOutputStream, null);
            }
            finally {
                ((TemporaryBuffer)temporaryBuffer$LocalFile).destroy();
            }
        }
        this.writeIndexChecksum = messageDigest.digest();
        outputStream.write(this.writeIndexChecksum);
        outputStream.close();
    }

    private void readConfig() {
        if (this.version == null && this.repository != null) {
            DirCache$DirCacheConfig dirCache$DirCacheConfig = (DirCache$DirCacheConfig)this.repository.getConfig().get(DirCache$DirCacheConfig::new);
            this.version = dirCache$DirCacheConfig.getIndexVersion();
            this.skipHash = dirCache$DirCacheConfig.isSkipHash();
        }
    }

    private MessageDigest newMessageDigest() {
        if (this.skipHash) {
            return NullMessageDigest.getInstance();
        }
        return Constants.newMessageDigest();
    }

    public boolean commit() {
        LockFile lockFile = this.myLock;
        this.requireLocked(lockFile);
        this.myLock = null;
        if (!lockFile.commit()) {
            return false;
        }
        this.snapshot = lockFile.getCommitSnapshot();
        if (this.indexChangedListener != null && !Arrays.equals(this.readIndexChecksum, this.writeIndexChecksum)) {
            this.indexChangedListener.onIndexChanged(new IndexChangedEvent(true));
        }
        return true;
    }

    private void requireLocked(LockFile lockFile) {
        if (this.liveFile == null) {
            throw new IllegalStateException(JGitText.get().dirCacheIsNotLocked);
        }
        if (lockFile == null) {
            throw new IllegalStateException(MessageFormat.format(JGitText.get().dirCacheFileIsNotLocked, this.liveFile.getAbsolutePath()));
        }
    }

    public void unlock() {
        LockFile lockFile = this.myLock;
        if (lockFile != null) {
            this.myLock = null;
            lockFile.unlock();
        }
    }

    public int findEntry(String string) {
        byte[] byArray = Constants.encode(string);
        return this.findEntry(byArray, byArray.length);
    }

    public int findEntry(byte[] byArray, int n2) {
        return this.findEntry(0, byArray, n2);
    }

    int findEntry(int n2, byte[] byArray, int n3) {
        int n4 = this.entryCnt;
        while (n2 < n4) {
            int n5 = n2 + n4 >>> 1;
            int n6 = DirCache.cmp(byArray, n3, this.sortedEntries[n5]);
            if (n6 < 0) {
                n4 = n5;
                continue;
            }
            if (n6 == 0) {
                while (n5 > 0 && DirCache.cmp(byArray, n3, this.sortedEntries[n5 - 1]) == 0) {
                    --n5;
                }
                return n5;
            }
            n2 = n5 + 1;
        }
        return -(n2 + 1);
    }

    public int nextEntry(int n2) {
        DirCacheEntry dirCacheEntry;
        int n3;
        DirCacheEntry dirCacheEntry2 = this.sortedEntries[n2];
        for (n3 = n2 + 1; n3 < this.entryCnt && DirCache.cmp(dirCacheEntry2, dirCacheEntry = this.sortedEntries[n3]) == 0; ++n3) {
            dirCacheEntry2 = dirCacheEntry;
        }
        return n3;
    }

    int nextEntry(byte[] byArray, int n2, int n3) {
        while (n3 < this.entryCnt) {
            DirCacheEntry dirCacheEntry = this.sortedEntries[n3];
            if (!DirCacheTree.peq(byArray, dirCacheEntry.path, n2)) break;
            ++n3;
        }
        return n3;
    }

    public int getEntryCount() {
        return this.entryCnt;
    }

    public DirCacheEntry getEntry(int n2) {
        return this.sortedEntries[n2];
    }

    public DirCacheEntry getEntry(String string) {
        int n2 = this.findEntry(string);
        return n2 < 0 ? null : this.sortedEntries[n2];
    }

    public DirCacheEntry[] getEntriesWithin(String string) {
        int n2;
        byte[] byArray;
        int n3;
        if (string.length() == 0) {
            DirCacheEntry[] dirCacheEntryArray = new DirCacheEntry[this.entryCnt];
            System.arraycopy(this.sortedEntries, 0, dirCacheEntryArray, 0, this.entryCnt);
            return dirCacheEntryArray;
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        if ((n3 = this.findEntry(byArray = Constants.encode(string), n2 = byArray.length)) < 0) {
            n3 = -(n3 + 1);
        }
        int n4 = this.nextEntry(byArray, n2, n3);
        DirCacheEntry[] dirCacheEntryArray = new DirCacheEntry[n4 - n3];
        System.arraycopy(this.sortedEntries, n3, dirCacheEntryArray, 0, dirCacheEntryArray.length);
        return dirCacheEntryArray;
    }

    void toArray(int n2, DirCacheEntry[] dirCacheEntryArray, int n3, int n4) {
        System.arraycopy(this.sortedEntries, n2, dirCacheEntryArray, n3, n4);
    }

    public DirCacheTree getCacheTree(boolean bl2) {
        if (bl2) {
            if (this.tree == null) {
                this.tree = new DirCacheTree();
            }
            this.tree.validate(this.sortedEntries, this.entryCnt, 0, 0);
        }
        return this.tree;
    }

    public ObjectId writeTree(ObjectInserter objectInserter) {
        return this.getCacheTree(true).writeTree(this.sortedEntries, 0, 0, objectInserter);
    }

    public boolean hasUnmergedPaths() {
        for (int i2 = 0; i2 < this.entryCnt; ++i2) {
            if (this.sortedEntries[i2].getStage() <= 0) continue;
            return true;
        }
        return false;
    }

    private void registerIndexChangedListener(IndexChangedListener indexChangedListener) {
        this.indexChangedListener = indexChangedListener;
    }

    private void updateSmudgedEntries() {
        ArrayList<String> arrayList = new ArrayList<String>(128);
        try (TreeWalk treeWalk = new TreeWalk(this.repository);){
            treeWalk.setOperationType(TreeWalk$OperationType.CHECKIN_OP);
            for (int i2 = 0; i2 < this.entryCnt; ++i2) {
                if (!this.sortedEntries[i2].isSmudged()) continue;
                arrayList.add(this.sortedEntries[i2].getPathString());
            }
            if (arrayList.isEmpty()) {
                return;
            }
            treeWalk.setFilter(PathFilterGroup.createFromStrings(arrayList));
            DirCacheIterator dirCacheIterator = new DirCacheIterator(this);
            FileTreeIterator fileTreeIterator = new FileTreeIterator(this.repository);
            treeWalk.addTree(dirCacheIterator);
            treeWalk.addTree(fileTreeIterator);
            fileTreeIterator.setDirCacheIterator(treeWalk, 0);
            treeWalk.setRecursive(true);
            while (treeWalk.next()) {
                DirCacheEntry dirCacheEntry;
                dirCacheIterator = (DirCacheIterator)treeWalk.getTree(0, DirCacheIterator.class);
                if (dirCacheIterator == null || (fileTreeIterator = (FileTreeIterator)treeWalk.getTree(1, FileTreeIterator.class)) == null || !(dirCacheEntry = dirCacheIterator.getDirCacheEntry()).isSmudged() || !dirCacheIterator.idEqual(fileTreeIterator)) continue;
                dirCacheEntry.setLength(fileTreeIterator.getEntryLength());
                dirCacheEntry.setLastModified(fileTreeIterator.getEntryLastModifiedInstant());
            }
        }
    }
}

