/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.dircache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheCheckout$CheckoutMetadata;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.CoreConfig$EolStreamType;
import org.eclipse.jgit.lib.CoreConfig$SymLinks;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.FileModeCache;
import org.eclipse.jgit.lib.FileModeCache$CacheItem;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.RawParseUtils;

public class Checkout {
    private final FileModeCache cache;
    private final WorkingTreeOptions options;
    private boolean recursiveDelete;

    public Checkout(@NonNull Repository repository) {
        this(repository, null);
    }

    public Checkout(@NonNull Repository repository, WorkingTreeOptions workingTreeOptions) {
        this.cache = new FileModeCache(repository);
        this.options = workingTreeOptions != null ? workingTreeOptions : (WorkingTreeOptions)repository.getConfig().get(WorkingTreeOptions.KEY);
    }

    public WorkingTreeOptions getWorkingTreeOptions() {
        return this.options;
    }

    public Checkout setRecursiveDeletion(boolean bl2) {
        this.recursiveDelete = bl2;
        return this;
    }

    public void safeCreateParentDirectory(String string, File file, boolean bl2) {
        this.cache.safeCreateParentDirectory(string, file, bl2);
    }

    public void checkoutGitlink(DirCacheEntry dirCacheEntry, String string) {
        FS fS = this.cache.getRepository().getFS();
        File file = this.cache.getRepository().getWorkTree();
        String string2 = string != null ? string : dirCacheEntry.getPathString();
        File file2 = new File(file, string2);
        File file3 = file2.getParentFile();
        FileModeCache$CacheItem fileModeCache$CacheItem = this.cache.safeCreateDirectory(string2, file3, false);
        FileUtils.mkdirs(file2, true);
        fileModeCache$CacheItem.insert(string2.substring(string2.lastIndexOf(47) + 1), FileMode.GITLINK);
        dirCacheEntry.setLastModified(fS.lastModifiedInstant(file2));
    }

    public void checkout(DirCacheEntry dirCacheEntry, DirCacheCheckout$CheckoutMetadata dirCacheCheckout$CheckoutMetadata, ObjectReader objectReader, String string) {
        if (dirCacheCheckout$CheckoutMetadata == null) {
            dirCacheCheckout$CheckoutMetadata = DirCacheCheckout$CheckoutMetadata.EMPTY;
        }
        FS fS = this.cache.getRepository().getFS();
        ObjectLoader objectLoader = objectReader.open(dirCacheEntry.getObjectId());
        String string2 = string != null ? string : dirCacheEntry.getPathString();
        File file = new File(this.cache.getRepository().getWorkTree(), string2);
        File file2 = file.getParentFile();
        FileModeCache$CacheItem fileModeCache$CacheItem = this.cache.safeCreateDirectory(string2, file2, true);
        if (dirCacheEntry.getFileMode() == FileMode.SYMLINK && this.options.getSymLinks() == CoreConfig$SymLinks.TRUE) {
            byte[] byArray = objectLoader.getBytes();
            String string3 = RawParseUtils.decode(byArray);
            if (this.recursiveDelete && Files.isDirectory(file.toPath(), LinkOption.NOFOLLOW_LINKS)) {
                FileUtils.delete(file, 1);
            }
            fS.createSymLink(file, string3);
            fileModeCache$CacheItem.insert(file.getName(), FileMode.SYMLINK);
            dirCacheEntry.setLength(byArray.length);
            dirCacheEntry.setLastModified(fS.lastModifiedInstant(file));
            return;
        }
        String string4 = file.getName();
        if (string4.length() > 200) {
            string4 = string4.substring(0, 200);
        }
        File file3 = File.createTempFile("._" + string4, null, file2);
        DirCacheCheckout.getContent(this.cache.getRepository(), string2, dirCacheCheckout$CheckoutMetadata, objectLoader, this.options, new FileOutputStream(file3));
        if (dirCacheCheckout$CheckoutMetadata.eolStreamType == CoreConfig$EolStreamType.DIRECT && dirCacheCheckout$CheckoutMetadata.smudgeFilterCommand == null) {
            dirCacheEntry.setLength(objectLoader.getSize());
        } else {
            dirCacheEntry.setLength(file3.length());
        }
        if (this.options.isFileMode() && fS.supportsExecute()) {
            if (FileMode.EXECUTABLE_FILE.equals(dirCacheEntry.getRawMode())) {
                if (!fS.canExecute(file3)) {
                    fS.setExecute(file3, true);
                }
            } else if (fS.canExecute(file3)) {
                fS.setExecute(file3, false);
            }
        }
        try {
            if (this.recursiveDelete && Files.isDirectory(file.toPath(), LinkOption.NOFOLLOW_LINKS)) {
                FileUtils.delete(file, 1);
            }
            FileUtils.rename(file3, file, StandardCopyOption.ATOMIC_MOVE);
            fileModeCache$CacheItem.remove(file.getName());
        }
        catch (IOException iOException) {
            throw new IOException(MessageFormat.format(JGitText.get().renameFileFailed, file3.getPath(), file.getPath()), iOException);
        }
        finally {
            if (file3.exists()) {
                FileUtils.delete(file3);
            }
        }
        dirCacheEntry.setLastModified(fS.lastModifiedInstant(file));
    }
}

