/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.dircache;

import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.DirCacheNameConflictException;
import org.eclipse.jgit.util.Paths;

abstract class BaseDirCacheEditor {
    protected DirCache cache;
    protected DirCacheEntry[] entries;
    protected int entryCnt;

    protected BaseDirCacheEditor(DirCache dirCache, int n2) {
        this.cache = dirCache;
        this.entries = new DirCacheEntry[n2];
    }

    public DirCache getDirCache() {
        return this.cache;
    }

    protected void fastAdd(DirCacheEntry dirCacheEntry) {
        if (this.entries.length == this.entryCnt) {
            DirCacheEntry[] dirCacheEntryArray = new DirCacheEntry[(this.entryCnt + 16) * 3 / 2];
            System.arraycopy(this.entries, 0, dirCacheEntryArray, 0, this.entryCnt);
            this.entries = dirCacheEntryArray;
        }
        this.entries[this.entryCnt++] = dirCacheEntry;
    }

    protected void fastKeep(int n2, int n3) {
        if (this.entryCnt + n3 > this.entries.length) {
            int n4 = (this.entryCnt + 16) * 3 / 2;
            int n5 = this.entryCnt + n3;
            DirCacheEntry[] dirCacheEntryArray = new DirCacheEntry[Math.max(n4, n5)];
            System.arraycopy(this.entries, 0, dirCacheEntryArray, 0, this.entryCnt);
            this.entries = dirCacheEntryArray;
        }
        this.cache.toArray(n2, this.entries, this.entryCnt, n3);
        this.entryCnt += n3;
    }

    public abstract void finish();

    protected void replace() {
        this.checkNameConflicts();
        if (this.entryCnt < this.entries.length / 2) {
            DirCacheEntry[] dirCacheEntryArray = new DirCacheEntry[this.entryCnt];
            System.arraycopy(this.entries, 0, dirCacheEntryArray, 0, this.entryCnt);
            this.entries = dirCacheEntryArray;
        }
        this.cache.replace(this.entries, this.entryCnt);
    }

    private void checkNameConflicts() {
        int n2 = this.entryCnt - 1;
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            DirCacheEntry dirCacheEntry = this.entries[i2];
            if (dirCacheEntry.getStage() != 0) continue;
            byte[] byArray = dirCacheEntry.path;
            int n3 = BaseDirCacheEditor.lastSlash(byArray) + 1;
            for (int i3 = i2 + 1; i3 < this.entryCnt; ++i3) {
                int n4;
                int n5;
                int n6;
                DirCacheEntry dirCacheEntry2 = this.entries[i3];
                if (dirCacheEntry2.getStage() != 0) continue;
                byte[] byArray2 = dirCacheEntry2.path;
                if (!BaseDirCacheEditor.startsWith(byArray, byArray2, n3) || (n6 = Paths.compareSameName(byArray, n3, byArray.length, byArray2, n3, n5, n4 = (n5 = BaseDirCacheEditor.nextSlash(byArray2, n3)) < byArray2.length ? 16384 : dirCacheEntry2.getRawMode())) < 0) continue block0;
                if (n6 != 0) continue;
                throw new DirCacheNameConflictException(dirCacheEntry.getPathString(), dirCacheEntry2.getPathString());
            }
        }
    }

    private static int lastSlash(byte[] byArray) {
        for (int i2 = byArray.length - 1; i2 >= 0; --i2) {
            if (byArray[i2] != 47) continue;
            return i2;
        }
        return -1;
    }

    private static int nextSlash(byte[] byArray, int n2) {
        int n3 = byArray.length;
        while (n2 < n3) {
            if (byArray[n2] == 47) {
                return n2;
            }
            ++n2;
        }
        return n3;
    }

    private static boolean startsWith(byte[] byArray, byte[] byArray2, int n2) {
        if (byArray2.length < n2) {
            return false;
        }
        --n2;
        while (n2 >= 0) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            --n2;
        }
        return true;
    }

    public boolean commit() {
        this.finish();
        this.cache.write();
        return this.cache.commit();
    }
}

