/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.eclipse.jgit.diff.ContentSource$Pair;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffEntry$ChangeType;
import org.eclipse.jgit.diff.DiffEntry$Side;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.diff.SimilarityIndex;
import org.eclipse.jgit.diff.SimilarityIndex$TableFullException;
import org.eclipse.jgit.errors.CancelledException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ProgressMonitor;

class SimilarityRenameDetector {
    private static final int BITS_PER_INDEX = 28;
    private static final int INDEX_MASK = 0xFFFFFFF;
    private static final int SCORE_SHIFT = 56;
    private ContentSource$Pair reader;
    private List srcs;
    private List dsts;
    private long[] matrix;
    private int renameScore = 60;
    private int bigFileThreshold = 0x3200000;
    private boolean skipBinaryFiles = false;
    private boolean tableOverflow;
    private List out;

    SimilarityRenameDetector(ContentSource$Pair pair, List list, List list2) {
        this.reader = pair;
        this.srcs = list;
        this.dsts = list2;
    }

    void setRenameScore(int n2) {
        this.renameScore = n2;
    }

    void setBigFileThreshold(int n2) {
        this.bigFileThreshold = n2;
    }

    void setSkipBinaryFiles(boolean bl2) {
        this.skipBinaryFiles = bl2;
    }

    void compute(ProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        progressMonitor.beginTask(JGitText.get().renamesFindingByContent, 2 * this.srcs.size() * this.dsts.size());
        int n2 = this.buildMatrix(progressMonitor);
        this.out = new ArrayList(Math.min(n2, this.dsts.size()));
        --n2;
        while (n2 >= 0) {
            if (progressMonitor.isCancelled()) {
                throw new CancelledException(JGitText.get().renameCancelled);
            }
            long l2 = this.matrix[n2];
            int n3 = SimilarityRenameDetector.srcFile(l2);
            int n4 = SimilarityRenameDetector.dstFile(l2);
            DiffEntry diffEntry = (DiffEntry)this.srcs.get(n3);
            DiffEntry diffEntry2 = (DiffEntry)this.dsts.get(n4);
            if (diffEntry2 == null) {
                progressMonitor.update(1);
            } else {
                DiffEntry$ChangeType diffEntry$ChangeType;
                if (diffEntry.changeType == DiffEntry$ChangeType.DELETE) {
                    diffEntry.changeType = DiffEntry$ChangeType.RENAME;
                    diffEntry$ChangeType = DiffEntry$ChangeType.RENAME;
                } else {
                    diffEntry$ChangeType = DiffEntry$ChangeType.COPY;
                }
                this.out.add(DiffEntry.pair(diffEntry$ChangeType, diffEntry, diffEntry2, SimilarityRenameDetector.score(l2)));
                this.dsts.set(n4, null);
                progressMonitor.update(1);
            }
            --n2;
        }
        this.srcs = SimilarityRenameDetector.compactSrcList(this.srcs);
        this.dsts = SimilarityRenameDetector.compactDstList(this.dsts);
        progressMonitor.endTask();
    }

    List getMatches() {
        return this.out;
    }

    List getLeftOverSources() {
        return this.srcs;
    }

    List getLeftOverDestinations() {
        return this.dsts;
    }

    boolean isTableOverflow() {
        return this.tableOverflow;
    }

    private static List compactSrcList(List list) {
        ArrayList<DiffEntry> arrayList = new ArrayList<DiffEntry>(list.size());
        for (DiffEntry diffEntry : list) {
            if (diffEntry.changeType != DiffEntry$ChangeType.DELETE) continue;
            arrayList.add(diffEntry);
        }
        return arrayList;
    }

    private static List compactDstList(List list) {
        ArrayList<DiffEntry> arrayList = new ArrayList<DiffEntry>(list.size());
        for (DiffEntry diffEntry : list) {
            if (diffEntry == null) continue;
            arrayList.add(diffEntry);
        }
        return arrayList;
    }

    private int buildMatrix(ProgressMonitor progressMonitor) {
        this.matrix = new long[this.srcs.size() * this.dsts.size()];
        long[] lArray = new long[this.srcs.size()];
        long[] lArray2 = new long[this.dsts.size()];
        BitSet bitSet = null;
        int n2 = 0;
        block4: for (int i2 = 0; i2 < this.srcs.size(); ++i2) {
            DiffEntry diffEntry = (DiffEntry)this.srcs.get(i2);
            if (!SimilarityRenameDetector.isFile(diffEntry.oldMode)) {
                progressMonitor.update(this.dsts.size());
                continue;
            }
            SimilarityIndex similarityIndex = null;
            for (int i3 = 0; i3 < this.dsts.size(); ++i3) {
                Object object;
                long l2;
                long l3;
                if (progressMonitor.isCancelled()) {
                    throw new CancelledException(JGitText.get().renameCancelled);
                }
                DiffEntry diffEntry2 = (DiffEntry)this.dsts.get(i3);
                if (!SimilarityRenameDetector.isFile(diffEntry2.newMode)) {
                    progressMonitor.update(1);
                    continue;
                }
                if (!RenameDetector.sameType(diffEntry.oldMode, diffEntry2.newMode)) {
                    progressMonitor.update(1);
                    continue;
                }
                if (bitSet != null && bitSet.get(i3)) {
                    progressMonitor.update(1);
                    continue;
                }
                long l4 = lArray[i2];
                if (l4 == 0L) {
                    lArray[i2] = l4 = this.size(DiffEntry$Side.OLD, diffEntry) + 1L;
                }
                if ((l3 = lArray2[i3]) == 0L) {
                    lArray2[i3] = l3 = this.size(DiffEntry$Side.NEW, diffEntry2) + 1L;
                }
                if ((l2 = Math.max(l4, l3)) > (long)RenameDetector.getFileSizeLimit()) {
                    progressMonitor.update(1);
                    continue;
                }
                long l5 = Math.min(l4, l3);
                if (l5 * 100L / l2 < (long)this.renameScore) {
                    progressMonitor.update(1);
                    continue;
                }
                if (l2 > (long)this.bigFileThreshold) {
                    progressMonitor.update(1);
                    continue;
                }
                if (similarityIndex == null) {
                    try {
                        object = this.reader.open(DiffEntry$Side.OLD, diffEntry);
                        if (this.skipBinaryFiles && SimilarityIndex.isBinary((ObjectLoader)object)) {
                            progressMonitor.update(1);
                            continue block4;
                        }
                        similarityIndex = this.hash((ObjectLoader)object);
                    }
                    catch (SimilarityIndex$TableFullException similarityIndex$TableFullException) {
                        this.tableOverflow = true;
                        continue block4;
                    }
                }
                try {
                    ObjectLoader objectLoader = this.reader.open(DiffEntry$Side.NEW, diffEntry2);
                    if (this.skipBinaryFiles && SimilarityIndex.isBinary(objectLoader)) {
                        progressMonitor.update(1);
                        continue;
                    }
                    object = this.hash(objectLoader);
                }
                catch (SimilarityIndex$TableFullException similarityIndex$TableFullException) {
                    if (bitSet == null) {
                        bitSet = new BitSet(this.dsts.size());
                    }
                    bitSet.set(i3);
                    this.tableOverflow = true;
                    progressMonitor.update(1);
                    continue;
                }
                int n3 = similarityIndex.score((SimilarityIndex)object, 10000);
                int n4 = SimilarityRenameDetector.nameScore(diffEntry.oldPath, diffEntry2.newPath) * 100;
                int n5 = (n3 * 99 + n4 * 1) / 10000;
                if (n5 < this.renameScore) {
                    progressMonitor.update(1);
                    continue;
                }
                this.matrix[n2++] = SimilarityRenameDetector.encode(n5, i2, i3);
                progressMonitor.update(1);
            }
        }
        Arrays.sort(this.matrix, 0, n2);
        return n2;
    }

    static int nameScore(String string, String string2) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = string.lastIndexOf(47) + 1;
        int n7 = string2.lastIndexOf(47) + 1;
        int n8 = Math.min(n6, n7);
        int n9 = Math.max(n6, n7);
        if (n9 == 0) {
            n5 = 100;
            n4 = 100;
        } else {
            for (n3 = 0; n3 < n8 && string.charAt(n3) == string2.charAt(n3); ++n3) {
            }
            n5 = n3 * 100 / n9;
            if (n5 == 100) {
                n4 = 100;
            } else {
                for (n3 = 0; n3 < n8 && string.charAt(n6 - 1 - n3) == string2.charAt(n7 - 1 - n3); ++n3) {
                }
                n4 = n3 * 100 / n9;
            }
        }
        n3 = Math.min(string.length() - n6, string2.length() - n7);
        int n10 = Math.max(string.length() - n6, string2.length() - n7);
        for (n2 = 0; n2 < n3 && string.charAt(string.length() - 1 - n2) == string2.charAt(string2.length() - 1 - n2); ++n2) {
        }
        int n11 = n2 * 100 / n10;
        return ((n5 + n4) * 25 + n11 * 50) / 100;
    }

    private SimilarityIndex hash(ObjectLoader objectLoader) {
        SimilarityIndex similarityIndex = new SimilarityIndex();
        similarityIndex.hash(objectLoader);
        similarityIndex.sort();
        return similarityIndex;
    }

    private long size(DiffEntry$Side diffEntry$Side, DiffEntry diffEntry) {
        return this.reader.size(diffEntry$Side, diffEntry);
    }

    private static int score(long l2) {
        return (int)(l2 >>> 56);
    }

    static int srcFile(long l2) {
        return SimilarityRenameDetector.decodeFile((int)(l2 >>> 28) & 0xFFFFFFF);
    }

    static int dstFile(long l2) {
        return SimilarityRenameDetector.decodeFile((int)l2 & 0xFFFFFFF);
    }

    static long encode(int n2, int n3, int n4) {
        return (long)n2 << 56 | SimilarityRenameDetector.encodeFile(n3) << 28 | SimilarityRenameDetector.encodeFile(n4);
    }

    private static long encodeFile(int n2) {
        return 0xFFFFFFF - n2;
    }

    private static int decodeFile(int n2) {
        return 0xFFFFFFF - n2;
    }

    private static boolean isFile(FileMode fileMode) {
        return (fileMode.getBits() & 0xF000) == 32768;
    }
}

