/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import java.io.EOFException;
import java.io.InputStream;
import java.util.Arrays;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.SimilarityIndex$TableFullException;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectStream;

public class SimilarityIndex {
    public static final SimilarityIndex$TableFullException TABLE_FULL_OUT_OF_MEMORY = new SimilarityIndex$TableFullException();
    private static final int KEY_SHIFT = 32;
    private static final long MAX_COUNT = 0xFFFFFFFFL;
    private long hashedCnt;
    private int idSize;
    private int idGrowAt;
    private long[] idHash = new long[1 << this.idHashBits];
    private int idHashBits = 8;

    public static SimilarityIndex create(ObjectLoader objectLoader) {
        SimilarityIndex similarityIndex = new SimilarityIndex();
        similarityIndex.hash(objectLoader);
        similarityIndex.sort();
        return similarityIndex;
    }

    SimilarityIndex() {
        this.idGrowAt = SimilarityIndex.growAt(this.idHashBits);
    }

    static boolean isBinary(ObjectLoader objectLoader) {
        if (objectLoader.isLarge()) {
            try (ObjectStream objectStream = objectLoader.openStream();){
                boolean bl2 = RawText.isBinary(objectStream);
                return bl2;
            }
        }
        return RawText.isBinary(objectLoader.getCachedBytes());
    }

    void hash(ObjectLoader objectLoader) {
        if (objectLoader.isLarge()) {
            this.hashLargeObject(objectLoader);
        } else {
            byte[] byArray = objectLoader.getCachedBytes();
            this.hash(byArray, 0, byArray.length);
        }
    }

    private void hashLargeObject(ObjectLoader objectLoader) {
        boolean bl2 = !SimilarityIndex.isBinary(objectLoader);
        try (ObjectStream objectStream = objectLoader.openStream();){
            this.hash(objectStream, objectStream.getSize(), bl2);
        }
    }

    void hash(byte[] byArray, int n2, int n3) {
        boolean bl2 = !RawText.isBinary(byArray);
        this.hashedCnt = 0L;
        while (n2 < n3) {
            int n4 = 5381;
            int n5 = 0;
            int n6 = n2;
            do {
                int n7 = byArray[n2++] & 0xFF;
                if (bl2 && n7 == 13 && n2 < n3 && byArray[n2] == 10) continue;
                ++n5;
                if (n7 == 10) break;
                n4 = (n4 << 5) + n4 + n7;
            } while (n2 < n3 && n2 - n6 < 64);
            this.hashedCnt += (long)n5;
            this.add(n4, n5);
        }
    }

    void hash(InputStream inputStream, long l2, boolean bl2) {
        byte[] byArray = new byte[4096];
        int n2 = 0;
        int n3 = 0;
        while (0L < l2) {
            int n4 = 5381;
            int n5 = 0;
            int n6 = 0;
            do {
                if (n2 == n3) {
                    n2 = 0;
                    n3 = inputStream.read(byArray, 0, byArray.length);
                    if (n3 <= 0) {
                        throw new EOFException();
                    }
                }
                ++n6;
                int n7 = byArray[n2++] & 0xFF;
                if (bl2 && n7 == 13 && n2 < n3 && byArray[n2] == 10) continue;
                ++n5;
                if (n7 == 10) break;
                n4 = (n4 << 5) + n4 + n7;
            } while (n6 < 64 && (long)n6 < l2);
            this.hashedCnt += (long)n5;
            this.add(n4, n5);
            l2 -= (long)n6;
        }
    }

    void sort() {
        Arrays.sort(this.idHash);
    }

    public int score(SimilarityIndex similarityIndex, int n2) {
        long l2 = Math.max(this.hashedCnt, similarityIndex.hashedCnt);
        if (l2 == 0L) {
            return n2;
        }
        return (int)(this.common(similarityIndex) * (long)n2 / l2);
    }

    long common(SimilarityIndex similarityIndex) {
        return SimilarityIndex.common(this, similarityIndex);
    }

    private static long common(SimilarityIndex similarityIndex, SimilarityIndex similarityIndex2) {
        int n2 = similarityIndex.packedIndex(0);
        int n3 = similarityIndex2.packedIndex(0);
        long[] lArray = similarityIndex.idHash;
        long[] lArray2 = similarityIndex2.idHash;
        return SimilarityIndex.common(lArray, n2, lArray2, n3);
    }

    private static long common(long[] lArray, int n2, long[] lArray2, int n3) {
        if (n2 == lArray.length || n3 == lArray2.length) {
            return 0L;
        }
        long l2 = 0L;
        int n4 = SimilarityIndex.keyOf(lArray[n2]);
        int n5 = SimilarityIndex.keyOf(lArray2[n3]);
        while (true) {
            if (n4 == n5) {
                l2 += Math.min(SimilarityIndex.countOf(lArray[n2]), SimilarityIndex.countOf(lArray2[n3]));
                if (++n2 == lArray.length) break;
                n4 = SimilarityIndex.keyOf(lArray[n2]);
                if (++n3 == lArray2.length) break;
                n5 = SimilarityIndex.keyOf(lArray2[n3]);
                continue;
            }
            if (n4 < n5) {
                if (++n2 == lArray.length) break;
                n4 = SimilarityIndex.keyOf(lArray[n2]);
                continue;
            }
            if (++n3 == lArray2.length) break;
            n5 = SimilarityIndex.keyOf(lArray2[n3]);
        }
        return l2;
    }

    int size() {
        return this.idSize;
    }

    int key(int n2) {
        return SimilarityIndex.keyOf(this.idHash[this.packedIndex(n2)]);
    }

    long count(int n2) {
        return SimilarityIndex.countOf(this.idHash[this.packedIndex(n2)]);
    }

    int findIndex(int n2) {
        for (int i2 = 0; i2 < this.idSize; ++i2) {
            if (this.key(i2) != n2) continue;
            return i2;
        }
        return -1;
    }

    private int packedIndex(int n2) {
        return this.idHash.length - this.idSize + n2;
    }

    void add(int n2, int n3) {
        n2 = n2 * -1640562687 >>> 1;
        int n4 = this.slot(n2);
        while (true) {
            long l2;
            if ((l2 = this.idHash[n4]) == 0L) {
                if (this.idGrowAt <= this.idSize) {
                    this.grow();
                    n4 = this.slot(n2);
                    continue;
                }
                this.idHash[n4] = SimilarityIndex.pair(n2, n3);
                ++this.idSize;
                return;
            }
            if (SimilarityIndex.keyOf(l2) == n2) {
                this.idHash[n4] = SimilarityIndex.pair(n2, SimilarityIndex.countOf(l2) + (long)n3);
                return;
            }
            if (++n4 < this.idHash.length) continue;
            n4 = 0;
        }
    }

    private static long pair(int n2, long l2) {
        if (0xFFFFFFFFL < l2) {
            throw new SimilarityIndex$TableFullException();
        }
        return (long)n2 << 32 | l2;
    }

    private int slot(int n2) {
        return n2 >>> 31 - this.idHashBits;
    }

    private static int growAt(int n2) {
        return (1 << n2) * (n2 - 3) / n2;
    }

    private void grow() {
        if (this.idHashBits == 30) {
            throw new SimilarityIndex$TableFullException();
        }
        long[] lArray = this.idHash;
        int n2 = this.idHash.length;
        ++this.idHashBits;
        this.idGrowAt = SimilarityIndex.growAt(this.idHashBits);
        try {
            this.idHash = new long[1 << this.idHashBits];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw TABLE_FULL_OUT_OF_MEMORY;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            long l2 = lArray[i2];
            if (l2 == 0L) continue;
            int n3 = this.slot(SimilarityIndex.keyOf(l2));
            while (this.idHash[n3] != 0L) {
                if (++n3 < this.idHash.length) continue;
                n3 = 0;
            }
            this.idHash[n3] = l2;
        }
    }

    private static int keyOf(long l2) {
        return (int)(l2 >>> 32);
    }

    private static long countOf(long l2) {
        return l2 & 0xFFFFFFFFL;
    }
}

