/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jgit.diff.ContentSource;
import org.eclipse.jgit.diff.ContentSource$Pair;
import org.eclipse.jgit.diff.DiffConfig;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffEntry$ChangeType;
import org.eclipse.jgit.diff.DiffEntry$Side;
import org.eclipse.jgit.diff.RenameDetector$1;
import org.eclipse.jgit.diff.SimilarityIndex;
import org.eclipse.jgit.diff.SimilarityIndex$TableFullException;
import org.eclipse.jgit.diff.SimilarityRenameDetector;
import org.eclipse.jgit.errors.CancelledException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;

public class RenameDetector {
    private static final int EXACT_RENAME_SCORE = 100;
    private static int fileSizeLimit = Integer.MAX_VALUE;
    private static int exactRenameMaxMatrixSize = Integer.MAX_VALUE;
    private static final Comparator DIFF_COMPARATOR = new RenameDetector$1();
    private List entries;
    private List deleted;
    private List added;
    private boolean done;
    private final ObjectReader objectReader;
    private int renameScore = 60;
    private int breakScore = -1;
    private int renameLimit;
    private int bigFileThreshold = 0x3200000;
    private boolean skipContentRenamesForBinaryFiles = false;
    private boolean overRenameLimit;

    public static int getFileSizeLimit() {
        return fileSizeLimit;
    }

    public static void setFileSizeLimit(int n2) {
        fileSizeLimit = n2;
    }

    public static int getExactRenameMaxMatrixSize() {
        return exactRenameMaxMatrixSize;
    }

    public static void setExactRenameMaxMatrixSize(int n2) {
        exactRenameMaxMatrixSize = n2;
    }

    public RenameDetector(Repository repository) {
        this(repository.newObjectReader(), (DiffConfig)repository.getConfig().get(DiffConfig.KEY));
    }

    public RenameDetector(ObjectReader objectReader, DiffConfig diffConfig) {
        this(diffConfig, objectReader);
    }

    public RenameDetector(DiffConfig diffConfig, ObjectReader objectReader) {
        this.objectReader = objectReader;
        this.renameLimit = diffConfig.getRenameLimit();
        this.reset();
    }

    public int getRenameScore() {
        return this.renameScore;
    }

    public void setRenameScore(int n2) {
        if (n2 < 0 || n2 > 100) {
            throw new IllegalArgumentException(JGitText.get().similarityScoreMustBeWithinBounds);
        }
        this.renameScore = n2;
    }

    public int getBreakScore() {
        return this.breakScore;
    }

    public void setBreakScore(int n2) {
        this.breakScore = n2;
    }

    public int getRenameLimit() {
        return this.renameLimit;
    }

    public void setRenameLimit(int n2) {
        this.renameLimit = n2;
    }

    public int getBigFileThreshold() {
        return this.bigFileThreshold;
    }

    public void setBigFileThreshold(int n2) {
        this.bigFileThreshold = n2;
    }

    public boolean getSkipContentRenamesForBinaryFiles() {
        return this.skipContentRenamesForBinaryFiles;
    }

    public void setSkipContentRenamesForBinaryFiles(boolean bl2) {
        this.skipContentRenamesForBinaryFiles = bl2;
    }

    public boolean isOverRenameLimit() {
        if (this.done) {
            return this.overRenameLimit;
        }
        int n2 = Math.max(this.added.size(), this.deleted.size());
        return this.getRenameLimit() != 0 && this.getRenameLimit() < n2;
    }

    public void addAll(Collection collection) {
        if (this.done) {
            throw new IllegalStateException(JGitText.get().renamesAlreadyFound);
        }
        block5: for (DiffEntry diffEntry : collection) {
            switch (diffEntry.getChangeType()) {
                case ADD: {
                    this.added.add(diffEntry);
                    continue block5;
                }
                case DELETE: {
                    this.deleted.add(diffEntry);
                    continue block5;
                }
                case MODIFY: {
                    if (RenameDetector.sameType(diffEntry.getOldMode(), diffEntry.getNewMode())) {
                        this.entries.add(diffEntry);
                        continue block5;
                    }
                    List list = DiffEntry.breakModify(diffEntry);
                    this.deleted.add(list.get(0));
                    this.added.add(list.get(1));
                    continue block5;
                }
            }
            this.entries.add(diffEntry);
        }
    }

    public void add(DiffEntry diffEntry) {
        this.addAll(Collections.singletonList(diffEntry));
    }

    public List compute() {
        return this.compute(NullProgressMonitor.INSTANCE);
    }

    public List compute(ProgressMonitor progressMonitor) {
        if (!this.done) {
            try {
                List list = this.compute(this.objectReader, progressMonitor);
                return list;
            }
            finally {
                this.objectReader.close();
            }
        }
        return Collections.unmodifiableList(this.entries);
    }

    public List compute(ObjectReader objectReader, ProgressMonitor progressMonitor) {
        ContentSource contentSource = ContentSource.create(objectReader);
        return this.compute(new ContentSource$Pair(contentSource, contentSource), progressMonitor);
    }

    public List compute(ContentSource$Pair contentSource$Pair, ProgressMonitor progressMonitor) {
        if (!this.done) {
            this.done = true;
            if (progressMonitor == null) {
                progressMonitor = NullProgressMonitor.INSTANCE;
            }
            if (0 < this.breakScore) {
                this.breakModifies(contentSource$Pair, progressMonitor);
            }
            if (!this.added.isEmpty() && !this.deleted.isEmpty()) {
                this.findExactRenames(progressMonitor);
            }
            if (!this.added.isEmpty() && !this.deleted.isEmpty()) {
                this.findContentRenames(contentSource$Pair, progressMonitor);
            }
            if (0 < this.breakScore && !this.added.isEmpty() && !this.deleted.isEmpty()) {
                this.rejoinModifies(progressMonitor);
            }
            this.entries.addAll(this.added);
            this.added = null;
            this.entries.addAll(this.deleted);
            this.deleted = null;
            Collections.sort(this.entries, DIFF_COMPARATOR);
        }
        return Collections.unmodifiableList(this.entries);
    }

    public void reset() {
        this.entries = new ArrayList();
        this.deleted = new ArrayList();
        this.added = new ArrayList();
        this.done = false;
    }

    private void advanceOrCancel(ProgressMonitor progressMonitor) {
        if (progressMonitor.isCancelled()) {
            throw new CancelledException(JGitText.get().renameCancelled);
        }
        progressMonitor.update(1);
    }

    private void breakModifies(ContentSource$Pair contentSource$Pair, ProgressMonitor progressMonitor) {
        ArrayList<DiffEntry> arrayList = new ArrayList<DiffEntry>(this.entries.size());
        progressMonitor.beginTask(JGitText.get().renamesBreakingModifies, this.entries.size());
        for (int i2 = 0; i2 < this.entries.size(); ++i2) {
            DiffEntry diffEntry = (DiffEntry)this.entries.get(i2);
            if (diffEntry.getChangeType() == DiffEntry$ChangeType.MODIFY) {
                int n2 = this.calculateModifyScore(contentSource$Pair, diffEntry);
                if (n2 < this.breakScore) {
                    List list = DiffEntry.breakModify(diffEntry);
                    DiffEntry diffEntry2 = (DiffEntry)list.get(0);
                    diffEntry2.score = n2;
                    this.deleted.add(diffEntry2);
                    this.added.add(list.get(1));
                } else {
                    arrayList.add(diffEntry);
                }
            } else {
                arrayList.add(diffEntry);
            }
            this.advanceOrCancel(progressMonitor);
        }
        this.entries = arrayList;
    }

    private void rejoinModifies(ProgressMonitor progressMonitor) {
        HashMap<String, DiffEntry> hashMap = new HashMap<String, DiffEntry>();
        ArrayList<DiffEntry> arrayList = new ArrayList<DiffEntry>(this.added.size());
        progressMonitor.beginTask(JGitText.get().renamesRejoiningModifies, this.added.size() + this.deleted.size());
        for (DiffEntry diffEntry : this.deleted) {
            hashMap.put(diffEntry.oldPath, diffEntry);
            this.advanceOrCancel(progressMonitor);
        }
        for (DiffEntry diffEntry : this.added) {
            DiffEntry diffEntry2 = (DiffEntry)hashMap.remove(diffEntry.newPath);
            if (diffEntry2 != null) {
                if (RenameDetector.sameType(diffEntry2.oldMode, diffEntry.newMode)) {
                    this.entries.add(DiffEntry.pair(DiffEntry$ChangeType.MODIFY, diffEntry2, diffEntry, diffEntry2.score));
                } else {
                    hashMap.put(diffEntry2.oldPath, diffEntry2);
                    arrayList.add(diffEntry);
                }
            } else {
                arrayList.add(diffEntry);
            }
            this.advanceOrCancel(progressMonitor);
        }
        this.added = arrayList;
        this.deleted = new ArrayList(hashMap.values());
    }

    private int calculateModifyScore(ContentSource$Pair contentSource$Pair, DiffEntry diffEntry) {
        try {
            SimilarityIndex similarityIndex = new SimilarityIndex();
            similarityIndex.hash(contentSource$Pair.open(DiffEntry$Side.OLD, diffEntry));
            similarityIndex.sort();
            SimilarityIndex similarityIndex2 = new SimilarityIndex();
            similarityIndex2.hash(contentSource$Pair.open(DiffEntry$Side.NEW, diffEntry));
            similarityIndex2.sort();
            return similarityIndex.score(similarityIndex2, 100);
        }
        catch (SimilarityIndex$TableFullException similarityIndex$TableFullException) {
            this.overRenameLimit = true;
            return this.breakScore + 1;
        }
    }

    private void findContentRenames(ContentSource$Pair contentSource$Pair, ProgressMonitor progressMonitor) {
        int n2 = Math.max(this.added.size(), this.deleted.size());
        if (this.getRenameLimit() == 0 || n2 <= this.getRenameLimit()) {
            SimilarityRenameDetector similarityRenameDetector = new SimilarityRenameDetector(contentSource$Pair, this.deleted, this.added);
            similarityRenameDetector.setRenameScore(this.getRenameScore());
            similarityRenameDetector.setBigFileThreshold(this.getBigFileThreshold());
            similarityRenameDetector.setSkipBinaryFiles(this.getSkipContentRenamesForBinaryFiles());
            similarityRenameDetector.compute(progressMonitor);
            this.overRenameLimit |= similarityRenameDetector.isTableOverflow();
            this.deleted = similarityRenameDetector.getLeftOverSources();
            this.added = similarityRenameDetector.getLeftOverDestinations();
            this.entries.addAll(similarityRenameDetector.getMatches());
        } else {
            this.overRenameLimit = true;
        }
    }

    private void findExactRenames(ProgressMonitor progressMonitor) {
        Object object;
        Object object2;
        progressMonitor.beginTask(JGitText.get().renamesFindingExact, this.added.size() + this.added.size() + this.deleted.size() + this.added.size() * this.deleted.size());
        HashMap hashMap = this.populateMap(this.deleted, progressMonitor);
        HashMap hashMap2 = this.populateMap(this.added, progressMonitor);
        ArrayList<DiffEntry> arrayList = new ArrayList<DiffEntry>(this.added.size());
        ArrayList<List> arrayList2 = new ArrayList<List>();
        for (Object object3 : hashMap2.values()) {
            if (object3 instanceof DiffEntry) {
                arrayList.add((DiffEntry)object3);
                continue;
            }
            arrayList2.add((List)object3);
        }
        ArrayList arrayList3 = new ArrayList(this.added.size());
        for (DiffEntry object4 : arrayList) {
            object2 = hashMap.get(object4.newId);
            if (object2 instanceof DiffEntry) {
                object = (DiffEntry)object2;
                if (RenameDetector.sameType(((DiffEntry)object).oldMode, object4.newMode)) {
                    ((DiffEntry)object).changeType = DiffEntry$ChangeType.RENAME;
                    this.entries.add(RenameDetector.exactRename((DiffEntry)object, object4));
                } else {
                    arrayList3.add(object4);
                }
            } else if (object2 != null) {
                object = (List)object2;
                DiffEntry diffEntry = RenameDetector.bestPathMatch(object4, (List)object);
                if (diffEntry != null) {
                    diffEntry.changeType = DiffEntry$ChangeType.RENAME;
                    this.entries.add(RenameDetector.exactRename(diffEntry, object4));
                } else {
                    arrayList3.add(object4);
                }
            } else {
                arrayList3.add(object4);
            }
            this.advanceOrCancel(progressMonitor);
        }
        for (List list : arrayList2) {
            Object object3;
            object2 = hashMap.get(((DiffEntry)list.get((int)0)).newId);
            if (object2 instanceof DiffEntry) {
                object = (DiffEntry)object2;
                DiffEntry diffEntry = RenameDetector.bestPathMatch((DiffEntry)object, list);
                if (diffEntry != null) {
                    ((DiffEntry)object).changeType = DiffEntry$ChangeType.RENAME;
                    this.entries.add(RenameDetector.exactRename(object, diffEntry));
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        object3 = (DiffEntry)iterator.next();
                        if (object3 == diffEntry) continue;
                        if (RenameDetector.sameType(((DiffEntry)object).oldMode, object3.newMode)) {
                            this.entries.add(RenameDetector.exactCopy(object, (DiffEntry)object3));
                            continue;
                        }
                        arrayList3.add(object3);
                    }
                } else {
                    arrayList3.addAll(list);
                }
            } else if (object2 != null) {
                int n2;
                object = (List)object2;
                int n3 = object.size();
                if ((long)n3 * (long)(n2 = list.size()) < (long)exactRenameMaxMatrixSize) {
                    int n4;
                    object3 = new long[n3 * n2];
                    int n5 = 0;
                    for (int i2 = 0; i2 < n3; ++i2) {
                        String string = ((DiffEntry)object.get((int)i2)).oldPath;
                        for (n4 = 0; n4 < n2; ++n4) {
                            String string2 = ((DiffEntry)list.get((int)n4)).newPath;
                            int n6 = SimilarityRenameDetector.nameScore(string2, string);
                            object3[n5] = SimilarityRenameDetector.encode(n6, i2, n4);
                            ++n5;
                            if (!progressMonitor.isCancelled()) continue;
                            throw new CancelledException(JGitText.get().renameCancelled);
                        }
                    }
                    Arrays.sort(object3);
                    --n5;
                    while (n5 >= 0) {
                        long l2 = object3[n5];
                        n4 = SimilarityRenameDetector.srcFile(l2);
                        int n7 = SimilarityRenameDetector.dstFile(l2);
                        DiffEntry diffEntry = (DiffEntry)object.get(n4);
                        DiffEntry diffEntry2 = (DiffEntry)list.get(n7);
                        if (diffEntry2 == null) {
                            this.advanceOrCancel(progressMonitor);
                        } else {
                            DiffEntry$ChangeType diffEntry$ChangeType;
                            if (diffEntry.changeType == DiffEntry$ChangeType.DELETE) {
                                diffEntry.changeType = DiffEntry$ChangeType.RENAME;
                                diffEntry$ChangeType = DiffEntry$ChangeType.RENAME;
                            } else {
                                diffEntry$ChangeType = DiffEntry$ChangeType.COPY;
                            }
                            this.entries.add(DiffEntry.pair(diffEntry$ChangeType, diffEntry, diffEntry2, 100));
                            list.set(n7, null);
                            this.advanceOrCancel(progressMonitor);
                        }
                        --n5;
                    }
                } else {
                    arrayList3.addAll(list);
                }
            } else {
                arrayList3.addAll(list);
            }
            this.advanceOrCancel(progressMonitor);
        }
        this.added = arrayList3;
        this.deleted = new ArrayList(hashMap.size());
        for (Object e2 : hashMap.values()) {
            if (e2 instanceof DiffEntry) {
                object2 = (DiffEntry)e2;
                if (((DiffEntry)object2).changeType != DiffEntry$ChangeType.DELETE) continue;
                this.deleted.add(object2);
                continue;
            }
            object2 = (List)e2;
            for (DiffEntry diffEntry : object2) {
                if (diffEntry.changeType != DiffEntry$ChangeType.DELETE) continue;
                this.deleted.add(diffEntry);
            }
        }
        progressMonitor.endTask();
    }

    private static DiffEntry bestPathMatch(DiffEntry diffEntry, List list) {
        DiffEntry diffEntry2 = null;
        int n2 = -1;
        for (DiffEntry diffEntry3 : list) {
            int n3;
            if (!RenameDetector.sameType(RenameDetector.mode(diffEntry3), RenameDetector.mode(diffEntry)) || (n3 = SimilarityRenameDetector.nameScore(RenameDetector.path(diffEntry3), RenameDetector.path(diffEntry))) <= n2) continue;
            diffEntry2 = diffEntry3;
            n2 = n3;
        }
        return diffEntry2;
    }

    private HashMap populateMap(List list, ProgressMonitor progressMonitor) {
        HashMap<AbbreviatedObjectId, Object> hashMap = new HashMap<AbbreviatedObjectId, Object>();
        for (DiffEntry diffEntry : list) {
            DiffEntry diffEntry2 = hashMap.put(RenameDetector.id(diffEntry), diffEntry);
            if (diffEntry2 instanceof DiffEntry) {
                ArrayList<DiffEntry> arrayList = new ArrayList<DiffEntry>(2);
                arrayList.add(diffEntry2);
                arrayList.add(diffEntry);
                hashMap.put(RenameDetector.id(diffEntry), arrayList);
            } else if (diffEntry2 != null) {
                ((List)((Object)diffEntry2)).add(diffEntry);
                hashMap.put(RenameDetector.id(diffEntry), diffEntry2);
            }
            this.advanceOrCancel(progressMonitor);
        }
        return hashMap;
    }

    private static String path(DiffEntry diffEntry) {
        return diffEntry.changeType == DiffEntry$ChangeType.DELETE ? diffEntry.oldPath : diffEntry.newPath;
    }

    private static FileMode mode(DiffEntry diffEntry) {
        return diffEntry.changeType == DiffEntry$ChangeType.DELETE ? diffEntry.oldMode : diffEntry.newMode;
    }

    private static AbbreviatedObjectId id(DiffEntry diffEntry) {
        return diffEntry.changeType == DiffEntry$ChangeType.DELETE ? diffEntry.oldId : diffEntry.newId;
    }

    static boolean sameType(FileMode fileMode, FileMode fileMode2) {
        int n2;
        int n3 = fileMode.getBits() & 0xF000;
        return n3 == (n2 = fileMode2.getBits() & 0xF000);
    }

    private static DiffEntry exactRename(DiffEntry diffEntry, DiffEntry diffEntry2) {
        return DiffEntry.pair(DiffEntry$ChangeType.RENAME, diffEntry, diffEntry2, 100);
    }

    private static DiffEntry exactCopy(DiffEntry diffEntry, DiffEntry diffEntry2) {
        return DiffEntry.pair(DiffEntry$ChangeType.COPY, diffEntry, diffEntry2, 100);
    }
}

