/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator$1;
import org.eclipse.jgit.diff.RawTextComparator$2;
import org.eclipse.jgit.diff.RawTextComparator$3;
import org.eclipse.jgit.diff.RawTextComparator$4;
import org.eclipse.jgit.diff.RawTextComparator$5;
import org.eclipse.jgit.diff.SequenceComparator;
import org.eclipse.jgit.util.IntList;

public abstract class RawTextComparator
extends SequenceComparator {
    public static final RawTextComparator DEFAULT = new RawTextComparator$1();
    public static final RawTextComparator WS_IGNORE_ALL = new RawTextComparator$2();
    public static final RawTextComparator WS_IGNORE_LEADING = new RawTextComparator$3();
    public static final RawTextComparator WS_IGNORE_TRAILING = new RawTextComparator$4();
    public static final RawTextComparator WS_IGNORE_CHANGE = new RawTextComparator$5();

    public int hash(RawText rawText, int n2) {
        int n3 = rawText.lines.get(n2 + 1);
        int n4 = rawText.lines.get(n2 + 2);
        return this.hashRegion(rawText.content, n3, n4);
    }

    public Edit reduceCommonStartEnd(RawText rawText, RawText rawText2, Edit edit) {
        boolean bl2;
        int n2;
        if (edit.beginA == edit.endA || edit.beginB == edit.endB) {
            return edit;
        }
        byte[] byArray = rawText.content;
        byte[] byArray2 = rawText2.content;
        int n3 = rawText.lines.get(edit.beginA + 1);
        int n4 = rawText.lines.get(edit.endA + 1);
        int n5 = rawText2.lines.get(edit.endB + 1);
        if (n3 < 0 || n2 < 0 || n4 > byArray.length || n5 > byArray2.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (n2 = rawText.lines.get(edit.beginB + 1); n3 < n4 && n2 < n5 && byArray[n3] == byArray2[n2]; ++n3, ++n2) {
        }
        while (n3 < n4 && n2 < n5 && byArray[n4 - 1] == byArray2[n5 - 1]) {
            --n4;
            --n5;
        }
        edit.beginA = RawTextComparator.findForwardLine(rawText.lines, edit.beginA, n3);
        edit.beginB = RawTextComparator.findForwardLine(rawText2.lines, edit.beginB, n2);
        edit.endA = RawTextComparator.findReverseLine(rawText.lines, edit.endA, n4);
        boolean bl3 = bl2 = n4 < rawText.lines.get(edit.endA + 1);
        if (bl2) {
            n5 += rawText.lines.get(edit.endA + 1) - n4;
        }
        edit.endB = RawTextComparator.findReverseLine(rawText2.lines, edit.endB, n5);
        if (!bl2 && n5 < rawText2.lines.get(edit.endB + 1)) {
            ++edit.endA;
        }
        return super.reduceCommonStartEnd(rawText, rawText2, edit);
    }

    private static int findForwardLine(IntList intList, int n2, int n3) {
        int n4 = intList.size() - 2;
        while (n2 < n4 && intList.get(n2 + 2) < n3) {
            ++n2;
        }
        return n2;
    }

    private static int findReverseLine(IntList intList, int n2, int n3) {
        while (0 < n2 && n3 <= intList.get(n2)) {
            --n2;
        }
        return n2;
    }

    protected abstract int hashRegion(byte[] var1, int var2, int var3);
}

