/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import java.io.EOFException;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.errors.BinaryBlobException;
import org.eclipse.jgit.errors.LargeObjectException$OutOfMemory;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.IntList;
import org.eclipse.jgit.util.RawParseUtils;

public class RawText
extends Sequence {
    public static final RawText EMPTY_TEXT = new RawText(new byte[0]);
    static final int FIRST_FEW_BYTES = 8000;
    protected final byte[] content;
    protected final IntList lines;

    public RawText(byte[] byArray) {
        this(byArray, RawParseUtils.lineMap(byArray, 0, byArray.length));
    }

    public RawText(byte[] byArray, IntList intList) {
        this.content = byArray;
        this.lines = intList;
    }

    public RawText(File file) {
        this(IO.readFully(file));
    }

    public byte[] getRawContent() {
        return this.content;
    }

    @Override
    public int size() {
        return this.lines.size() - 2;
    }

    public void writeLine(OutputStream outputStream, int n2) {
        int n3 = this.getStart(n2);
        int n4 = this.getEnd(n2);
        if (this.content[n4 - 1] == 10) {
            --n4;
        }
        outputStream.write(this.content, n3, n4 - n3);
    }

    public boolean isMissingNewlineAtEnd() {
        int n2 = this.lines.get(this.lines.size() - 1);
        if (n2 == 0) {
            return true;
        }
        return this.content[n2 - 1] != 10;
    }

    public String getString(int n2) {
        return this.getString(n2, n2 + 1, true);
    }

    public ByteBuffer getRawString(int n2) {
        int n3 = this.getStart(n2);
        int n4 = this.getEnd(n2);
        if (n4 > 0 && this.content[n4 - 1] == 10) {
            --n4;
        }
        return ByteBuffer.wrap(this.content, n3, n4 - n3);
    }

    public String getString(int n2, int n3, boolean bl2) {
        if (n2 == n3) {
            return "";
        }
        int n4 = this.getStart(n2);
        int n5 = this.getEnd(n3 - 1);
        if (bl2 && this.content[n5 - 1] == 10) {
            --n5;
        }
        return this.decode(n4, n5);
    }

    protected String decode(int n2, int n3) {
        return RawParseUtils.decode(this.content, n2, n3);
    }

    private int getStart(int n2) {
        return this.lines.get(n2 + 1);
    }

    private int getEnd(int n2) {
        return this.lines.get(n2 + 2);
    }

    public static boolean isBinary(byte[] byArray) {
        return RawText.isBinary(byArray, byArray.length);
    }

    public static boolean isBinary(InputStream inputStream) {
        int n2;
        int n3;
        byte[] byArray = new byte[8000];
        for (n2 = 0; n2 < byArray.length && (n3 = inputStream.read(byArray, n2, byArray.length - n2)) != -1; n2 += n3) {
        }
        return RawText.isBinary(byArray, n2);
    }

    public static boolean isBinary(byte[] byArray, int n2) {
        if (n2 > 8000) {
            n2 = 8000;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2] != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isCrLfText(byte[] byArray) {
        return RawText.isCrLfText(byArray, byArray.length);
    }

    public static boolean isCrLfText(InputStream inputStream) {
        int n2;
        int n3;
        byte[] byArray = new byte[8000];
        for (n2 = 0; n2 < byArray.length && (n3 = inputStream.read(byArray, n2, byArray.length - n2)) != -1; n2 += n3) {
        }
        return RawText.isCrLfText(byArray, n2);
    }

    public static boolean isCrLfText(byte[] byArray, int n2) {
        boolean bl2 = false;
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            if (byArray[i2] == 0) {
                return false;
            }
            if (byArray[i2] != 13 || byArray[i2 + 1] != 10) continue;
            bl2 = true;
        }
        return bl2;
    }

    public String getLineDelimiter() {
        if (this.size() == 0) {
            return null;
        }
        int n2 = this.getEnd(0);
        if (this.content[n2 - 1] != 10) {
            return null;
        }
        if (this.content.length > 1 && n2 > 1 && this.content[n2 - 2] == 13) {
            return "\r\n";
        }
        return "\n";
    }

    public static RawText load(ObjectLoader objectLoader, int n2) {
        long l2 = objectLoader.getSize();
        if (l2 > (long)n2) {
            throw new BinaryBlobException();
        }
        if (l2 <= 8000L) {
            byte[] byArray = objectLoader.getCachedBytes(8000);
            if (RawText.isBinary(byArray)) {
                throw new BinaryBlobException();
            }
            return new RawText(byArray);
        }
        byte[] byArray = new byte[8000];
        try (ObjectStream objectStream = objectLoader.openStream();){
            byte[] byArray2;
            int n3 = 0;
            int n4 = byArray.length;
            while (n4 > 0) {
                int n5 = objectStream.read(byArray, n3, n4);
                if (n5 < 0) {
                    throw new EOFException();
                }
                n4 -= n5;
                while (n5 > 0) {
                    if (byArray[n3] == 0) {
                        throw new BinaryBlobException();
                    }
                    ++n3;
                    --n5;
                }
            }
            try {
                byArray2 = new byte[(int)l2];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new LargeObjectException$OutOfMemory(outOfMemoryError);
            }
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            IO.readFully(objectStream, byArray2, n3, (int)(l2 - (long)n3));
            RawText rawText = new RawText(byArray2, RawParseUtils.lineMapOrBinary(byArray2, 0, (int)l2));
            return rawText;
        }
    }
}

