/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import java.io.File;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.Edit$Type;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.HashedSequence;
import org.eclipse.jgit.diff.HashedSequenceComparator;
import org.eclipse.jgit.diff.MyersDiff$1;
import org.eclipse.jgit.diff.MyersDiff$MiddleEdit;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.internal.JGitText;

public class MyersDiff {
    public static final DiffAlgorithm INSTANCE = new MyersDiff$1();
    protected EditList edits;
    protected HashedSequenceComparator cmp;
    protected HashedSequence a;
    protected HashedSequence b;
    MyersDiff$MiddleEdit middle = new MyersDiff$MiddleEdit(this);

    private MyersDiff(EditList editList, HashedSequenceComparator hashedSequenceComparator, HashedSequence hashedSequence, HashedSequence hashedSequence2, Edit edit) {
        this.edits = editList;
        this.cmp = hashedSequenceComparator;
        this.a = hashedSequence;
        this.b = hashedSequence2;
        this.calculateEdits(edit);
    }

    private void calculateEdits(Edit edit) {
        this.middle.initialize(edit.beginA, edit.endA, edit.beginB, edit.endB);
        if (this.middle.beginA >= this.middle.endA && this.middle.beginB >= this.middle.endB) {
            return;
        }
        this.calculateEdits(this.middle.beginA, this.middle.endA, this.middle.beginB, this.middle.endB);
    }

    protected void calculateEdits(int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        Edit edit = this.middle.calculate(n2, n3, n4, n5);
        if (n2 < edit.beginA || n4 < edit.beginB) {
            n7 = edit.beginB - edit.beginA;
            n6 = this.middle.backward.snake(n7, edit.beginA);
            this.calculateEdits(n2, n6, n4, n7 + n6);
        }
        if (edit.getType() != Edit$Type.EMPTY) {
            this.edits.add(this.edits.size(), edit);
        }
        if (n3 > edit.endA || n5 > edit.endB) {
            n7 = edit.endB - edit.endA;
            n6 = this.middle.forward.snake(n7, edit.endA);
            this.calculateEdits(n6, n3, n7 + n6, n5);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.err.println(JGitText.get().need2Arguments);
            System.exit(1);
        }
        try {
            RawText rawText = new RawText(new File(stringArray[0]));
            RawText rawText2 = new RawText(new File(stringArray[1]));
            EditList editList = INSTANCE.diff(RawTextComparator.DEFAULT, rawText, rawText2);
            System.out.println(editList.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /* synthetic */ MyersDiff(EditList editList, HashedSequenceComparator hashedSequenceComparator, HashedSequence hashedSequence, HashedSequence hashedSequence2, Edit edit, MyersDiff$1 myersDiff$1) {
        this(editList, hashedSequenceComparator, hashedSequence, hashedSequence2, edit);
    }
}

