/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.HashedSequence;
import org.eclipse.jgit.diff.HashedSequenceComparator;
import org.eclipse.jgit.internal.JGitText;

final class HistogramDiffIndex {
    private static final int REC_NEXT_SHIFT = 36;
    private static final int REC_PTR_SHIFT = 8;
    private static final int REC_PTR_MASK = 0xFFFFFFF;
    private static final int REC_CNT_MASK = 255;
    private static final int MAX_PTR = 0xFFFFFFF;
    private static final int MAX_CNT = 255;
    private final int maxChainLength;
    private final HashedSequenceComparator cmp;
    private final HashedSequence a;
    private final HashedSequence b;
    private final Edit region;
    private final int[] table;
    private final int keyShift;
    private long[] recs;
    private int recCnt;
    private int[] next;
    private int[] recIdx;
    private int ptrShift;
    private Edit lcs;
    private int cnt;
    private boolean hasCommon;

    HistogramDiffIndex(int n2, HashedSequenceComparator hashedSequenceComparator, HashedSequence hashedSequence, HashedSequence hashedSequence2, Edit edit) {
        this.maxChainLength = n2;
        this.cmp = hashedSequenceComparator;
        this.a = hashedSequence;
        this.b = hashedSequence2;
        this.region = edit;
        if (this.region.endA >= 0xFFFFFFF) {
            throw new IllegalArgumentException(JGitText.get().sequenceTooLargeForDiffAlgorithm);
        }
        int n3 = edit.getLengthA();
        int n4 = HistogramDiffIndex.tableBits(n3);
        this.table = new int[1 << n4];
        this.keyShift = 32 - n4;
        this.ptrShift = edit.beginA;
        this.recs = new long[Math.max(4, n3 >>> 3)];
        this.next = new int[n3];
        this.recIdx = new int[n3];
    }

    Edit findLongestCommonSequence() {
        if (!this.scanA()) {
            return null;
        }
        this.lcs = new Edit(0, 0);
        this.cnt = this.maxChainLength + 1;
        int n2 = this.region.beginB;
        while (n2 < this.region.endB) {
            n2 = this.tryLongestCommonSequence(n2);
        }
        return this.hasCommon && this.maxChainLength < this.cnt ? null : this.lcs;
    }

    private boolean scanA() {
        block0: for (int i2 = this.region.endA - 1; this.region.beginA <= i2; --i2) {
            int n2 = this.hash(this.a, i2);
            int n3 = 0;
            int n4 = this.table[n2];
            while (n4 != 0) {
                long l2 = this.recs[n4];
                if (this.cmp.equals(this.a, HistogramDiffIndex.recPtr(l2), this.a, i2)) {
                    int n5 = HistogramDiffIndex.recCnt(l2) + 1;
                    if (255 < n5) {
                        n5 = 255;
                    }
                    this.recs[n4] = HistogramDiffIndex.recCreate(HistogramDiffIndex.recNext(l2), i2, n5);
                    this.next[i2 - this.ptrShift] = HistogramDiffIndex.recPtr(l2);
                    this.recIdx[i2 - this.ptrShift] = n4;
                    continue block0;
                }
                n4 = HistogramDiffIndex.recNext(l2);
                ++n3;
            }
            if (n3 == this.maxChainLength) {
                return false;
            }
            if ((n4 = ++this.recCnt) == this.recs.length) {
                int n6 = Math.min(this.recs.length << 1, 1 + this.region.getLengthA());
                long[] lArray = new long[n6];
                System.arraycopy(this.recs, 0, lArray, 0, this.recs.length);
                this.recs = lArray;
            }
            this.recs[n4] = HistogramDiffIndex.recCreate(this.table[n2], i2, 1);
            this.recIdx[i2 - this.ptrShift] = n4;
            this.table[n2] = n4;
        }
        return true;
    }

    private int tryLongestCommonSequence(int n2) {
        int n3 = n2 + 1;
        int n4 = this.table[this.hash(this.b, n2)];
        while (n4 != 0) {
            long l2 = this.recs[n4];
            if (HistogramDiffIndex.recCnt(l2) > this.cnt) {
                if (!this.hasCommon) {
                    this.hasCommon = this.cmp.equals(this.a, HistogramDiffIndex.recPtr(l2), this.b, n2);
                }
            } else {
                int n5 = HistogramDiffIndex.recPtr(l2);
                if (this.cmp.equals(this.a, n5, this.b, n2)) {
                    this.hasCommon = true;
                    block1: while (true) {
                        int n6;
                        int n7 = this.next[n5 - this.ptrShift];
                        int n8 = n5 + 1;
                        int n9 = n6 + 1;
                        int n10 = HistogramDiffIndex.recCnt(l2);
                        for (n6 = n2; this.region.beginA < n5 && this.region.beginB < n6 && this.cmp.equals(this.a, n5 - 1, this.b, n6 - 1); --n5, --n6) {
                            if (1 >= n10) continue;
                            n10 = Math.min(n10, HistogramDiffIndex.recCnt(this.recs[this.recIdx[n5 - this.ptrShift]]));
                        }
                        while (n8 < this.region.endA && n9 < this.region.endB && this.cmp.equals(this.a, n8, this.b, n9)) {
                            if (1 < n10) {
                                n10 = Math.min(n10, HistogramDiffIndex.recCnt(this.recs[this.recIdx[n8 - this.ptrShift]]));
                            }
                            ++n8;
                            ++n9;
                        }
                        if (n3 < n9) {
                            n3 = n9;
                        }
                        if (this.lcs.getLengthA() < n8 - n5 || n10 < this.cnt) {
                            this.lcs.beginA = n5;
                            this.lcs.beginB = n6;
                            this.lcs.endA = n8;
                            this.lcs.endB = n9;
                            this.cnt = n10;
                        }
                        if (n7 == 0) break;
                        while (n7 < n8) {
                            if ((n7 = this.next[n7 - this.ptrShift]) != 0) continue;
                            break block1;
                        }
                        n5 = n7;
                    }
                }
            }
            n4 = HistogramDiffIndex.recNext(l2);
        }
        return n3;
    }

    private int hash(HashedSequence hashedSequence, int n2) {
        return this.cmp.hash(hashedSequence, n2) * -1640562687 >>> this.keyShift;
    }

    private static long recCreate(int n2, int n3, int n4) {
        return (long)n2 << 36 | (long)n3 << 8 | (long)n4;
    }

    private static int recNext(long l2) {
        return (int)(l2 >>> 36);
    }

    private static int recPtr(long l2) {
        return (int)(l2 >>> 8) & 0xFFFFFFF;
    }

    private static int recCnt(long l2) {
        return (int)l2 & 0xFF;
    }

    private static int tableBits(int n2) {
        int n3 = 31 - Integer.numberOfLeadingZeros(n2);
        if (n3 == 0) {
            n3 = 1;
        }
        if (1 << n3 < n2) {
            ++n3;
        }
        return n3;
    }
}

