/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import org.eclipse.jgit.diff.HashedSequence;
import org.eclipse.jgit.diff.HashedSequenceComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.SequenceComparator;

public class HashedSequencePair {
    private final SequenceComparator cmp;
    private final Sequence baseA;
    private final Sequence baseB;
    private HashedSequence cachedA;
    private HashedSequence cachedB;

    public HashedSequencePair(SequenceComparator sequenceComparator, Sequence sequence, Sequence sequence2) {
        this.cmp = sequenceComparator;
        this.baseA = sequence;
        this.baseB = sequence2;
    }

    public HashedSequenceComparator getComparator() {
        return new HashedSequenceComparator(this.cmp);
    }

    public HashedSequence getA() {
        if (this.cachedA == null) {
            this.cachedA = this.wrap(this.baseA);
        }
        return this.cachedA;
    }

    public HashedSequence getB() {
        if (this.cachedB == null) {
            this.cachedB = this.wrap(this.baseB);
        }
        return this.cachedB;
    }

    private HashedSequence wrap(Sequence sequence) {
        int n2 = sequence.size();
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = this.cmp.hash(sequence, i2);
        }
        return new HashedSequence(sequence, nArray);
    }
}

