/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import org.eclipse.jgit.diff.Edit$Type;

public class Edit {
    int beginA;
    int endA;
    int beginB;
    int endB;

    public Edit(int n2, int n3) {
        this(n2, n2, n3, n3);
    }

    public Edit(int n2, int n3, int n4, int n5) {
        this.beginA = n2;
        this.endA = n3;
        this.beginB = n4;
        this.endB = n5;
    }

    public final Edit$Type getType() {
        if (this.beginA < this.endA) {
            if (this.beginB < this.endB) {
                return Edit$Type.REPLACE;
            }
            return Edit$Type.DELETE;
        }
        if (this.beginB < this.endB) {
            return Edit$Type.INSERT;
        }
        return Edit$Type.EMPTY;
    }

    public final boolean isEmpty() {
        return this.beginA == this.endA && this.beginB == this.endB;
    }

    public final int getBeginA() {
        return this.beginA;
    }

    public final int getEndA() {
        return this.endA;
    }

    public final int getBeginB() {
        return this.beginB;
    }

    public final int getEndB() {
        return this.endB;
    }

    public final int getLengthA() {
        return this.endA - this.beginA;
    }

    public final int getLengthB() {
        return this.endB - this.beginB;
    }

    public final void shift(int n2) {
        this.beginA += n2;
        this.endA += n2;
        this.beginB += n2;
        this.endB += n2;
    }

    public final Edit before(Edit edit) {
        return new Edit(this.beginA, edit.beginA, this.beginB, edit.beginB);
    }

    public final Edit after(Edit edit) {
        return new Edit(edit.endA, this.endA, edit.endB, this.endB);
    }

    public void extendA() {
        ++this.endA;
    }

    public void extendB() {
        ++this.endB;
    }

    public void swap() {
        int n2 = this.beginA;
        int n3 = this.endA;
        this.beginA = this.beginB;
        this.endA = this.endB;
        this.beginB = n2;
        this.endB = n3;
    }

    public int hashCode() {
        return this.beginA ^ this.endA;
    }

    public boolean equals(Object object) {
        if (object instanceof Edit) {
            Edit edit = (Edit)object;
            return this.beginA == edit.beginA && this.endA == edit.endA && this.beginB == edit.beginB && this.endB == edit.endB;
        }
        return false;
    }

    public String toString() {
        Edit$Type edit$Type = this.getType();
        return (Object)((Object)edit$Type) + "(" + this.beginA + "-" + this.endA + "," + this.beginB + "-" + this.endB + ")";
    }
}

