/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.diff.ContentSource;
import org.eclipse.jgit.diff.ContentSource$Pair;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.diff.DiffAlgorithm$SupportedAlgorithm;
import org.eclipse.jgit.diff.DiffConfig;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffEntry$ChangeType;
import org.eclipse.jgit.diff.DiffEntry$Side;
import org.eclipse.jgit.diff.DiffFormatter$FormatResult;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.BinaryBlobException;
import org.eclipse.jgit.errors.CancelledException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.patch.FileHeader;
import org.eclipse.jgit.patch.FileHeader$PatchType;
import org.eclipse.jgit.patch.HunkHeader;
import org.eclipse.jgit.revwalk.FollowFilter;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.IndexDiffFilter;
import org.eclipse.jgit.treewalk.filter.NotIgnoredFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.LfsFactory;
import org.eclipse.jgit.util.QuotedString;

public class DiffFormatter
implements AutoCloseable {
    private static final int DEFAULT_BINARY_FILE_THRESHOLD = 0x3200000;
    private static final byte[] noNewLine = Constants.encodeASCII("\\ No newline at end of file\n");
    private static final byte[] EMPTY = new byte[0];
    private final OutputStream out;
    private ObjectReader reader;
    private boolean closeReader;
    private DiffConfig diffCfg;
    private int context = 3;
    private int abbreviationLength = 7;
    private DiffAlgorithm diffAlgorithm;
    private RawTextComparator comparator = RawTextComparator.DEFAULT;
    private int binaryFileThreshold = 0x3200000;
    private String oldPrefix = "a/";
    private String newPrefix = "b/";
    private TreeFilter pathFilter = TreeFilter.ALL;
    private RenameDetector renameDetector;
    private ProgressMonitor progressMonitor;
    private ContentSource$Pair source;
    private Repository repository;
    private Boolean quotePaths;

    public DiffFormatter(OutputStream outputStream) {
        this.out = outputStream;
    }

    protected OutputStream getOutputStream() {
        return this.out;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
        this.setReader(repository.newObjectReader(), repository.getConfig(), true);
    }

    public void setReader(ObjectReader objectReader, Config config) {
        this.setReader(objectReader, config, false);
    }

    private void setReader(ObjectReader objectReader, Config config, boolean bl2) {
        this.close();
        this.closeReader = bl2;
        this.reader = objectReader;
        this.diffCfg = (DiffConfig)config.get(DiffConfig.KEY);
        if (this.quotePaths == null) {
            this.quotePaths = config.getBoolean("core", "quotePath", true);
        }
        ContentSource contentSource = ContentSource.create(objectReader);
        this.source = new ContentSource$Pair(contentSource, contentSource);
        if (this.diffCfg.isNoPrefix()) {
            this.setOldPrefix("");
            this.setNewPrefix("");
        }
        this.setDetectRenames(this.diffCfg.isRenameDetectionEnabled());
        this.diffAlgorithm = DiffAlgorithm.getAlgorithm((DiffAlgorithm$SupportedAlgorithm)config.getEnum("diff", null, "algorithm", DiffAlgorithm$SupportedAlgorithm.HISTOGRAM));
    }

    public void setContext(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(JGitText.get().contextMustBeNonNegative);
        }
        this.context = n2;
    }

    public void setAbbreviationLength(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(JGitText.get().abbreviationLengthMustBeNonNegative);
        }
        this.abbreviationLength = n2;
    }

    public void setDiffAlgorithm(DiffAlgorithm diffAlgorithm) {
        this.diffAlgorithm = diffAlgorithm;
    }

    public void setDiffComparator(RawTextComparator rawTextComparator) {
        this.comparator = rawTextComparator;
    }

    public void setBinaryFileThreshold(int n2) {
        this.binaryFileThreshold = n2;
    }

    public void setOldPrefix(String string) {
        this.oldPrefix = string;
    }

    public String getOldPrefix() {
        return this.oldPrefix;
    }

    public void setNewPrefix(String string) {
        this.newPrefix = string;
    }

    public String getNewPrefix() {
        return this.newPrefix;
    }

    public boolean isDetectRenames() {
        return this.renameDetector != null;
    }

    public void setDetectRenames(boolean bl2) {
        if (bl2 && this.renameDetector == null) {
            this.assertHaveReader();
            this.renameDetector = new RenameDetector(this.reader, this.diffCfg);
        } else if (!bl2) {
            this.renameDetector = null;
        }
    }

    public RenameDetector getRenameDetector() {
        return this.renameDetector;
    }

    public void setProgressMonitor(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public void setQuotePaths(boolean bl2) {
        this.quotePaths = bl2;
    }

    public void setPathFilter(TreeFilter treeFilter) {
        this.pathFilter = treeFilter != null ? treeFilter : TreeFilter.ALL;
    }

    public TreeFilter getPathFilter() {
        return this.pathFilter;
    }

    public void flush() {
        this.out.flush();
    }

    @Override
    public void close() {
        if (this.reader != null && this.closeReader) {
            this.reader.close();
        }
    }

    public List scan(AnyObjectId anyObjectId, AnyObjectId anyObjectId2) {
        this.assertHaveReader();
        try (RevWalk revWalk = new RevWalk(this.reader);){
            RevTree revTree = anyObjectId != null ? revWalk.parseTree(anyObjectId) : null;
            RevTree revTree2 = anyObjectId2 != null ? revWalk.parseTree(anyObjectId2) : null;
            List list = this.scan(revTree, revTree2);
            return list;
        }
    }

    public List scan(RevTree revTree, RevTree revTree2) {
        this.assertHaveReader();
        AbstractTreeIterator abstractTreeIterator = this.makeIteratorFromTreeOrNull(revTree);
        AbstractTreeIterator abstractTreeIterator2 = this.makeIteratorFromTreeOrNull(revTree2);
        return this.scan(abstractTreeIterator, abstractTreeIterator2);
    }

    private AbstractTreeIterator makeIteratorFromTreeOrNull(RevTree revTree) {
        if (revTree != null) {
            CanonicalTreeParser canonicalTreeParser = new CanonicalTreeParser();
            canonicalTreeParser.reset(this.reader, revTree);
            return canonicalTreeParser;
        }
        return new EmptyTreeIterator();
    }

    public List scan(AbstractTreeIterator abstractTreeIterator, AbstractTreeIterator abstractTreeIterator2) {
        this.assertHaveReader();
        TreeWalk treeWalk = new TreeWalk(this.repository, this.reader);
        int n2 = treeWalk.addTree(abstractTreeIterator);
        int n3 = treeWalk.addTree(abstractTreeIterator2);
        if (this.repository != null) {
            if (abstractTreeIterator instanceof WorkingTreeIterator && abstractTreeIterator2 instanceof DirCacheIterator) {
                ((WorkingTreeIterator)abstractTreeIterator).setDirCacheIterator(treeWalk, n3);
            } else if (abstractTreeIterator2 instanceof WorkingTreeIterator && abstractTreeIterator instanceof DirCacheIterator) {
                ((WorkingTreeIterator)abstractTreeIterator2).setDirCacheIterator(treeWalk, n2);
            }
        }
        treeWalk.setRecursive(true);
        TreeFilter treeFilter = DiffFormatter.getDiffTreeFilterFor(abstractTreeIterator, abstractTreeIterator2);
        if (this.pathFilter instanceof FollowFilter) {
            treeWalk.setFilter(AndTreeFilter.create(PathFilter.create(((FollowFilter)this.pathFilter).getPath()), treeFilter));
        } else {
            treeWalk.setFilter(AndTreeFilter.create(this.pathFilter, treeFilter));
        }
        this.source = new ContentSource$Pair(this.source(abstractTreeIterator), this.source(abstractTreeIterator2));
        List list = DiffEntry.scan(treeWalk);
        if (this.pathFilter instanceof FollowFilter && this.isAdd(list)) {
            abstractTreeIterator.reset();
            abstractTreeIterator2.reset();
            treeWalk.reset();
            treeWalk.addTree(abstractTreeIterator);
            treeWalk.addTree(abstractTreeIterator2);
            treeWalk.setFilter(treeFilter);
            if (this.renameDetector == null) {
                this.setDetectRenames(true);
            }
            list = this.updateFollowFilter(this.detectRenames(DiffEntry.scan(treeWalk)));
        } else if (this.renameDetector != null) {
            list = this.detectRenames(list);
        }
        return list;
    }

    private static TreeFilter getDiffTreeFilterFor(AbstractTreeIterator abstractTreeIterator, AbstractTreeIterator abstractTreeIterator2) {
        if (abstractTreeIterator instanceof DirCacheIterator && abstractTreeIterator2 instanceof WorkingTreeIterator) {
            return new IndexDiffFilter(0, 1);
        }
        if (abstractTreeIterator instanceof WorkingTreeIterator && abstractTreeIterator2 instanceof DirCacheIterator) {
            return new IndexDiffFilter(1, 0);
        }
        TreeFilter treeFilter = TreeFilter.ANY_DIFF;
        if (abstractTreeIterator instanceof WorkingTreeIterator) {
            treeFilter = AndTreeFilter.create(new NotIgnoredFilter(0), treeFilter);
        }
        if (abstractTreeIterator2 instanceof WorkingTreeIterator) {
            treeFilter = AndTreeFilter.create(new NotIgnoredFilter(1), treeFilter);
        }
        return treeFilter;
    }

    private ContentSource source(AbstractTreeIterator abstractTreeIterator) {
        if (abstractTreeIterator instanceof WorkingTreeIterator) {
            return ContentSource.create((WorkingTreeIterator)abstractTreeIterator);
        }
        return ContentSource.create(this.reader);
    }

    private List detectRenames(List list) {
        this.renameDetector.reset();
        this.renameDetector.addAll(list);
        try {
            return this.renameDetector.compute(this.reader, this.progressMonitor);
        }
        catch (CancelledException cancelledException) {
            return Collections.emptyList();
        }
    }

    private boolean isAdd(List list) {
        String string = ((FollowFilter)this.pathFilter).getPath();
        for (DiffEntry diffEntry : list) {
            if (diffEntry.getChangeType() != DiffEntry$ChangeType.ADD || !diffEntry.getNewPath().equals(string)) continue;
            return true;
        }
        return false;
    }

    private List updateFollowFilter(List list) {
        String string = ((FollowFilter)this.pathFilter).getPath();
        for (DiffEntry diffEntry : list) {
            if (!DiffFormatter.isRename(diffEntry) || !diffEntry.getNewPath().equals(string)) continue;
            this.pathFilter = FollowFilter.create(diffEntry.getOldPath(), this.diffCfg);
            return Collections.singletonList(diffEntry);
        }
        return Collections.emptyList();
    }

    private static boolean isRename(DiffEntry diffEntry) {
        return diffEntry.getChangeType() == DiffEntry$ChangeType.RENAME || diffEntry.getChangeType() == DiffEntry$ChangeType.COPY;
    }

    public void format(AnyObjectId anyObjectId, AnyObjectId anyObjectId2) {
        this.format(this.scan(anyObjectId, anyObjectId2));
    }

    public void format(RevTree revTree, RevTree revTree2) {
        this.format(this.scan(revTree, revTree2));
    }

    public void format(AbstractTreeIterator abstractTreeIterator, AbstractTreeIterator abstractTreeIterator2) {
        this.format(this.scan(abstractTreeIterator, abstractTreeIterator2));
    }

    public void format(List list) {
        for (DiffEntry diffEntry : list) {
            this.format(diffEntry);
        }
    }

    public void format(DiffEntry diffEntry) {
        DiffFormatter$FormatResult diffFormatter$FormatResult = this.createFormatResult(diffEntry);
        this.format(diffFormatter$FormatResult.header, diffFormatter$FormatResult.a, diffFormatter$FormatResult.b);
    }

    private static byte[] writeGitLinkText(AbbreviatedObjectId abbreviatedObjectId) {
        if (ObjectId.zeroId().equals(abbreviatedObjectId.toObjectId())) {
            return EMPTY;
        }
        return Constants.encodeASCII("Subproject commit " + abbreviatedObjectId.name() + "\n");
    }

    private String format(AbbreviatedObjectId abbreviatedObjectId) {
        if (abbreviatedObjectId.isComplete() && this.reader != null) {
            try {
                abbreviatedObjectId = this.reader.abbreviate(abbreviatedObjectId.toObjectId(), this.abbreviationLength);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return abbreviatedObjectId.name();
    }

    private String quotePath(String string) {
        if (this.quotePaths == null || this.quotePaths.booleanValue()) {
            return QuotedString.GIT_PATH.quote(string);
        }
        return QuotedString.GIT_PATH_MINIMAL.quote(string);
    }

    public void format(FileHeader fileHeader, RawText rawText, RawText rawText2) {
        int n2 = fileHeader.getStartOffset();
        int n3 = fileHeader.getEndOffset();
        if (!fileHeader.getHunks().isEmpty()) {
            n3 = ((HunkHeader)fileHeader.getHunks().get(0)).getStartOffset();
        }
        this.out.write(fileHeader.getBuffer(), n2, n3 - n2);
        if (fileHeader.getPatchType() == FileHeader$PatchType.UNIFIED) {
            this.format(fileHeader.toEditList(), rawText, rawText2);
        }
    }

    public void format(EditList editList, RawText rawText, RawText rawText2) {
        int n2 = 0;
        while (n2 < editList.size()) {
            Edit edit = (Edit)editList.get(n2);
            int n3 = this.findCombinedEnd(editList, n2);
            Edit edit2 = (Edit)editList.get(n3);
            int n4 = (int)Math.max(0L, (long)edit.getBeginA() - (long)this.context);
            int n5 = (int)Math.max(0L, (long)edit.getBeginB() - (long)this.context);
            int n6 = (int)Math.min((long)rawText.size(), (long)edit2.getEndA() + (long)this.context);
            int n7 = (int)Math.min((long)rawText2.size(), (long)edit2.getEndB() + (long)this.context);
            this.writeHunkHeader(n4, n6, n5, n7);
            while (n4 < n6 || n5 < n7) {
                if (n4 < edit.getBeginA() || n3 + 1 < n2) {
                    this.writeContextLine(rawText, n4);
                    if (DiffFormatter.isEndOfLineMissing(rawText, n4)) {
                        this.out.write(noNewLine);
                    }
                    ++n4;
                    ++n5;
                } else if (n4 < edit.getEndA()) {
                    this.writeRemovedLine(rawText, n4);
                    if (DiffFormatter.isEndOfLineMissing(rawText, n4)) {
                        this.out.write(noNewLine);
                    }
                    ++n4;
                } else if (n5 < edit.getEndB()) {
                    this.writeAddedLine(rawText2, n5);
                    if (DiffFormatter.isEndOfLineMissing(rawText2, n5)) {
                        this.out.write(noNewLine);
                    }
                    ++n5;
                }
                if (!DiffFormatter.end(edit, n4, n5) || ++n2 >= editList.size()) continue;
                edit = (Edit)editList.get(n2);
            }
        }
    }

    protected void writeContextLine(RawText rawText, int n2) {
        this.writeLine(' ', rawText, n2);
    }

    private static boolean isEndOfLineMissing(RawText rawText, int n2) {
        return n2 + 1 == rawText.size() && rawText.isMissingNewlineAtEnd();
    }

    protected void writeAddedLine(RawText rawText, int n2) {
        this.writeLine('+', rawText, n2);
    }

    protected void writeRemovedLine(RawText rawText, int n2) {
        this.writeLine('-', rawText, n2);
    }

    protected void writeHunkHeader(int n2, int n3, int n4, int n5) {
        this.out.write(64);
        this.out.write(64);
        this.writeRange('-', n2 + 1, n3 - n2);
        this.writeRange('+', n4 + 1, n5 - n4);
        this.out.write(32);
        this.out.write(64);
        this.out.write(64);
        this.out.write(10);
    }

    private void writeRange(char c2, int n2, int n3) {
        this.out.write(32);
        this.out.write(c2);
        switch (n3) {
            case 0: {
                this.out.write(Constants.encodeASCII(n2 - 1));
                this.out.write(44);
                this.out.write(48);
                break;
            }
            case 1: {
                this.out.write(Constants.encodeASCII(n2));
                break;
            }
            default: {
                this.out.write(Constants.encodeASCII(n2));
                this.out.write(44);
                this.out.write(Constants.encodeASCII(n3));
            }
        }
    }

    protected void writeLine(char c2, RawText rawText, int n2) {
        this.out.write(c2);
        rawText.writeLine(this.out, n2);
        this.out.write(10);
    }

    public FileHeader toFileHeader(DiffEntry diffEntry) {
        return this.createFormatResult((DiffEntry)diffEntry).header;
    }

    private DiffFormatter$FormatResult createFormatResult(DiffEntry diffEntry) {
        DiffFormatter$FormatResult diffFormatter$FormatResult = new DiffFormatter$FormatResult(null);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.formatHeader(byteArrayOutputStream, diffEntry);
        if (diffEntry.getOldId() == null || diffEntry.getNewId() == null) {
            EditList editList = new EditList();
            FileHeader$PatchType fileHeader$PatchType = FileHeader$PatchType.UNIFIED;
            diffFormatter$FormatResult.header = new FileHeader(byteArrayOutputStream.toByteArray(), editList, fileHeader$PatchType);
            return diffFormatter$FormatResult;
        }
        this.assertHaveReader();
        RawText rawText = null;
        RawText rawText2 = null;
        if (diffEntry.getOldMode() == FileMode.GITLINK || diffEntry.getNewMode() == FileMode.GITLINK) {
            rawText = new RawText(DiffFormatter.writeGitLinkText(diffEntry.getOldId()));
            rawText2 = new RawText(DiffFormatter.writeGitLinkText(diffEntry.getNewId()));
        } else {
            try {
                rawText = this.open(DiffEntry$Side.OLD, diffEntry);
                rawText2 = this.open(DiffEntry$Side.NEW, diffEntry);
            }
            catch (BinaryBlobException binaryBlobException) {
                this.formatOldNewPaths(byteArrayOutputStream, diffEntry);
                byteArrayOutputStream.write(Constants.encodeASCII("Binary files differ\n"));
                EditList editList = new EditList();
                FileHeader$PatchType fileHeader$PatchType = FileHeader$PatchType.BINARY;
                diffFormatter$FormatResult.header = new FileHeader(byteArrayOutputStream.toByteArray(), editList, fileHeader$PatchType);
                return diffFormatter$FormatResult;
            }
        }
        diffFormatter$FormatResult.a = rawText;
        diffFormatter$FormatResult.b = rawText2;
        EditList editList = this.diff(diffFormatter$FormatResult.a, diffFormatter$FormatResult.b);
        FileHeader$PatchType fileHeader$PatchType = FileHeader$PatchType.UNIFIED;
        switch (diffEntry.getChangeType()) {
            case RENAME: 
            case COPY: {
                if (editList.isEmpty()) break;
                this.formatOldNewPaths(byteArrayOutputStream, diffEntry);
                break;
            }
            default: {
                this.formatOldNewPaths(byteArrayOutputStream, diffEntry);
            }
        }
        diffFormatter$FormatResult.header = new FileHeader(byteArrayOutputStream.toByteArray(), editList, fileHeader$PatchType);
        return diffFormatter$FormatResult;
    }

    private EditList diff(RawText rawText, RawText rawText2) {
        return this.diffAlgorithm.diff(this.comparator, rawText, rawText2);
    }

    private void assertHaveReader() {
        if (this.reader == null) {
            throw new IllegalStateException(JGitText.get().readerIsRequired);
        }
    }

    private RawText open(DiffEntry$Side diffEntry$Side, DiffEntry diffEntry) {
        Object object;
        if (diffEntry.getMode(diffEntry$Side) == FileMode.MISSING) {
            return RawText.EMPTY_TEXT;
        }
        if (diffEntry.getMode(diffEntry$Side).getObjectType() != 3) {
            return RawText.EMPTY_TEXT;
        }
        AbbreviatedObjectId abbreviatedObjectId = diffEntry.getId(diffEntry$Side);
        if (!abbreviatedObjectId.isComplete()) {
            object = this.reader.resolve(abbreviatedObjectId);
            if (object.size() == 1) {
                abbreviatedObjectId = AbbreviatedObjectId.fromObjectId((AnyObjectId)object.iterator().next());
                switch (diffEntry$Side) {
                    case OLD: {
                        diffEntry.oldId = abbreviatedObjectId;
                        break;
                    }
                    case NEW: {
                        diffEntry.newId = abbreviatedObjectId;
                    }
                }
            } else {
                if (object.isEmpty()) {
                    throw new MissingObjectException(abbreviatedObjectId, 3);
                }
                throw new AmbiguousObjectException(abbreviatedObjectId, (Collection)object);
            }
        }
        object = LfsFactory.getInstance().applySmudgeFilter(this.repository, this.source.open(diffEntry$Side, diffEntry), diffEntry.getDiffAttribute());
        return RawText.load((ObjectLoader)object, this.binaryFileThreshold);
    }

    protected void formatGitDiffFirstHeaderLine(ByteArrayOutputStream byteArrayOutputStream, DiffEntry$ChangeType diffEntry$ChangeType, String string, String string2) {
        byteArrayOutputStream.write(Constants.encodeASCII("diff --git "));
        byteArrayOutputStream.write(Constants.encode(this.quotePath(this.oldPrefix + (diffEntry$ChangeType == DiffEntry$ChangeType.ADD ? string2 : string))));
        byteArrayOutputStream.write(32);
        byteArrayOutputStream.write(Constants.encode(this.quotePath(this.newPrefix + (diffEntry$ChangeType == DiffEntry$ChangeType.DELETE ? string : string2))));
        byteArrayOutputStream.write(10);
    }

    private void formatHeader(ByteArrayOutputStream byteArrayOutputStream, DiffEntry diffEntry) {
        DiffEntry$ChangeType diffEntry$ChangeType = diffEntry.getChangeType();
        String string = diffEntry.getOldPath();
        String string2 = diffEntry.getNewPath();
        FileMode fileMode = diffEntry.getOldMode();
        FileMode fileMode2 = diffEntry.getNewMode();
        this.formatGitDiffFirstHeaderLine(byteArrayOutputStream, diffEntry$ChangeType, string, string2);
        if (!(diffEntry$ChangeType != DiffEntry$ChangeType.MODIFY && diffEntry$ChangeType != DiffEntry$ChangeType.COPY && diffEntry$ChangeType != DiffEntry$ChangeType.RENAME || fileMode.equals(fileMode2))) {
            byteArrayOutputStream.write(Constants.encodeASCII("old mode "));
            fileMode.copyTo(byteArrayOutputStream);
            byteArrayOutputStream.write(10);
            byteArrayOutputStream.write(Constants.encodeASCII("new mode "));
            fileMode2.copyTo(byteArrayOutputStream);
            byteArrayOutputStream.write(10);
        }
        switch (diffEntry$ChangeType) {
            case ADD: {
                byteArrayOutputStream.write(Constants.encodeASCII("new file mode "));
                fileMode2.copyTo(byteArrayOutputStream);
                byteArrayOutputStream.write(10);
                break;
            }
            case DELETE: {
                byteArrayOutputStream.write(Constants.encodeASCII("deleted file mode "));
                fileMode.copyTo(byteArrayOutputStream);
                byteArrayOutputStream.write(10);
                break;
            }
            case RENAME: {
                byteArrayOutputStream.write(Constants.encodeASCII("similarity index " + diffEntry.getScore() + "%"));
                byteArrayOutputStream.write(10);
                byteArrayOutputStream.write(Constants.encode("rename from " + this.quotePath(string)));
                byteArrayOutputStream.write(10);
                byteArrayOutputStream.write(Constants.encode("rename to " + this.quotePath(string2)));
                byteArrayOutputStream.write(10);
                break;
            }
            case COPY: {
                byteArrayOutputStream.write(Constants.encodeASCII("similarity index " + diffEntry.getScore() + "%"));
                byteArrayOutputStream.write(10);
                byteArrayOutputStream.write(Constants.encode("copy from " + this.quotePath(string)));
                byteArrayOutputStream.write(10);
                byteArrayOutputStream.write(Constants.encode("copy to " + this.quotePath(string2)));
                byteArrayOutputStream.write(10);
                break;
            }
            case MODIFY: {
                if (0 >= diffEntry.getScore()) break;
                byteArrayOutputStream.write(Constants.encodeASCII("dissimilarity index " + (100 - diffEntry.getScore()) + "%"));
                byteArrayOutputStream.write(10);
            }
        }
        if (diffEntry.getOldId() != null && !diffEntry.getOldId().equals(diffEntry.getNewId())) {
            this.formatIndexLine(byteArrayOutputStream, diffEntry);
        }
    }

    protected void formatIndexLine(OutputStream outputStream, DiffEntry diffEntry) {
        outputStream.write(Constants.encodeASCII("index " + this.format(diffEntry.getOldId()) + ".." + this.format(diffEntry.getNewId())));
        if (diffEntry.getOldMode().equals(diffEntry.getNewMode())) {
            outputStream.write(32);
            diffEntry.getNewMode().copyTo(outputStream);
        }
        outputStream.write(10);
    }

    private void formatOldNewPaths(ByteArrayOutputStream byteArrayOutputStream, DiffEntry diffEntry) {
        String string;
        String string2;
        if (diffEntry.oldId.equals(diffEntry.newId)) {
            return;
        }
        switch (diffEntry.getChangeType()) {
            case ADD: {
                string2 = "/dev/null";
                string = this.quotePath(this.newPrefix + diffEntry.getNewPath());
                break;
            }
            case DELETE: {
                string2 = this.quotePath(this.oldPrefix + diffEntry.getOldPath());
                string = "/dev/null";
                break;
            }
            default: {
                string2 = this.quotePath(this.oldPrefix + diffEntry.getOldPath());
                string = this.quotePath(this.newPrefix + diffEntry.getNewPath());
            }
        }
        byteArrayOutputStream.write(Constants.encode("--- " + string2 + "\n"));
        byteArrayOutputStream.write(Constants.encode("+++ " + string + "\n"));
    }

    private int findCombinedEnd(List list, int n2) {
        int n3;
        for (n3 = n2 + 1; n3 < list.size() && (this.combineA(list, n3) || this.combineB(list, n3)); ++n3) {
        }
        return n3 - 1;
    }

    private boolean combineA(List list, int n2) {
        return ((Edit)list.get(n2)).getBeginA() - ((Edit)list.get(n2 - 1)).getEndA() <= 2 * this.context;
    }

    private boolean combineB(List list, int n2) {
        return ((Edit)list.get(n2)).getBeginB() - ((Edit)list.get(n2 - 1)).getEndB() <= 2 * this.context;
    }

    private static boolean end(Edit edit, int n2, int n3) {
        return edit.getEndA() <= n2 && edit.getEndB() <= n3;
    }
}

