/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jgit.attributes.Attribute;
import org.eclipse.jgit.diff.DiffEntry$ChangeType;
import org.eclipse.jgit.diff.DiffEntry$Side;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilterMarker;

public class DiffEntry {
    static final AbbreviatedObjectId A_ZERO = AbbreviatedObjectId.fromObjectId(ObjectId.zeroId());
    public static final String DEV_NULL = "/dev/null";
    protected String oldPath;
    protected String newPath;
    protected Attribute diffAttribute;
    protected FileMode oldMode;
    protected FileMode newMode;
    protected DiffEntry$ChangeType changeType;
    protected int score;
    protected AbbreviatedObjectId oldId;
    protected AbbreviatedObjectId newId;
    private int treeFilterMarks = 0;

    protected DiffEntry() {
    }

    public static List scan(TreeWalk treeWalk) {
        return DiffEntry.scan(treeWalk, false);
    }

    public static List scan(TreeWalk treeWalk, boolean bl2) {
        return DiffEntry.scan(treeWalk, bl2, null);
    }

    public static List scan(TreeWalk treeWalk, boolean bl2, TreeFilter[] treeFilterArray) {
        if (treeWalk.getTreeCount() != 2) {
            throw new IllegalArgumentException(JGitText.get().treeWalkMustHaveExactlyTwoTrees);
        }
        if (bl2 && treeWalk.isRecursive()) {
            throw new IllegalArgumentException(JGitText.get().cannotBeRecursiveWhenTreesAreIncluded);
        }
        TreeFilterMarker treeFilterMarker = treeFilterArray != null && treeFilterArray.length > 0 ? new TreeFilterMarker(treeFilterArray) : null;
        ArrayList<DiffEntry> arrayList = new ArrayList<DiffEntry>();
        MutableObjectId mutableObjectId = new MutableObjectId();
        while (treeWalk.next()) {
            DiffEntry diffEntry = new DiffEntry();
            treeWalk.getObjectId(mutableObjectId, 0);
            diffEntry.oldId = AbbreviatedObjectId.fromObjectId(mutableObjectId);
            treeWalk.getObjectId(mutableObjectId, 1);
            diffEntry.newId = AbbreviatedObjectId.fromObjectId(mutableObjectId);
            diffEntry.oldMode = treeWalk.getFileMode(0);
            diffEntry.newMode = treeWalk.getFileMode(1);
            diffEntry.newPath = diffEntry.oldPath = treeWalk.getPathString();
            if (treeWalk.getAttributesNodeProvider() != null) {
                diffEntry.diffAttribute = treeWalk.getAttributes().get("diff");
            }
            if (treeFilterMarker != null) {
                diffEntry.treeFilterMarks = treeFilterMarker.getMarks(treeWalk);
            }
            if (diffEntry.oldMode == FileMode.MISSING) {
                diffEntry.oldPath = DEV_NULL;
                diffEntry.changeType = DiffEntry$ChangeType.ADD;
                arrayList.add(diffEntry);
            } else if (diffEntry.newMode == FileMode.MISSING) {
                diffEntry.newPath = DEV_NULL;
                diffEntry.changeType = DiffEntry$ChangeType.DELETE;
                arrayList.add(diffEntry);
            } else if (!diffEntry.oldId.equals(diffEntry.newId)) {
                diffEntry.changeType = DiffEntry$ChangeType.MODIFY;
                if (RenameDetector.sameType(diffEntry.oldMode, diffEntry.newMode)) {
                    arrayList.add(diffEntry);
                } else {
                    arrayList.addAll(DiffEntry.breakModify(diffEntry));
                }
            } else if (diffEntry.oldMode != diffEntry.newMode) {
                diffEntry.changeType = DiffEntry$ChangeType.MODIFY;
                arrayList.add(diffEntry);
            }
            if (!bl2 || !treeWalk.isSubtree()) continue;
            treeWalk.enterSubtree();
        }
        return arrayList;
    }

    public static DiffEntry add(String string, AnyObjectId anyObjectId) {
        DiffEntry diffEntry = new DiffEntry();
        diffEntry.oldId = A_ZERO;
        diffEntry.oldMode = FileMode.MISSING;
        diffEntry.oldPath = DEV_NULL;
        diffEntry.newId = AbbreviatedObjectId.fromObjectId(anyObjectId);
        diffEntry.newMode = FileMode.REGULAR_FILE;
        diffEntry.newPath = string;
        diffEntry.changeType = DiffEntry$ChangeType.ADD;
        return diffEntry;
    }

    public static DiffEntry delete(String string, AnyObjectId anyObjectId) {
        DiffEntry diffEntry = new DiffEntry();
        diffEntry.oldId = AbbreviatedObjectId.fromObjectId(anyObjectId);
        diffEntry.oldMode = FileMode.REGULAR_FILE;
        diffEntry.oldPath = string;
        diffEntry.newId = A_ZERO;
        diffEntry.newMode = FileMode.MISSING;
        diffEntry.newPath = DEV_NULL;
        diffEntry.changeType = DiffEntry$ChangeType.DELETE;
        return diffEntry;
    }

    static DiffEntry modify(String string) {
        DiffEntry diffEntry = new DiffEntry();
        diffEntry.oldMode = FileMode.REGULAR_FILE;
        diffEntry.oldPath = string;
        diffEntry.newMode = FileMode.REGULAR_FILE;
        diffEntry.newPath = string;
        diffEntry.changeType = DiffEntry$ChangeType.MODIFY;
        return diffEntry;
    }

    static List breakModify(DiffEntry diffEntry) {
        DiffEntry diffEntry2 = new DiffEntry();
        diffEntry2.oldId = diffEntry.getOldId();
        diffEntry2.oldMode = diffEntry.getOldMode();
        diffEntry2.oldPath = diffEntry.getOldPath();
        diffEntry2.newId = A_ZERO;
        diffEntry2.newMode = FileMode.MISSING;
        diffEntry2.newPath = DEV_NULL;
        diffEntry2.changeType = DiffEntry$ChangeType.DELETE;
        diffEntry2.diffAttribute = diffEntry.diffAttribute;
        DiffEntry diffEntry3 = new DiffEntry();
        diffEntry3.oldId = A_ZERO;
        diffEntry3.oldMode = FileMode.MISSING;
        diffEntry3.oldPath = DEV_NULL;
        diffEntry3.newId = diffEntry.getNewId();
        diffEntry3.newMode = diffEntry.getNewMode();
        diffEntry3.newPath = diffEntry.getNewPath();
        diffEntry3.changeType = DiffEntry$ChangeType.ADD;
        diffEntry3.diffAttribute = diffEntry.diffAttribute;
        return Arrays.asList(diffEntry2, diffEntry3);
    }

    static DiffEntry pair(DiffEntry$ChangeType diffEntry$ChangeType, DiffEntry diffEntry, DiffEntry diffEntry2, int n2) {
        DiffEntry diffEntry3 = new DiffEntry();
        diffEntry3.oldId = diffEntry.oldId;
        diffEntry3.oldMode = diffEntry.oldMode;
        diffEntry3.oldPath = diffEntry.oldPath;
        diffEntry3.newId = diffEntry2.newId;
        diffEntry3.newMode = diffEntry2.newMode;
        diffEntry3.newPath = diffEntry2.newPath;
        diffEntry3.diffAttribute = diffEntry2.diffAttribute;
        diffEntry3.changeType = diffEntry$ChangeType;
        diffEntry3.score = n2;
        diffEntry3.treeFilterMarks = diffEntry.treeFilterMarks | diffEntry2.treeFilterMarks;
        return diffEntry3;
    }

    public String getOldPath() {
        return this.oldPath;
    }

    public String getNewPath() {
        return this.newPath;
    }

    public String getPath(DiffEntry$Side diffEntry$Side) {
        return diffEntry$Side == DiffEntry$Side.OLD ? this.getOldPath() : this.getNewPath();
    }

    public Attribute getDiffAttribute() {
        return this.diffAttribute;
    }

    public FileMode getOldMode() {
        return this.oldMode;
    }

    public FileMode getNewMode() {
        return this.newMode;
    }

    public FileMode getMode(DiffEntry$Side diffEntry$Side) {
        return diffEntry$Side == DiffEntry$Side.OLD ? this.getOldMode() : this.getNewMode();
    }

    public DiffEntry$ChangeType getChangeType() {
        return this.changeType;
    }

    public int getScore() {
        return this.score;
    }

    public AbbreviatedObjectId getOldId() {
        return this.oldId;
    }

    public AbbreviatedObjectId getNewId() {
        return this.newId;
    }

    public boolean isMarked(int n2) {
        return ((long)this.treeFilterMarks & 1L << n2) != 0L;
    }

    public int getTreeFilterMarks() {
        return this.treeFilterMarks;
    }

    public AbbreviatedObjectId getId(DiffEntry$Side diffEntry$Side) {
        return diffEntry$Side == DiffEntry$Side.OLD ? this.getOldId() : this.getNewId();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DiffEntry[");
        stringBuilder.append((Object)this.changeType);
        stringBuilder.append(" ");
        switch (this.changeType) {
            case ADD: {
                stringBuilder.append(this.newPath);
                break;
            }
            case COPY: {
                stringBuilder.append(this.oldPath + "->" + this.newPath);
                break;
            }
            case DELETE: {
                stringBuilder.append(this.oldPath);
                break;
            }
            case MODIFY: {
                stringBuilder.append(this.oldPath);
                break;
            }
            case RENAME: {
                stringBuilder.append(this.oldPath + "->" + this.newPath);
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

