/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import java.text.MessageFormat;
import org.eclipse.jgit.diff.DiffConfig$RenameDetectionType;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Config$SectionParser;
import org.eclipse.jgit.lib.ConfigIllegalValueException;
import org.eclipse.jgit.util.StringUtils;

public class DiffConfig {
    public static final Config$SectionParser KEY = DiffConfig::new;
    private final boolean noPrefix;
    private final DiffConfig$RenameDetectionType renameDetectionType;
    private final int renameLimit;

    private DiffConfig(Config config) {
        this.noPrefix = config.getBoolean("diff", "noprefix", false);
        this.renameDetectionType = DiffConfig.parseRenameDetectionType(config.getString("diff", null, "renames"));
        this.renameLimit = config.getInt("diff", "renamelimit", 400);
    }

    public boolean isNoPrefix() {
        return this.noPrefix;
    }

    public boolean isRenameDetectionEnabled() {
        return this.renameDetectionType != DiffConfig$RenameDetectionType.FALSE;
    }

    public DiffConfig$RenameDetectionType getRenameDetectionType() {
        return this.renameDetectionType;
    }

    public int getRenameLimit() {
        return this.renameLimit;
    }

    private static DiffConfig$RenameDetectionType parseRenameDetectionType(String string) {
        if (string == null) {
            return DiffConfig$RenameDetectionType.FALSE;
        }
        if (StringUtils.equalsIgnoreCase("copy", string) || StringUtils.equalsIgnoreCase("copies", string)) {
            return DiffConfig$RenameDetectionType.COPY;
        }
        Boolean bl2 = StringUtils.toBooleanOrNull(string);
        if (bl2 == null) {
            throw new ConfigIllegalValueException(MessageFormat.format(JGitText.get().enumValueNotSupported2, "diff", "renames", string));
        }
        if (bl2.booleanValue()) {
            return DiffConfig$RenameDetectionType.TRUE;
        }
        return DiffConfig$RenameDetectionType.FALSE;
    }
}

