/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import org.eclipse.jgit.diff.DiffAlgorithm$SupportedAlgorithm;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.Edit$Type;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.HistogramDiff;
import org.eclipse.jgit.diff.MyersDiff;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.SequenceComparator;
import org.eclipse.jgit.diff.Subsequence;
import org.eclipse.jgit.diff.SubsequenceComparator;

public abstract class DiffAlgorithm {
    public static DiffAlgorithm getAlgorithm(DiffAlgorithm$SupportedAlgorithm diffAlgorithm$SupportedAlgorithm) {
        switch (diffAlgorithm$SupportedAlgorithm) {
            case MYERS: {
                return MyersDiff.INSTANCE;
            }
            case HISTOGRAM: {
                return new HistogramDiff();
            }
        }
        throw new IllegalArgumentException();
    }

    public EditList diff(SequenceComparator sequenceComparator, Sequence sequence, Sequence sequence2) {
        Edit edit = sequenceComparator.reduceCommonStartEnd(sequence, sequence2, DiffAlgorithm.coverEdit(sequence, sequence2));
        switch (edit.getType()) {
            case INSERT: 
            case DELETE: {
                return EditList.singleton(edit);
            }
            case REPLACE: {
                if (edit.getLengthA() == 1 && edit.getLengthB() == 1) {
                    return EditList.singleton(edit);
                }
                SubsequenceComparator subsequenceComparator = new SubsequenceComparator(sequenceComparator);
                Subsequence subsequence = Subsequence.a(sequence, edit);
                Subsequence subsequence2 = Subsequence.b(sequence2, edit);
                EditList editList = Subsequence.toBase(this.diffNonCommon(subsequenceComparator, subsequence, subsequence2), subsequence, subsequence2);
                return DiffAlgorithm.normalize(sequenceComparator, editList, sequence, sequence2);
            }
            case EMPTY: {
                return new EditList(0);
            }
        }
        throw new IllegalStateException();
    }

    private static Edit coverEdit(Sequence sequence, Sequence sequence2) {
        return new Edit(0, sequence.size(), 0, sequence2.size());
    }

    private static EditList normalize(SequenceComparator sequenceComparator, EditList editList, Sequence sequence, Sequence sequence2) {
        Edit edit = null;
        for (int i2 = editList.size() - 1; i2 >= 0; --i2) {
            int n2;
            Edit edit2 = (Edit)editList.get(i2);
            Edit$Type edit$Type = edit2.getType();
            int n3 = edit == null ? sequence.size() : edit.beginA;
            int n4 = n2 = edit == null ? sequence2.size() : edit.beginB;
            if (edit$Type == Edit$Type.INSERT) {
                while (edit2.endA < n3 && edit2.endB < n2 && sequenceComparator.equals(sequence2, edit2.beginB, sequence2, edit2.endB)) {
                    edit2.shift(1);
                }
            } else if (edit$Type == Edit$Type.DELETE) {
                while (edit2.endA < n3 && edit2.endB < n2 && sequenceComparator.equals(sequence, edit2.beginA, sequence, edit2.endA)) {
                    edit2.shift(1);
                }
            }
            edit = edit2;
        }
        return editList;
    }

    public abstract EditList diffNonCommon(SequenceComparator var1, Sequence var2, Sequence var3);
}

