/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.blame;

class Region {
    Region next;
    int resultStart;
    int sourceStart;
    int length;

    Region(int n2, int n3, int n4) {
        this.resultStart = n2;
        this.sourceStart = n3;
        this.length = n4;
    }

    Region copy(int n2) {
        return new Region(this.resultStart, n2, this.length);
    }

    Region splitFirst(int n2, int n3) {
        return new Region(this.resultStart, n2, n3);
    }

    void slideAndShrink(int n2) {
        this.resultStart += n2;
        this.sourceStart += n2;
        this.length -= n2;
    }

    Region deepCopy() {
        Region region;
        Region region2 = region = new Region(this.resultStart, this.sourceStart, this.length);
        Region region3 = this.next;
        while (region3 != null) {
            Region region4;
            region2.next = region4 = new Region(region3.resultStart, region3.sourceStart, region3.length);
            region2 = region4;
            region3 = region3.next;
        }
        return region;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Region region = this;
        do {
            if (region != this) {
                stringBuilder.append(',');
            }
            stringBuilder.append(region.resultStart);
            stringBuilder.append('-');
            stringBuilder.append(region.resultStart + region.length);
        } while ((region = region.next) != null);
        return stringBuilder.toString();
    }
}

