/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.blame;

import org.eclipse.jgit.blame.Region;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.util.LfsFactory;

class Candidate {
    Candidate queueNext;
    RevCommit sourceCommit;
    PathFilter sourcePath;
    ObjectId sourceBlob;
    RawText sourceText;
    Region regionList;
    int renameScore;
    private Repository sourceRepository;

    Candidate(Repository repository, RevCommit revCommit, PathFilter pathFilter) {
        this.sourceRepository = repository;
        this.sourceCommit = revCommit;
        this.sourcePath = pathFilter;
    }

    void beginResult(RevWalk revWalk) {
        revWalk.parseBody(this.sourceCommit);
    }

    int getParentCount() {
        return this.sourceCommit.getParentCount();
    }

    RevCommit getParent(int n2) {
        return this.sourceCommit.getParent(n2);
    }

    Candidate getNextCandidate(int n2) {
        return null;
    }

    boolean has(RevFlag revFlag) {
        return this.sourceCommit.has(revFlag);
    }

    void add(RevFlag revFlag) {
        this.sourceCommit.add(revFlag);
    }

    void remove(RevFlag revFlag) {
        this.sourceCommit.remove(revFlag);
    }

    int getTime() {
        return this.sourceCommit.getCommitTime();
    }

    PersonIdent getAuthor() {
        return this.sourceCommit.getAuthorIdent();
    }

    Candidate create(Repository repository, RevCommit revCommit, PathFilter pathFilter) {
        return new Candidate(repository, revCommit, pathFilter);
    }

    Candidate copy(RevCommit revCommit) {
        Candidate candidate = this.create(this.sourceRepository, revCommit, this.sourcePath);
        candidate.sourceBlob = this.sourceBlob;
        candidate.sourceText = this.sourceText;
        candidate.regionList = this.regionList;
        candidate.renameScore = this.renameScore;
        return candidate;
    }

    void loadText(ObjectReader objectReader) {
        ObjectLoader objectLoader = LfsFactory.getInstance().applySmudgeFilter(this.sourceRepository, objectReader.open(this.sourceBlob, 3), LfsFactory.getAttributesForPath(this.sourceRepository, this.sourcePath.getPath(), this.sourceCommit).get("diff"));
        this.sourceText = new RawText(objectLoader.getCachedBytes(Integer.MAX_VALUE));
    }

    void takeBlame(EditList editList, Candidate candidate) {
        Candidate.blame(editList, this, candidate);
    }

    private static void blame(EditList editList, Candidate candidate, Candidate candidate2) {
        int n2;
        Region region = candidate2.clearRegionList();
        Region region2 = null;
        Region region3 = null;
        int n3 = 0;
        while (n3 < editList.size()) {
            if (region == null) {
                return;
            }
            Edit edit = (Edit)editList.get(n3);
            if (edit.getEndB() <= region.sourceStart) {
                ++n3;
                continue;
            }
            if (region.sourceStart < edit.getBeginB()) {
                n2 = edit.getBeginB() - region.sourceStart;
                if (region.length <= n2) {
                    Region region4 = region.next;
                    region.sourceStart = edit.getBeginA() - n2;
                    region2 = Candidate.add(region2, candidate, region);
                    region = region4;
                    continue;
                }
                region2 = Candidate.add(region2, candidate, region.splitFirst(edit.getBeginA() - n2, n2));
                region.slideAndShrink(n2);
            }
            if (edit.getLengthB() == 0) {
                ++n3;
                continue;
            }
            n2 = region.sourceStart + region.length;
            if (n2 <= edit.getEndB()) {
                Region region5 = region.next;
                region3 = Candidate.add(region3, candidate2, region);
                region = region5;
                if (n2 != edit.getEndB()) continue;
                ++n3;
                continue;
            }
            int n4 = edit.getEndB() - region.sourceStart;
            region3 = Candidate.add(region3, candidate2, region.splitFirst(region.sourceStart, n4));
            region.slideAndShrink(n4);
            ++n3;
        }
        if (region == null) {
            return;
        }
        Edit edit = (Edit)editList.get(editList.size() - 1);
        int n5 = edit.getEndB();
        n2 = n5 - edit.getEndA();
        if (region2 == null) {
            candidate.regionList = region;
        } else {
            region2.next = region;
        }
        do {
            if (n5 > region.sourceStart) continue;
            region.sourceStart -= n2;
        } while ((region = region.next) != null);
    }

    private static Region add(Region region, Candidate candidate, Region region2) {
        if (region == null) {
            candidate.regionList = region2;
            region2.next = null;
            return region2;
        }
        if (region.resultStart + region.length == region2.resultStart && region.sourceStart + region.length == region2.sourceStart) {
            region.length += region2.length;
            return region;
        }
        region.next = region2;
        region2.next = null;
        return region2;
    }

    private Region clearRegionList() {
        Region region = this.regionList;
        this.regionList = null;
        return region;
    }

    boolean canMergeRegions(Candidate candidate) {
        return this.sourceCommit == candidate.sourceCommit && this.sourcePath.getPath().equals(candidate.sourcePath.getPath());
    }

    void mergeRegions(Candidate candidate) {
        Region region;
        Region region2 = this.clearRegionList();
        Region region3 = candidate.clearRegionList();
        Region region4 = null;
        while (region2 != null && region3 != null) {
            if (region2.resultStart < region3.resultStart) {
                region = region2.next;
                region4 = Candidate.add(region4, this, region2);
                region2 = region;
                continue;
            }
            region = region3.next;
            region4 = Candidate.add(region4, this, region3);
            region3 = region;
        }
        if (region2 != null) {
            region = region2.next;
            region4 = Candidate.add(region4, this, region2);
            region4.next = region;
        } else {
            region = region3.next;
            region4 = Candidate.add(region4, this, region3);
            region4.next = region;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Candidate[");
        stringBuilder.append(this.sourcePath.getPath());
        if (this.sourceCommit != null) {
            stringBuilder.append(" @ ").append(this.sourceCommit.abbreviate(6).name());
        }
        if (this.regionList != null) {
            stringBuilder.append(" regions:").append(this.regionList);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

