/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.blame;

import org.eclipse.jgit.blame.BlameGenerator;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;

public class BlameResult {
    private final String resultPath;
    private final RevCommit[] sourceCommits;
    private final PersonIdent[] sourceAuthors;
    private final PersonIdent[] sourceCommitters;
    private final String[] sourcePaths;
    private final int[] sourceLines;
    private RawText resultContents;
    private BlameGenerator generator;
    private int lastLength;

    public static BlameResult create(BlameGenerator blameGenerator) {
        String string = blameGenerator.getResultPath();
        RawText rawText = blameGenerator.getResultContents();
        if (rawText == null) {
            blameGenerator.close();
            return null;
        }
        return new BlameResult(blameGenerator, string, rawText);
    }

    BlameResult(BlameGenerator blameGenerator, String string, RawText rawText) {
        this.generator = blameGenerator;
        this.resultPath = string;
        this.resultContents = rawText;
        int n2 = rawText.size();
        this.sourceCommits = new RevCommit[n2];
        this.sourceAuthors = new PersonIdent[n2];
        this.sourceCommitters = new PersonIdent[n2];
        this.sourceLines = new int[n2];
        this.sourcePaths = new String[n2];
    }

    public String getResultPath() {
        return this.resultPath;
    }

    public RawText getResultContents() {
        return this.resultContents;
    }

    public void discardResultContents() {
        this.resultContents = null;
    }

    public boolean hasSourceData(int n2) {
        return this.sourceLines[n2] != 0;
    }

    public boolean hasSourceData(int n2, int n3) {
        while (n2 < n3) {
            if (this.sourceLines[n2] == 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public RevCommit getSourceCommit(int n2) {
        return this.sourceCommits[n2];
    }

    public PersonIdent getSourceAuthor(int n2) {
        return this.sourceAuthors[n2];
    }

    public PersonIdent getSourceCommitter(int n2) {
        return this.sourceCommitters[n2];
    }

    public String getSourcePath(int n2) {
        return this.sourcePaths[n2];
    }

    public int getSourceLine(int n2) {
        return this.sourceLines[n2] - 1;
    }

    public void computeAll() {
        BlameGenerator blameGenerator = this.generator;
        if (blameGenerator == null) {
            return;
        }
        try {
            while (blameGenerator.next()) {
                this.loadFrom(blameGenerator);
            }
        }
        finally {
            blameGenerator.close();
            this.generator = null;
        }
    }

    public int computeNext() {
        BlameGenerator blameGenerator = this.generator;
        if (blameGenerator == null) {
            return -1;
        }
        if (blameGenerator.next()) {
            this.loadFrom(blameGenerator);
            this.lastLength = blameGenerator.getRegionLength();
            return blameGenerator.getResultStart();
        }
        blameGenerator.close();
        this.generator = null;
        return -1;
    }

    public int lastLength() {
        return this.lastLength;
    }

    public void computeRange(int n2, int n3) {
        BlameGenerator blameGenerator = this.generator;
        if (blameGenerator == null) {
            return;
        }
        if (n2 == 0 && n3 == this.resultContents.size()) {
            this.computeAll();
            return;
        }
        while (n2 < n3) {
            if (this.hasSourceData(n2, n3)) {
                return;
            }
            if (!blameGenerator.next()) {
                blameGenerator.close();
                this.generator = null;
                return;
            }
            this.loadFrom(blameGenerator);
            int n4 = blameGenerator.getResultStart();
            int n5 = blameGenerator.getResultEnd();
            if (n4 <= n2 && n2 < n5) {
                n2 = n5;
            }
            if (n4 > n3 || n3 >= n5) continue;
            n3 = n4;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("BlameResult: ");
        stringBuilder.append(this.getResultPath());
        return stringBuilder.toString();
    }

    private void loadFrom(BlameGenerator blameGenerator) {
        RevCommit revCommit = blameGenerator.getSourceCommit();
        PersonIdent personIdent = blameGenerator.getSourceAuthor();
        PersonIdent personIdent2 = blameGenerator.getSourceCommitter();
        String string = blameGenerator.getSourcePath();
        int n2 = blameGenerator.getSourceStart();
        int n3 = blameGenerator.getResultEnd();
        for (int i2 = blameGenerator.getResultStart(); i2 < n3; ++i2) {
            if (this.sourceLines[i2] != 0) continue;
            this.sourceCommits[i2] = revCommit;
            this.sourceAuthors[i2] = personIdent;
            this.sourceCommitters[i2] = personIdent2;
            this.sourcePaths[i2] = string;
            this.sourceLines[i2] = ++n2;
        }
    }
}

