/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.blame;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.blame.BlameResult;
import org.eclipse.jgit.blame.Candidate;
import org.eclipse.jgit.blame.Candidate$BlobCandidate;
import org.eclipse.jgit.blame.Candidate$HeadCandidate;
import org.eclipse.jgit.blame.Candidate$ReverseCandidate;
import org.eclipse.jgit.blame.Region;
import org.eclipse.jgit.blame.ReverseWalk;
import org.eclipse.jgit.blame.ReverseWalk$ReverseCommit;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffEntry$ChangeType;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.HistogramDiff;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.TreeWalk$OperationType;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.IO;

public class BlameGenerator
implements AutoCloseable {
    private final Repository repository;
    private final PathFilter resultPath;
    private final MutableObjectId idBuf;
    private RevWalk revPool;
    private RevFlag SEEN;
    private ObjectReader reader;
    private TreeWalk treeWalk;
    private DiffAlgorithm diffAlgorithm = new HistogramDiff();
    private RawTextComparator textComparator = RawTextComparator.DEFAULT;
    private RenameDetector renameDetector;
    private Candidate queue;
    private int remaining;
    private Candidate outCandidate;
    private Region outRegion;

    public BlameGenerator(Repository repository, String string) {
        this.repository = repository;
        this.resultPath = PathFilter.create(string);
        this.idBuf = new MutableObjectId();
        this.setFollowFileRenames(true);
        this.initRevPool(false);
        this.remaining = -1;
    }

    private void initRevPool(boolean bl2) {
        if (this.queue != null) {
            throw new IllegalStateException();
        }
        if (this.revPool != null) {
            this.revPool.close();
        }
        this.revPool = bl2 ? new ReverseWalk(this.getRepository()) : new RevWalk(this.getRepository());
        this.SEEN = this.revPool.newFlag("SEEN");
        this.reader = this.revPool.getObjectReader();
        this.treeWalk = new TreeWalk(this.reader);
        this.treeWalk.setRecursive(true);
    }

    public Repository getRepository() {
        return this.repository;
    }

    public String getResultPath() {
        return this.resultPath.getPath();
    }

    public BlameGenerator setDiffAlgorithm(DiffAlgorithm diffAlgorithm) {
        this.diffAlgorithm = diffAlgorithm;
        return this;
    }

    public BlameGenerator setTextComparator(RawTextComparator rawTextComparator) {
        this.textComparator = rawTextComparator;
        return this;
    }

    public BlameGenerator setFollowFileRenames(boolean bl2) {
        this.renameDetector = bl2 ? new RenameDetector(this.getRepository()) : null;
        return this;
    }

    @Nullable
    public RenameDetector getRenameDetector() {
        return this.renameDetector;
    }

    public BlameGenerator push(String string, byte[] byArray) {
        return this.push(string, new RawText(byArray));
    }

    public BlameGenerator push(String string, RawText rawText) {
        if (string == null) {
            string = JGitText.get().blameNotCommittedYet;
        }
        Candidate$BlobCandidate candidate$BlobCandidate = new Candidate$BlobCandidate(this.getRepository(), string, this.resultPath);
        candidate$BlobCandidate.sourceText = rawText;
        candidate$BlobCandidate.regionList = new Region(0, 0, rawText.size());
        this.remaining = rawText.size();
        this.push(candidate$BlobCandidate);
        return this;
    }

    public BlameGenerator prepareHead() {
        Repository repository = this.getRepository();
        ObjectId objectId = repository.resolve("HEAD");
        if (objectId == null) {
            throw new NoHeadException(MessageFormat.format(JGitText.get().noSuchRefKnown, "HEAD"));
        }
        if (repository.isBare()) {
            return this.push(null, objectId);
        }
        DirCache dirCache = repository.readDirCache();
        try (TreeWalk treeWalk = new TreeWalk(repository);){
            RawText rawText;
            treeWalk.setOperationType(TreeWalk$OperationType.CHECKIN_OP);
            FileTreeIterator fileTreeIterator = new FileTreeIterator(repository);
            int n2 = treeWalk.addTree(fileTreeIterator);
            int n3 = treeWalk.addTree(new DirCacheIterator(dirCache));
            fileTreeIterator.setDirCacheIterator(treeWalk, n3);
            treeWalk.setFilter(this.resultPath);
            treeWalk.setRecursive(true);
            if (!treeWalk.next()) {
                BlameGenerator blameGenerator = this;
                return blameGenerator;
            }
            DirCacheIterator dirCacheIterator = (DirCacheIterator)treeWalk.getTree(n3, DirCacheIterator.class);
            if (dirCacheIterator == null) {
                BlameGenerator blameGenerator = this;
                return blameGenerator;
            }
            fileTreeIterator = (FileTreeIterator)treeWalk.getTree(n2, FileTreeIterator.class);
            if (fileTreeIterator == null || !BlameGenerator.isFile(fileTreeIterator.getEntryRawMode())) {
                BlameGenerator blameGenerator = this;
                return blameGenerator;
            }
            long l2 = fileTreeIterator.getEntryContentLength();
            Object object = fileTreeIterator.openEntryStream();
            Object object2 = null;
            try {
                rawText = new RawText(BlameGenerator.getBytes(fileTreeIterator.getEntryFile().getPath(), (InputStream)object, l2));
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (object != null) {
                    if (object2 != null) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)object).close();
                    }
                }
            }
            object = dirCacheIterator.getDirCacheEntry();
            if (((DirCacheEntry)object).getStage() == 0) {
                this.push(null, objectId);
                this.push(null, ((DirCacheEntry)object).getObjectId());
                this.push(null, rawText);
            } else {
                object2 = new Candidate$HeadCandidate(this.getRepository(), this.resultPath, this.getHeads(repository, objectId));
                ((Candidate$HeadCandidate)object2).sourceText = rawText;
                ((Candidate$HeadCandidate)object2).regionList = new Region(0, 0, rawText.size());
                this.remaining = rawText.size();
                this.push((Candidate)object2);
            }
        }
        return this;
    }

    private List getHeads(Repository repository, ObjectId objectId) {
        List list = repository.readMergeHeads();
        if (list == null || list.isEmpty()) {
            return Collections.singletonList(this.revPool.parseCommit(objectId));
        }
        ArrayList<RevCommit> arrayList = new ArrayList<RevCommit>(list.size() + 1);
        arrayList.add(this.revPool.parseCommit(objectId));
        for (ObjectId objectId2 : list) {
            arrayList.add(this.revPool.parseCommit(objectId2));
        }
        return arrayList;
    }

    private static byte[] getBytes(String string, InputStream inputStream, long l2) {
        if (l2 > Integer.MAX_VALUE) {
            throw new IOException(MessageFormat.format(JGitText.get().fileIsTooLarge, string));
        }
        int n2 = (int)l2;
        byte[] byArray = new byte[n2];
        int n3 = IO.readFully(inputStream, byArray, 0);
        if (n3 == n2) {
            return byArray;
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        return byArray2;
    }

    public BlameGenerator push(String string, AnyObjectId anyObjectId) {
        ObjectLoader objectLoader = this.reader.open(anyObjectId);
        if (objectLoader.getType() == 3) {
            if (string == null) {
                string = JGitText.get().blameNotCommittedYet;
            }
            Candidate$BlobCandidate candidate$BlobCandidate = new Candidate$BlobCandidate(this.getRepository(), string, this.resultPath);
            candidate$BlobCandidate.sourceBlob = anyObjectId.toObjectId();
            candidate$BlobCandidate.sourceText = new RawText(objectLoader.getCachedBytes(Integer.MAX_VALUE));
            candidate$BlobCandidate.regionList = new Region(0, 0, candidate$BlobCandidate.sourceText.size());
            this.remaining = candidate$BlobCandidate.sourceText.size();
            this.push(candidate$BlobCandidate);
            return this;
        }
        RevCommit revCommit = this.revPool.parseCommit(anyObjectId);
        if (!this.find(revCommit, this.resultPath)) {
            return this;
        }
        Candidate candidate = new Candidate(this.getRepository(), revCommit, this.resultPath);
        candidate.sourceBlob = this.idBuf.toObjectId();
        candidate.loadText(this.reader);
        candidate.regionList = new Region(0, 0, candidate.sourceText.size());
        this.remaining = candidate.sourceText.size();
        this.push(candidate);
        return this;
    }

    public BlameGenerator reverse(AnyObjectId anyObjectId, AnyObjectId anyObjectId2) {
        return this.reverse(anyObjectId, Collections.singleton(anyObjectId2.toObjectId()));
    }

    public BlameGenerator reverse(AnyObjectId anyObjectId, Collection collection) {
        this.initRevPool(true);
        ReverseWalk$ReverseCommit reverseWalk$ReverseCommit = (ReverseWalk$ReverseCommit)this.revPool.parseCommit(anyObjectId);
        if (!this.find(reverseWalk$ReverseCommit, this.resultPath)) {
            return this;
        }
        this.revPool.markUninteresting(reverseWalk$ReverseCommit);
        for (ObjectId objectId : collection) {
            this.revPool.markStart(this.revPool.parseCommit(objectId));
        }
        while (this.revPool.next() != null) {
        }
        Candidate$ReverseCandidate candidate$ReverseCandidate = new Candidate$ReverseCandidate(this.getRepository(), reverseWalk$ReverseCommit, this.resultPath);
        candidate$ReverseCandidate.sourceBlob = this.idBuf.toObjectId();
        candidate$ReverseCandidate.loadText(this.reader);
        candidate$ReverseCandidate.regionList = new Region(0, 0, candidate$ReverseCandidate.sourceText.size());
        this.remaining = candidate$ReverseCandidate.sourceText.size();
        this.push(candidate$ReverseCandidate);
        return this;
    }

    public RevFlag newFlag(String string) {
        return this.revPool.newFlag(string);
    }

    public BlameResult computeBlameResult() {
        try {
            BlameResult blameResult = BlameResult.create(this);
            if (blameResult != null) {
                blameResult.computeAll();
            }
            BlameResult blameResult2 = blameResult;
            return blameResult2;
        }
        finally {
            this.close();
        }
    }

    public boolean next() {
        Object object;
        if (this.outRegion != null) {
            object = this.outRegion;
            this.remaining -= ((Region)object).length;
            if (((Region)object).next != null) {
                this.outRegion = ((Region)object).next;
                return true;
            }
            if (this.outCandidate.queueNext != null) {
                return this.result(this.outCandidate.queueNext);
            }
            this.outCandidate = null;
            this.outRegion = null;
        }
        if (this.remaining == 0) {
            return this.done();
        }
        while (true) {
            if ((object = this.pop()) == null) {
                return this.done();
            }
            int n2 = ((Candidate)object).getParentCount();
            if (n2 == 1) {
                if (!this.processOne((Candidate)object)) continue;
                return true;
            }
            if (1 < n2) {
                if (!this.processMerge((Candidate)object)) continue;
                return true;
            }
            if (!(object instanceof Candidate$ReverseCandidate)) break;
        }
        return this.result((Candidate)object);
    }

    private boolean done() {
        this.close();
        return false;
    }

    private boolean result(Candidate candidate) {
        candidate.beginResult(this.revPool);
        this.outCandidate = candidate;
        this.outRegion = candidate.regionList;
        return this.outRegion != null;
    }

    private boolean reverseResult(Candidate candidate, Candidate candidate2) {
        Candidate candidate3 = candidate.copy(candidate.sourceCommit);
        candidate3.regionList = candidate2.regionList;
        return this.result(candidate3);
    }

    private Candidate pop() {
        Candidate candidate = this.queue;
        if (candidate != null) {
            this.queue = candidate.queueNext;
            candidate.queueNext = null;
        }
        return candidate;
    }

    private void push(Candidate$BlobCandidate candidate$BlobCandidate) {
        Candidate candidate = this.queue;
        if (candidate != null) {
            candidate.remove(this.SEEN);
            candidate.regionList = null;
            candidate$BlobCandidate.parent = candidate;
        }
        this.queue = candidate$BlobCandidate;
    }

    private void push(Candidate candidate) {
        if (candidate.has(this.SEEN)) {
            Candidate candidate2 = this.queue;
            while (candidate2 != null) {
                if (candidate2.canMergeRegions(candidate)) {
                    candidate2.mergeRegions(candidate);
                    return;
                }
                candidate2 = candidate2.queueNext;
            }
        }
        candidate.add(this.SEEN);
        int n2 = candidate.getTime();
        Candidate candidate3 = this.queue;
        if (candidate3 == null || n2 >= candidate3.getTime()) {
            candidate.queueNext = candidate3;
            this.queue = candidate;
            return;
        }
        Candidate candidate4 = candidate3;
        while (true) {
            if ((candidate3 = candidate4.queueNext) == null || n2 >= candidate3.getTime()) {
                candidate.queueNext = candidate3;
                candidate4.queueNext = candidate;
                return;
            }
            candidate4 = candidate3;
        }
    }

    private boolean processOne(Candidate candidate) {
        RevCommit revCommit = candidate.getParent(0);
        if (revCommit == null) {
            return this.split(candidate.getNextCandidate(0), candidate);
        }
        this.revPool.parseHeaders(revCommit);
        if (this.find(revCommit, candidate.sourcePath)) {
            if (this.idBuf.equals(candidate.sourceBlob)) {
                return this.blameEntireRegionOnParent(candidate, revCommit);
            }
            return this.splitBlameWithParent(candidate, revCommit);
        }
        if (candidate.sourceCommit == null) {
            return this.result(candidate);
        }
        DiffEntry diffEntry = this.findRename(revCommit, candidate.sourceCommit, candidate.sourcePath);
        if (diffEntry == null) {
            return this.result(candidate);
        }
        if (0 == diffEntry.getOldId().prefixCompare(candidate.sourceBlob)) {
            candidate.sourceCommit = revCommit;
            candidate.sourcePath = PathFilter.create(diffEntry.getOldPath());
            this.push(candidate);
            return false;
        }
        Candidate candidate2 = candidate.create(this.getRepository(), revCommit, PathFilter.create(diffEntry.getOldPath()));
        candidate2.sourceBlob = diffEntry.getOldId().toObjectId();
        candidate2.renameScore = diffEntry.getScore();
        candidate2.loadText(this.reader);
        return this.split(candidate2, candidate);
    }

    private boolean blameEntireRegionOnParent(Candidate candidate, RevCommit revCommit) {
        candidate.sourceCommit = revCommit;
        this.push(candidate);
        return false;
    }

    private boolean splitBlameWithParent(Candidate candidate, RevCommit revCommit) {
        Candidate candidate2 = candidate.create(this.getRepository(), revCommit, candidate.sourcePath);
        candidate2.sourceBlob = this.idBuf.toObjectId();
        candidate2.loadText(this.reader);
        return this.split(candidate2, candidate);
    }

    private boolean split(Candidate candidate, Candidate candidate2) {
        EditList editList = this.diffAlgorithm.diff(this.textComparator, candidate.sourceText, candidate2.sourceText);
        if (editList.isEmpty()) {
            candidate.regionList = candidate2.regionList;
            this.push(candidate);
            return false;
        }
        candidate.takeBlame(editList, candidate2);
        if (candidate.regionList != null) {
            this.push(candidate);
        }
        if (candidate2.regionList != null) {
            if (candidate2 instanceof Candidate$ReverseCandidate) {
                return this.reverseResult(candidate, candidate2);
            }
            return this.result(candidate2);
        }
        return false;
    }

    private boolean processMerge(Candidate candidate) {
        Object object;
        Object object2;
        int n2;
        Object object3;
        int n3 = candidate.getParentCount();
        ObjectId[] objectIdArray = null;
        for (int i2 = 0; i2 < n3; ++i2) {
            RevCommit revCommit = candidate.getParent(i2);
            this.revPool.parseHeaders(revCommit);
            if (!this.find(revCommit, candidate.sourcePath)) continue;
            if (!(candidate instanceof Candidate$ReverseCandidate) && this.idBuf.equals(candidate.sourceBlob)) {
                return this.blameEntireRegionOnParent(candidate, revCommit);
            }
            if (objectIdArray == null) {
                objectIdArray = new ObjectId[n3];
            }
            objectIdArray[i2] = this.idBuf.toObjectId();
        }
        DiffEntry[] diffEntryArray = null;
        if (this.renameDetector != null) {
            diffEntryArray = new DiffEntry[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                RevCommit revCommit = candidate.getParent(i3);
                if (objectIdArray != null && objectIdArray[i3] != null || (object3 = this.findRename(revCommit, candidate.sourceCommit, candidate.sourcePath)) == null) continue;
                if (candidate instanceof Candidate$ReverseCandidate) {
                    if (objectIdArray == null) {
                        objectIdArray = new ObjectId[n3];
                    }
                    objectIdArray[n3] = ((DiffEntry)object3).getOldId().toObjectId();
                } else if (0 == ((DiffEntry)object3).getOldId().prefixCompare(candidate.sourceBlob)) {
                    candidate.sourcePath = PathFilter.create(((DiffEntry)object3).getOldPath());
                    return this.blameEntireRegionOnParent(candidate, revCommit);
                }
                diffEntryArray[i3] = object3;
            }
        }
        Candidate[] candidateArray = new Candidate[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            Candidate candidate2;
            object3 = candidate.getParent(n2);
            if (diffEntryArray != null && diffEntryArray[n2] != null) {
                candidate2 = candidate.create(this.getRepository(), (RevCommit)object3, PathFilter.create(diffEntryArray[n2].getOldPath()));
                candidate2.renameScore = diffEntryArray[n2].getScore();
                candidate2.sourceBlob = diffEntryArray[n2].getOldId().toObjectId();
            } else {
                if (objectIdArray == null || objectIdArray[n2] == null) continue;
                candidate2 = candidate.create(this.getRepository(), (RevCommit)object3, candidate.sourcePath);
                candidate2.sourceBlob = objectIdArray[n2];
            }
            if (candidate instanceof Candidate$ReverseCandidate && candidate2.sourceBlob.equals(candidate.sourceBlob)) {
                candidate2.sourceText = candidate.sourceText;
                object2 = new EditList(0);
            } else {
                candidate2.loadText(this.reader);
                object2 = this.diffAlgorithm.diff(this.textComparator, candidate2.sourceText, candidate.sourceText);
            }
            if (((ArrayList)object2).isEmpty()) {
                if (candidate instanceof Candidate$ReverseCandidate) {
                    candidateArray[n2] = candidate2;
                    continue;
                }
                candidate2.regionList = candidate.regionList;
                candidate.regionList = null;
                candidateArray[n2] = candidate2;
                break;
            }
            candidate2.takeBlame((EditList)object2, candidate);
            if (candidate2.regionList == null) continue;
            if (candidate instanceof Candidate$ReverseCandidate) {
                object = candidate2.regionList;
                candidate2.regionList = candidate.regionList;
                candidate.regionList = object;
            }
            candidateArray[n2] = candidate2;
        }
        if (candidate instanceof Candidate$ReverseCandidate) {
            Candidate candidate3 = null;
            object3 = null;
            for (int i4 = 0; i4 < n3; ++i4) {
                object2 = candidateArray[i4];
                if (object2 == null) continue;
                if (((Candidate)object2).regionList != null) {
                    object = ((Candidate)object2).copy(((Candidate)object2).sourceCommit);
                    if (object3 != null) {
                        ((Candidate)object3).queueNext = object;
                        object3 = object;
                    } else {
                        candidate3 = object;
                        object3 = object;
                    }
                }
                if (candidate.regionList == null) continue;
                ((Candidate)object2).regionList = candidate.regionList.deepCopy();
                this.push((Candidate)object2);
            }
            if (candidate3 != null) {
                return this.result(candidate3);
            }
            return false;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (candidateArray[n2] == null) continue;
            this.push(candidateArray[n2]);
        }
        if (candidate.regionList != null) {
            return this.result(candidate);
        }
        return false;
    }

    public RevCommit getSourceCommit() {
        return this.outCandidate.sourceCommit;
    }

    public PersonIdent getSourceAuthor() {
        return this.outCandidate.getAuthor();
    }

    public PersonIdent getSourceCommitter() {
        RevCommit revCommit = this.getSourceCommit();
        return revCommit != null ? revCommit.getCommitterIdent() : null;
    }

    public String getSourcePath() {
        return this.outCandidate.sourcePath.getPath();
    }

    public int getRenameScore() {
        return this.outCandidate.renameScore;
    }

    public int getSourceStart() {
        return this.outRegion.sourceStart;
    }

    public int getSourceEnd() {
        Region region = this.outRegion;
        return region.sourceStart + region.length;
    }

    public int getResultStart() {
        return this.outRegion.resultStart;
    }

    public int getResultEnd() {
        Region region = this.outRegion;
        return region.resultStart + region.length;
    }

    public int getRegionLength() {
        return this.outRegion.length;
    }

    public RawText getSourceContents() {
        return this.outCandidate.sourceText;
    }

    public RawText getResultContents() {
        return this.queue != null ? this.queue.sourceText : null;
    }

    @Override
    public void close() {
        this.revPool.close();
        this.queue = null;
        this.outCandidate = null;
        this.outRegion = null;
    }

    private boolean find(RevCommit revCommit, PathFilter pathFilter) {
        this.treeWalk.setFilter(pathFilter);
        this.treeWalk.reset((AnyObjectId)revCommit.getTree());
        if (this.treeWalk.next() && BlameGenerator.isFile(this.treeWalk.getRawMode(0))) {
            this.treeWalk.getObjectId(this.idBuf, 0);
            return true;
        }
        return false;
    }

    private static final boolean isFile(int n2) {
        return (n2 & 0xF000) == 32768;
    }

    private DiffEntry findRename(RevCommit revCommit, RevCommit revCommit2, PathFilter pathFilter) {
        if (this.renameDetector == null) {
            return null;
        }
        this.treeWalk.setFilter(TreeFilter.ANY_DIFF);
        this.treeWalk.reset(revCommit.getTree(), revCommit2.getTree());
        this.renameDetector.reset();
        this.renameDetector.addAll(DiffEntry.scan(this.treeWalk));
        for (DiffEntry diffEntry : this.renameDetector.compute()) {
            if (!BlameGenerator.isRename(diffEntry) || !diffEntry.getNewPath().equals(pathFilter.getPath())) continue;
            return diffEntry;
        }
        return null;
    }

    private static boolean isRename(DiffEntry diffEntry) {
        return diffEntry.getChangeType() == DiffEntry$ChangeType.RENAME || diffEntry.getChangeType() == DiffEntry$ChangeType.COPY;
    }
}

