/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.attributes;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jgit.attributes.FilterCommand;
import org.eclipse.jgit.attributes.FilterCommandFactory;
import org.eclipse.jgit.lib.Repository;

public class FilterCommandRegistry {
    private static Map filterCommandRegistry = new ConcurrentHashMap();

    public static FilterCommandFactory register(String string, FilterCommandFactory filterCommandFactory) {
        return filterCommandRegistry.put(string, filterCommandFactory);
    }

    public static FilterCommandFactory unregister(String string) {
        return (FilterCommandFactory)filterCommandRegistry.remove(string);
    }

    public static boolean isRegistered(String string) {
        return filterCommandRegistry.containsKey(string);
    }

    public static Set getRegisteredFilterCommands() {
        return filterCommandRegistry.keySet();
    }

    public static FilterCommand createFilterCommand(String string, Repository repository, InputStream inputStream, OutputStream outputStream) {
        FilterCommandFactory filterCommandFactory = (FilterCommandFactory)filterCommandRegistry.get(string);
        return filterCommandFactory == null ? null : filterCommandFactory.create(repository, inputStream, outputStream);
    }
}

