/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.attributes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.attributes.Attribute;
import org.eclipse.jgit.attributes.Attribute$State;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.ignore.IMatcher;
import org.eclipse.jgit.ignore.internal.PathMatcher;

public class AttributesRule {
    private static final String ATTRIBUTES_SPLIT_REGEX = "[ \t\r]";
    private final String pattern;
    private final List attributes;
    private final boolean nameOnly;
    private final boolean dirOnly;
    private final IMatcher matcher;

    private static List parseAttributes(String string) {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        for (String string2 : string.split(ATTRIBUTES_SPLIT_REGEX)) {
            if ((string2 = string2.trim()).length() == 0) continue;
            if (string2.startsWith("-")) {
                if (string2.length() <= 1) continue;
                arrayList.add(new Attribute(string2.substring(1), Attribute$State.UNSET));
                continue;
            }
            if (string2.startsWith("!")) {
                if (string2.length() <= 1) continue;
                arrayList.add(new Attribute(string2.substring(1), Attribute$State.UNSPECIFIED));
                continue;
            }
            int n2 = string2.indexOf(61);
            if (n2 == -1) {
                arrayList.add(new Attribute(string2, Attribute$State.SET));
                continue;
            }
            String string3 = string2.substring(0, n2);
            if (string3.length() <= 0) continue;
            String string4 = string2.substring(n2 + 1);
            arrayList.add(new Attribute(string3, string4));
        }
        return arrayList;
    }

    public AttributesRule(String string, String string2) {
        this.attributes = AttributesRule.parseAttributes(string2);
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
            this.dirOnly = true;
        } else {
            this.dirOnly = false;
        }
        int n2 = string.indexOf(47);
        if (n2 < 0) {
            this.nameOnly = true;
        } else if (n2 == 0) {
            this.nameOnly = false;
        } else {
            this.nameOnly = false;
            string = "/" + string;
        }
        IMatcher iMatcher = IMatcher.NO_MATCH;
        try {
            iMatcher = PathMatcher.createPathMatcher(string, Character.valueOf('/'), this.dirOnly);
        }
        catch (InvalidPatternException invalidPatternException) {
            // empty catch block
        }
        this.matcher = iMatcher;
        this.pattern = string;
    }

    public boolean isDirOnly() {
        return this.dirOnly;
    }

    public List getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    public boolean isNameOnly() {
        return this.nameOnly;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean isMatch(String string, boolean bl2) {
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return false;
        }
        boolean bl3 = this.matcher.matches(string, bl2, true);
        return bl3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.pattern);
        for (Attribute attribute : this.attributes) {
            stringBuilder.append(" ");
            stringBuilder.append(attribute);
        }
        return stringBuilder.toString();
    }
}

