/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.attributes;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.attributes.Attribute;
import org.eclipse.jgit.attributes.Attribute$State;
import org.eclipse.jgit.attributes.Attributes;
import org.eclipse.jgit.attributes.AttributesNode;
import org.eclipse.jgit.attributes.AttributesNodeProvider;
import org.eclipse.jgit.attributes.AttributesRule;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.TreeWalk$OperationType;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;

public class AttributesHandler {
    private static final String MACRO_PREFIX = "[attr]";
    private static final String BINARY_RULE_KEY = "binary";
    private static final List BINARY_RULE_ATTRIBUTES = new AttributesRule("[attr]binary", "-diff -merge -text").getAttributes();
    private final TreeWalk treeWalk;
    private final AttributesNode globalNode;
    private final AttributesNode infoNode;
    private final Map expansions = new HashMap();

    public AttributesHandler(TreeWalk treeWalk) {
        this.treeWalk = treeWalk;
        AttributesNodeProvider attributesNodeProvider = treeWalk.getAttributesNodeProvider();
        this.globalNode = attributesNodeProvider != null ? attributesNodeProvider.getGlobalAttributesNode() : null;
        this.infoNode = attributesNodeProvider != null ? attributesNodeProvider.getInfoAttributesNode() : null;
        AttributesNode attributesNode = AttributesHandler.attributesNode(treeWalk, (WorkingTreeIterator)AttributesHandler.rootOf(treeWalk.getTree(WorkingTreeIterator.class)), (DirCacheIterator)AttributesHandler.rootOf(treeWalk.getTree(DirCacheIterator.class)), (CanonicalTreeParser)AttributesHandler.rootOf(treeWalk.getTree(CanonicalTreeParser.class)));
        this.expansions.put(BINARY_RULE_KEY, BINARY_RULE_ATTRIBUTES);
        for (AttributesNode attributesNode2 : new AttributesNode[]{this.globalNode, attributesNode, this.infoNode}) {
            if (attributesNode2 == null) continue;
            for (AttributesRule attributesRule : attributesNode2.getRules()) {
                if (!attributesRule.getPattern().startsWith(MACRO_PREFIX)) continue;
                this.expansions.put(attributesRule.getPattern().substring(MACRO_PREFIX.length()).trim(), attributesRule.getAttributes());
            }
        }
    }

    public Attributes getAttributes() {
        String string = this.treeWalk.getPathString();
        boolean bl2 = this.treeWalk.getFileMode() == FileMode.TREE;
        Attributes attributes = new Attributes(new Attribute[0]);
        this.mergeInfoAttributes(string, bl2, attributes);
        this.mergePerDirectoryEntryAttributes(string, string.lastIndexOf(47), bl2, (WorkingTreeIterator)this.treeWalk.getTree(WorkingTreeIterator.class), (DirCacheIterator)this.treeWalk.getTree(DirCacheIterator.class), (CanonicalTreeParser)this.treeWalk.getTree(CanonicalTreeParser.class), attributes);
        this.mergeGlobalAttributes(string, bl2, attributes);
        for (Attribute attribute : attributes.getAll()) {
            if (attribute.getState() != Attribute$State.UNSPECIFIED) continue;
            attributes.remove(attribute.getKey());
        }
        return attributes;
    }

    private void mergeGlobalAttributes(String string, boolean bl2, Attributes attributes) {
        this.mergeAttributes(this.globalNode, string, bl2, attributes);
    }

    private void mergeInfoAttributes(String string, boolean bl2, Attributes attributes) {
        this.mergeAttributes(this.infoNode, string, bl2, attributes);
    }

    private void mergePerDirectoryEntryAttributes(String string, int n2, boolean bl2, @Nullable WorkingTreeIterator workingTreeIterator, @Nullable DirCacheIterator dirCacheIterator, @Nullable CanonicalTreeParser canonicalTreeParser, Attributes attributes) {
        if (workingTreeIterator != null || dirCacheIterator != null || canonicalTreeParser != null) {
            AttributesNode attributesNode = AttributesHandler.attributesNode(this.treeWalk, workingTreeIterator, dirCacheIterator, canonicalTreeParser);
            if (attributesNode != null) {
                this.mergeAttributes(attributesNode, string.substring(n2 + 1), bl2, attributes);
            }
            this.mergePerDirectoryEntryAttributes(string, string.lastIndexOf(47, n2 - 1), bl2, (WorkingTreeIterator)AttributesHandler.parentOf(workingTreeIterator), (DirCacheIterator)AttributesHandler.parentOf(dirCacheIterator), (CanonicalTreeParser)AttributesHandler.parentOf(canonicalTreeParser), attributes);
        }
    }

    protected void mergeAttributes(@Nullable AttributesNode attributesNode, String string, boolean bl2, Attributes attributes) {
        if (attributesNode == null) {
            return;
        }
        List list = attributesNode.getRules();
        ListIterator listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            AttributesRule attributesRule = (AttributesRule)listIterator.previous();
            if (!attributesRule.isMatch(string, bl2)) continue;
            ListIterator listIterator2 = attributesRule.getAttributes().listIterator(attributesRule.getAttributes().size());
            while (listIterator2.hasPrevious()) {
                this.expandMacro((Attribute)listIterator2.previous(), attributes);
            }
        }
    }

    protected void expandMacro(Attribute attribute, Attributes attributes) {
        if (attributes.containsKey(attribute.getKey())) {
            return;
        }
        attributes.put(attribute);
        List list = (List)this.expansions.get(attribute.getKey());
        if (list == null) {
            return;
        }
        switch (attribute.getState()) {
            case UNSET: {
                block13: for (Attribute attribute2 : list) {
                    switch (attribute2.getState()) {
                        case SET: {
                            this.expandMacro(new Attribute(attribute2.getKey(), Attribute$State.UNSET), attributes);
                            continue block13;
                        }
                        case UNSET: {
                            this.expandMacro(new Attribute(attribute2.getKey(), Attribute$State.SET), attributes);
                            continue block13;
                        }
                        case UNSPECIFIED: {
                            this.expandMacro(new Attribute(attribute2.getKey(), Attribute$State.UNSPECIFIED), attributes);
                            continue block13;
                        }
                    }
                    this.expandMacro(attribute2, attributes);
                }
                break;
            }
            case CUSTOM: {
                block14: for (Attribute attribute3 : list) {
                    switch (attribute3.getState()) {
                        case SET: 
                        case UNSET: 
                        case UNSPECIFIED: {
                            this.expandMacro(attribute3, attributes);
                            continue block14;
                        }
                    }
                    this.expandMacro(new Attribute(attribute3.getKey(), attribute.getValue()), attributes);
                }
                break;
            }
            case UNSPECIFIED: {
                for (Attribute attribute4 : list) {
                    this.expandMacro(new Attribute(attribute4.getKey(), Attribute$State.UNSPECIFIED), attributes);
                }
                break;
            }
            default: {
                for (Attribute attribute5 : list) {
                    this.expandMacro(attribute5, attributes);
                }
            }
        }
    }

    private static AttributesNode attributesNode(TreeWalk treeWalk, @Nullable WorkingTreeIterator workingTreeIterator, @Nullable DirCacheIterator dirCacheIterator, @Nullable CanonicalTreeParser canonicalTreeParser) {
        AttributesNode attributesNode = null;
        switch (treeWalk.getOperationType()) {
            case CHECKIN_OP: {
                if (workingTreeIterator != null) {
                    attributesNode = workingTreeIterator.getEntryAttributesNode();
                }
                if (attributesNode == null && dirCacheIterator != null) {
                    attributesNode = dirCacheIterator.getEntryAttributesNode(treeWalk.getObjectReader());
                }
                if (attributesNode != null || canonicalTreeParser == null) break;
                attributesNode = canonicalTreeParser.getEntryAttributesNode(treeWalk.getObjectReader());
                break;
            }
            case CHECKOUT_OP: {
                if (canonicalTreeParser != null) {
                    attributesNode = canonicalTreeParser.getEntryAttributesNode(treeWalk.getObjectReader());
                }
                if (attributesNode == null && dirCacheIterator != null) {
                    attributesNode = dirCacheIterator.getEntryAttributesNode(treeWalk.getObjectReader());
                }
                if (attributesNode != null || workingTreeIterator == null) break;
                attributesNode = workingTreeIterator.getEntryAttributesNode();
                break;
            }
            default: {
                throw new IllegalStateException("The only supported operation types are:" + (Object)((Object)TreeWalk$OperationType.CHECKIN_OP) + "," + (Object)((Object)TreeWalk$OperationType.CHECKOUT_OP));
            }
        }
        return attributesNode;
    }

    private static AbstractTreeIterator parentOf(@Nullable AbstractTreeIterator abstractTreeIterator) {
        AbstractTreeIterator abstractTreeIterator2;
        if (abstractTreeIterator == null) {
            return null;
        }
        Class<?> clazz = abstractTreeIterator.getClass();
        if (clazz.isInstance(abstractTreeIterator2 = abstractTreeIterator.parent)) {
            return (AbstractTreeIterator)clazz.cast(abstractTreeIterator2);
        }
        return null;
    }

    private static AbstractTreeIterator rootOf(@Nullable AbstractTreeIterator abstractTreeIterator) {
        if (abstractTreeIterator == null) {
            return null;
        }
        AbstractTreeIterator abstractTreeIterator2 = abstractTreeIterator;
        while (abstractTreeIterator2 != null && abstractTreeIterator2.parent != null) {
            abstractTreeIterator2 = abstractTreeIterator2.parent;
        }
        Class<?> clazz = abstractTreeIterator.getClass();
        if (clazz.isInstance(abstractTreeIterator2)) {
            return (AbstractTreeIterator)clazz.cast(abstractTreeIterator2);
        }
        return null;
    }
}

