/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.attributes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jgit.attributes.Attribute;
import org.eclipse.jgit.attributes.Attribute$State;

public final class Attributes {
    private final Map map = new LinkedHashMap();

    public Attributes(Attribute ... attributeArray) {
        if (attributeArray != null) {
            for (Attribute attribute : attributeArray) {
                this.put(attribute);
            }
        }
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Attribute get(String string) {
        return (Attribute)this.map.get(string);
    }

    public Collection getAll() {
        return new ArrayList(this.map.values());
    }

    public void put(Attribute attribute) {
        this.map.put(attribute.getKey(), attribute);
    }

    public void remove(String string) {
        this.map.remove(string);
    }

    public boolean containsKey(String string) {
        return this.map.containsKey(string);
    }

    public Attribute$State getState(String string) {
        Attribute attribute = (Attribute)this.map.get(string);
        return attribute != null ? attribute.getState() : Attribute$State.UNSPECIFIED;
    }

    public boolean isSet(String string) {
        return this.getState(string) == Attribute$State.SET;
    }

    public boolean isUnset(String string) {
        return this.getState(string) == Attribute$State.UNSET;
    }

    public boolean isUnspecified(String string) {
        return this.getState(string) == Attribute$State.UNSPECIFIED;
    }

    public boolean isCustom(String string) {
        return this.getState(string) == Attribute$State.CUSTOM;
    }

    public String getValue(String string) {
        Attribute attribute = (Attribute)this.map.get(string);
        return attribute != null ? attribute.getValue() : null;
    }

    public boolean canBeContentMerged() {
        if (this.isUnset("merge")) {
            return false;
        }
        return !this.isCustom("merge") || !this.getValue("merge").equals("binary");
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append("[");
        stringBuilder.append(" ");
        for (Attribute attribute : this.map.values()) {
            stringBuilder.append(attribute.toString());
            stringBuilder.append(" ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Attributes)) {
            return false;
        }
        Attributes attributes = (Attributes)object;
        return this.map.equals(attributes.map);
    }
}

