/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.attributes;

import org.eclipse.jgit.attributes.Attribute$State;

public final class Attribute {
    private final String key;
    private final Attribute$State state;
    private final String value;

    public Attribute(String string, Attribute$State state) {
        this(string, state, null);
    }

    private Attribute(String string, Attribute$State state, String string2) {
        if (string == null) {
            throw new NullPointerException("The key of an attribute should not be null");
        }
        if (state == null) {
            throw new NullPointerException("The state of an attribute should not be null");
        }
        this.key = string;
        this.state = state;
        this.value = string2;
    }

    public Attribute(String string, String string2) {
        this(string, Attribute$State.CUSTOM, string2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)object;
        if (!this.key.equals(attribute.key)) {
            return false;
        }
        if (this.state != attribute.state) {
            return false;
        }
        return !(this.value == null ? attribute.value != null : !this.value.equals(attribute.value));
    }

    public String getKey() {
        return this.key;
    }

    public Attribute$State getState() {
        return this.state;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + this.key.hashCode();
        n3 = 31 * n3 + this.state.hashCode();
        n3 = 31 * n3 + (this.value == null ? 0 : this.value.hashCode());
        return n3;
    }

    public String toString() {
        switch (this.state) {
            case SET: {
                return this.key;
            }
            case UNSET: {
                return "-" + this.key;
            }
            case UNSPECIFIED: {
                return "!" + this.key;
            }
        }
        return this.key + "=" + this.value;
    }
}

