/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.VerificationResult;
import org.eclipse.jgit.api.VerifySignatureCommand$Result;
import org.eclipse.jgit.api.VerifySignatureCommand$VerifyMode;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.ServiceUnavailableException;
import org.eclipse.jgit.api.errors.WrongObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.GpgConfig;
import org.eclipse.jgit.lib.GpgSignatureVerifier;
import org.eclipse.jgit.lib.GpgSignatureVerifierFactory;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;

public class VerifySignatureCommand
extends GitCommand {
    private final Set namesToCheck = new HashSet();
    private VerifySignatureCommand$VerifyMode mode = VerifySignatureCommand$VerifyMode.ANY;
    private GpgSignatureVerifier verifier;
    private GpgConfig config;
    private boolean ownVerifier;

    public VerifySignatureCommand(Repository repository) {
        super(repository);
    }

    public VerifySignatureCommand addName(String string) {
        this.checkCallable();
        this.namesToCheck.add(string);
        return this;
    }

    public VerifySignatureCommand addNames(String ... stringArray) {
        this.checkCallable();
        this.namesToCheck.addAll(Arrays.asList(stringArray));
        return this;
    }

    public VerifySignatureCommand addNames(Collection collection) {
        this.checkCallable();
        this.namesToCheck.addAll(collection);
        return this;
    }

    public VerifySignatureCommand setMode(@NonNull VerifySignatureCommand$VerifyMode verifySignatureCommand$VerifyMode) {
        this.checkCallable();
        this.mode = verifySignatureCommand$VerifyMode;
        return this;
    }

    public VerifySignatureCommand setVerifier(GpgSignatureVerifier gpgSignatureVerifier) {
        this.checkCallable();
        this.verifier = gpgSignatureVerifier;
        return this;
    }

    public VerifySignatureCommand setGpgConfig(GpgConfig gpgConfig) {
        this.checkCallable();
        this.config = gpgConfig;
        return this;
    }

    public GpgSignatureVerifier getVerifier() {
        return this.verifier;
    }

    @Override
    @NonNull
    public Map call() {
        Object object;
        this.checkCallable();
        this.setCallable(false);
        HashMap<String, VerificationResult> hashMap = new HashMap<String, VerificationResult>();
        if (this.verifier == null) {
            object = GpgSignatureVerifierFactory.getDefault();
            if (object == null) {
                throw new ServiceUnavailableException(JGitText.get().signatureVerificationUnavailable);
            }
            this.verifier = ((GpgSignatureVerifierFactory)object).getVerifier();
            this.ownVerifier = true;
        }
        if (this.config == null) {
            this.config = new GpgConfig(this.repo.getConfig());
        }
        try {
            object = new RevWalk(this.repo);
            Throwable throwable = null;
            try {
                for (String string : this.namesToCheck) {
                    RevObject revObject;
                    ObjectId objectId = this.repo.resolve(string);
                    if (objectId == null || ObjectId.zeroId().equals(objectId)) continue;
                    try {
                        revObject = ((RevWalk)object).parseAny(objectId);
                    }
                    catch (MissingObjectException missingObjectException) {
                        continue;
                    }
                    VerificationResult verificationResult = this.verifyOne(revObject);
                    if (verificationResult == null) continue;
                    hashMap.put(string, verificationResult);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((RevWalk)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((RevWalk)object).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new JGitInternalException(JGitText.get().signatureVerificationError, iOException);
        }
        finally {
            if (this.ownVerifier) {
                this.verifier.clear();
            }
        }
        return hashMap;
    }

    private VerificationResult verifyOne(RevObject revObject) {
        int n2 = revObject.getType();
        if (VerifySignatureCommand$VerifyMode.TAGS.equals((Object)this.mode) && n2 != 4) {
            throw new WrongObjectTypeException(revObject, 4);
        }
        if (VerifySignatureCommand$VerifyMode.COMMITS.equals((Object)this.mode) && n2 != 1) {
            throw new WrongObjectTypeException(revObject, 1);
        }
        if (n2 == 1 || n2 == 4) {
            try {
                GpgSignatureVerifier.SignatureVerification signatureVerification = this.verifier.verifySignature(revObject, this.config);
                if (signatureVerification == null) {
                    return null;
                }
                return new VerifySignatureCommand$Result(revObject, signatureVerification, null);
            }
            catch (JGitInternalException jGitInternalException) {
                return new VerifySignatureCommand$Result(revObject, null, jGitInternalException);
            }
        }
        return null;
    }
}

