/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.Transport;

public abstract class TransportCommand
extends GitCommand {
    protected CredentialsProvider credentialsProvider;
    protected int timeout;
    protected TransportConfigCallback transportConfigCallback;

    protected TransportCommand(Repository repository) {
        super(repository);
        this.setCredentialsProvider(CredentialsProvider.getDefault());
    }

    public GitCommand setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this.self();
    }

    public GitCommand setTimeout(int n2) {
        this.timeout = n2;
        return this.self();
    }

    public GitCommand setTransportConfigCallback(TransportConfigCallback transportConfigCallback) {
        this.transportConfigCallback = transportConfigCallback;
        return this.self();
    }

    protected final GitCommand self() {
        return this;
    }

    protected GitCommand configure(Transport transport) {
        if (this.credentialsProvider != null) {
            transport.setCredentialsProvider(this.credentialsProvider);
        }
        transport.setTimeout(this.timeout);
        if (this.transportConfigCallback != null) {
            this.transportConfigCallback.configure(transport);
        }
        return this.self();
    }

    protected GitCommand configure(TransportCommand transportCommand) {
        transportCommand.setCredentialsProvider(this.credentialsProvider);
        transportCommand.setTimeout(this.timeout);
        transportCommand.setTransportConfigCallback(this.transportConfigCallback);
        return this.self();
    }
}

