/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.text.MessageFormat;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.InvalidTagNameException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.api.errors.ServiceUnavailableException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.GpgConfig;
import org.eclipse.jgit.lib.GpgObjectSigner;
import org.eclipse.jgit.lib.GpgSigner;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.RefUpdate$Result;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.CredentialsProvider;

public class TagCommand
extends GitCommand {
    private RevObject id;
    private String name;
    private String message;
    private PersonIdent tagger;
    private Boolean signed;
    private boolean forceUpdate;
    private Boolean annotated;
    private String signingKey;
    private GpgConfig gpgConfig;
    private GpgObjectSigner gpgSigner;
    private CredentialsProvider credentialsProvider = CredentialsProvider.getDefault();

    protected TagCommand(Repository repository) {
        super(repository);
    }

    /*
     * Exception decompiling
     */
    @Override
    public Ref call() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Ref updateTagRef(ObjectId objectId, RevWalk revWalk, String string, String string2) {
        String string3 = "refs/tags/" + string;
        RefUpdate refUpdate = this.repo.updateRef(string3);
        refUpdate.setNewObjectId(objectId);
        refUpdate.setForceUpdate(this.forceUpdate);
        refUpdate.setRefLogMessage("tagged " + this.name, false);
        RefUpdate$Result refUpdate$Result = refUpdate.update(revWalk);
        switch (refUpdate$Result) {
            case NEW: 
            case FORCED: 
            case LOCK_FAILURE: {
                throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, refUpdate.getRef(), refUpdate$Result);
            }
            case NO_CHANGE: {
                if (this.forceUpdate) {
                    return this.repo.exactRef(string3);
                }
                throw new RefAlreadyExistsException(MessageFormat.format(JGitText.get().tagAlreadyExists, string2), refUpdate$Result);
            }
            case REJECTED: {
                throw new RefAlreadyExistsException(MessageFormat.format(JGitText.get().tagAlreadyExists, string2), refUpdate$Result);
            }
        }
        throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, new Object[]{string3, string2, refUpdate$Result}));
    }

    private void processOptions(RepositoryState repositoryState) {
        if (this.name == null || !Repository.isValidRefName("refs/tags/" + this.name)) {
            throw new InvalidTagNameException(MessageFormat.format(JGitText.get().tagNameInvalid, this.name == null ? "<null>" : this.name));
        }
        if (!this.isAnnotated()) {
            if (this.message != null && !this.message.isEmpty() || this.tagger != null) {
                throw new JGitInternalException(JGitText.get().messageAndTaggerNotAllowedInUnannotatedTags);
            }
        } else {
            if (this.tagger == null) {
                this.tagger = new PersonIdent(this.repo);
            }
            if (!Boolean.FALSE.equals(this.signed) || this.signingKey != null) {
                boolean bl2;
                if (this.gpgConfig == null) {
                    this.gpgConfig = new GpgConfig(this.repo.getConfig());
                }
                boolean bl3 = bl2 = this.isSigned() || this.gpgConfig.isSignAllTags();
                if (!Boolean.TRUE.equals(this.annotated) && !bl2) {
                    bl2 = this.gpgConfig.isSignAnnotated();
                }
                if (bl2) {
                    if (this.signingKey == null) {
                        this.signingKey = this.gpgConfig.getSigningKey();
                    }
                    if (this.gpgSigner == null) {
                        GpgSigner gpgSigner = GpgSigner.getDefault();
                        if (!(gpgSigner instanceof GpgObjectSigner)) {
                            throw new ServiceUnavailableException(JGitText.get().signingServiceUnavailable);
                        }
                        this.gpgSigner = (GpgObjectSigner)((Object)gpgSigner);
                    }
                    if (this.message != null && !this.message.isEmpty() && !this.message.endsWith("\n")) {
                        this.message = this.message + '\n';
                    }
                }
            }
        }
    }

    public TagCommand setName(String string) {
        this.checkCallable();
        this.name = string;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getMessage() {
        return this.message;
    }

    public TagCommand setMessage(String string) {
        this.checkCallable();
        this.message = string;
        return this;
    }

    public boolean isSigned() {
        return Boolean.TRUE.equals(this.signed) || this.signingKey != null;
    }

    public TagCommand setSigned(boolean bl2) {
        this.checkCallable();
        this.signed = bl2;
        return this;
    }

    public TagCommand setGpgSigner(GpgObjectSigner gpgObjectSigner) {
        this.checkCallable();
        this.gpgSigner = gpgObjectSigner;
        return this;
    }

    public TagCommand setGpgConfig(GpgConfig gpgConfig) {
        this.checkCallable();
        this.gpgConfig = gpgConfig;
        return this;
    }

    public TagCommand setTagger(PersonIdent personIdent) {
        this.checkCallable();
        this.tagger = personIdent;
        return this;
    }

    public PersonIdent getTagger() {
        return this.tagger;
    }

    public RevObject getObjectId() {
        return this.id;
    }

    public TagCommand setObjectId(RevObject revObject) {
        this.checkCallable();
        this.id = revObject;
        return this;
    }

    public boolean isForceUpdate() {
        return this.forceUpdate;
    }

    public TagCommand setForceUpdate(boolean bl2) {
        this.checkCallable();
        this.forceUpdate = bl2;
        return this;
    }

    public TagCommand setAnnotated(boolean bl2) {
        this.checkCallable();
        this.annotated = bl2;
        return this;
    }

    public boolean isAnnotated() {
        boolean bl2;
        boolean bl3 = bl2 = Boolean.TRUE.equals(this.annotated) || this.isSigned();
        if (bl2) {
            return true;
        }
        return this.annotated == null;
    }

    public TagCommand setSigningKey(String string) {
        this.checkCallable();
        this.signingKey = string;
        return this;
    }

    public String getSigningKey() {
        return this.signingKey;
    }

    public TagCommand setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.checkCallable();
        this.credentialsProvider = credentialsProvider;
        return this;
    }
}

