/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CloneCommand$Callback;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.FetchCommand$Callback;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.InvalidConfigurationException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;

public class SubmoduleUpdateCommand
extends TransportCommand {
    private ProgressMonitor monitor;
    private final Collection paths;
    private MergeStrategy strategy = MergeStrategy.RECURSIVE;
    private CloneCommand$Callback callback;
    private FetchCommand$Callback fetchCallback;
    private boolean fetch = false;

    public SubmoduleUpdateCommand(Repository repository) {
        super(repository);
        this.paths = new ArrayList();
    }

    public SubmoduleUpdateCommand setProgressMonitor(ProgressMonitor progressMonitor) {
        this.monitor = progressMonitor;
        return this;
    }

    public SubmoduleUpdateCommand setFetch(boolean bl2) {
        this.fetch = bl2;
        return this;
    }

    public SubmoduleUpdateCommand addPath(String string) {
        this.paths.add(string);
        return this;
    }

    private Repository getOrCloneSubmodule(SubmoduleWalk submoduleWalk, String string) {
        Repository repository = submoduleWalk.getRepository();
        if (repository == null) {
            if (this.callback != null) {
                this.callback.cloningSubmodule(submoduleWalk.getPath());
            }
            CloneCommand cloneCommand = Git.cloneRepository();
            this.configure(cloneCommand);
            cloneCommand.setURI(string);
            cloneCommand.setDirectory(submoduleWalk.getDirectory());
            cloneCommand.setGitDir(new File(new File(this.repo.getDirectory(), "modules"), submoduleWalk.getPath()));
            if (this.monitor != null) {
                cloneCommand.setProgressMonitor(this.monitor);
            }
            repository = cloneCommand.call().getRepository();
        } else if (this.fetch) {
            if (this.fetchCallback != null) {
                this.fetchCallback.fetchingSubmodule(submoduleWalk.getPath());
            }
            FetchCommand fetchCommand = Git.wrap(repository).fetch();
            if (this.monitor != null) {
                fetchCommand.setProgressMonitor(this.monitor);
            }
            this.configure(fetchCommand);
            fetchCommand.call();
        }
        return repository;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection call() {
        this.checkCallable();
        try (SubmoduleWalk submoduleWalk = SubmoduleWalk.forIndex(this.repo);){
            Object object;
            if (!this.paths.isEmpty()) {
                submoduleWalk.setFilter(PathFilterGroup.createFromStrings(this.paths));
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            while (submoduleWalk.next()) {
                block44: {
                    if (submoduleWalk.getModulesPath() == null || (object = submoduleWalk.getConfigUrl()) == null) continue;
                    try (Repository repository = this.getOrCloneSubmodule(submoduleWalk, (String)object);
                         RevWalk revWalk = new RevWalk(repository);){
                        Object object2;
                        RevCommit revCommit = revWalk.parseCommit(submoduleWalk.getObjectId());
                        String string = submoduleWalk.getConfigUpdate();
                        if ("merge".equals(string)) {
                            object2 = new MergeCommand(repository);
                            ((MergeCommand)object2).include(revCommit);
                            ((MergeCommand)object2).setProgressMonitor(this.monitor);
                            ((MergeCommand)object2).setStrategy(this.strategy);
                            ((MergeCommand)object2).call();
                            break block44;
                        }
                        if ("rebase".equals(string)) {
                            object2 = new RebaseCommand(repository);
                            ((RebaseCommand)object2).setUpstream(revCommit);
                            ((RebaseCommand)object2).setProgressMonitor(this.monitor);
                            ((RebaseCommand)object2).setStrategy(this.strategy);
                            ((RebaseCommand)object2).call();
                            break block44;
                        }
                        object2 = new DirCacheCheckout(repository, repository.lockDirCache(), revCommit.getTree());
                        ((DirCacheCheckout)object2).setFailOnConflict(true);
                        ((DirCacheCheckout)object2).setProgressMonitor(this.monitor);
                        ((DirCacheCheckout)object2).checkout();
                        RefUpdate refUpdate = repository.updateRef("HEAD", true);
                        refUpdate.setNewObjectId(revCommit);
                        refUpdate.forceUpdate();
                        if (this.callback != null) {
                            this.callback.checkingOut(revCommit, submoduleWalk.getPath());
                        }
                    }
                }
                arrayList.add(submoduleWalk.getPath());
            }
            object = arrayList;
            return object;
        }
        catch (IOException iOException) {
            throw new JGitInternalException(iOException.getMessage(), iOException);
        }
        catch (ConfigInvalidException configInvalidException) {
            throw new InvalidConfigurationException(configInvalidException.getMessage(), configInvalidException);
        }
    }

    public SubmoduleUpdateCommand setStrategy(MergeStrategy mergeStrategy) {
        this.strategy = mergeStrategy;
        return this;
    }

    public SubmoduleUpdateCommand setCallback(CloneCommand$Callback cloneCommand$Callback) {
        this.callback = cloneCommand$Callback;
        return this;
    }

    public SubmoduleUpdateCommand setFetchCallback(FetchCommand$Callback fetchCommand$Callback) {
        this.fetchCallback = fetchCommand$Callback;
        return this;
    }
}

