/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;

public class SubmoduleSyncCommand
extends GitCommand {
    private final Collection paths = new ArrayList();

    public SubmoduleSyncCommand(Repository repository) {
        super(repository);
    }

    public SubmoduleSyncCommand addPath(String string) {
        this.paths.add(string);
        return this;
    }

    protected String getHeadBranch(Repository repository) {
        Ref ref = repository.exactRef("HEAD");
        if (ref != null && ref.isSymbolic()) {
            return Repository.shortenRefName(ref.getLeaf().getName());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map call() {
        this.checkCallable();
        try (SubmoduleWalk submoduleWalk = SubmoduleWalk.forIndex(this.repo);){
            Object object;
            if (!this.paths.isEmpty()) {
                submoduleWalk.setFilter(PathFilterGroup.createFromStrings(this.paths));
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            StoredConfig storedConfig = this.repo.getConfig();
            while (submoduleWalk.next()) {
                object = submoduleWalk.getRemoteUrl();
                if (object == null) continue;
                String string = submoduleWalk.getPath();
                storedConfig.setString("submodule", string, "url", (String)object);
                hashMap.put(string, object);
                Repository repository = submoduleWalk.getRepository();
                Throwable throwable = null;
                try {
                    if (repository == null) continue;
                    StoredConfig storedConfig2 = repository.getConfig();
                    String string2 = this.getHeadBranch(repository);
                    String string3 = null;
                    if (string2 != null) {
                        string3 = storedConfig2.getString("branch", string2, "remote");
                    }
                    if (string3 == null) {
                        string3 = "origin";
                    }
                    storedConfig2.setString("remote", string3, "url", (String)object);
                    storedConfig2.save();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (repository == null) continue;
                    if (throwable != null) {
                        try {
                            repository.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    repository.close();
                }
            }
            if (!hashMap.isEmpty()) {
                storedConfig.save();
            }
            object = hashMap;
            return object;
        }
        catch (IOException | ConfigInvalidException exception) {
            throw new JGitInternalException(exception.getMessage(), exception);
        }
    }
}

