/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.submodule.SubmoduleStatus;
import org.eclipse.jgit.submodule.SubmoduleStatusType;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;

public class SubmoduleStatusCommand
extends GitCommand {
    private final Collection paths = new ArrayList();

    public SubmoduleStatusCommand(Repository repository) {
        super(repository);
    }

    public SubmoduleStatusCommand addPath(String string) {
        this.paths.add(string);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map call() {
        this.checkCallable();
        try (SubmoduleWalk submoduleWalk = SubmoduleWalk.forIndex(this.repo);){
            Object object;
            if (!this.paths.isEmpty()) {
                submoduleWalk.setFilter(PathFilterGroup.createFromStrings(this.paths));
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            while (submoduleWalk.next()) {
                object = this.getStatus(submoduleWalk);
                hashMap.put(((SubmoduleStatus)object).getPath(), object);
            }
            object = hashMap;
            return object;
        }
        catch (IOException | ConfigInvalidException exception) {
            throw new JGitInternalException(exception.getMessage(), exception);
        }
    }

    private SubmoduleStatus getStatus(SubmoduleWalk submoduleWalk) {
        ObjectId objectId = submoduleWalk.getObjectId();
        String string = submoduleWalk.getPath();
        if (submoduleWalk.getModulesPath() == null) {
            return new SubmoduleStatus(SubmoduleStatusType.MISSING, string, objectId);
        }
        if (submoduleWalk.getConfigUrl() == null) {
            return new SubmoduleStatus(SubmoduleStatusType.UNINITIALIZED, string, objectId);
        }
        ObjectId objectId2 = null;
        try (Repository repository = submoduleWalk.getRepository();){
            if (repository == null) {
                SubmoduleStatus submoduleStatus = new SubmoduleStatus(SubmoduleStatusType.UNINITIALIZED, string, objectId);
                return submoduleStatus;
            }
            objectId2 = repository.resolve("HEAD");
        }
        if (objectId2 == null) {
            return new SubmoduleStatus(SubmoduleStatusType.UNINITIALIZED, string, objectId, objectId2);
        }
        if (!objectId2.equals(objectId)) {
            return new SubmoduleStatus(SubmoduleStatusType.REV_CHECKED_OUT, string, objectId, objectId2);
        }
        return new SubmoduleStatus(SubmoduleStatusType.INITIALIZED, string, objectId, objectId2);
    }
}

